/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import java.math.BigDecimal;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.ColumnPageValueConverter;
import org.apache.carbondata.core.datastore.page.DecimalColumnPage;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalConverterFactory;

public class LazyColumnPage
extends ColumnPage {
    private ColumnPage columnPage;
    private ColumnPageValueConverter converter;

    private LazyColumnPage(ColumnPage columnPage, ColumnPageValueConverter converter) {
        super(columnPage.getColumnPageEncoderMeta(), columnPage.getPageSize());
        this.columnPage = columnPage;
        this.converter = converter;
    }

    public static ColumnPage newPage(ColumnPage columnPage, ColumnPageValueConverter codec) {
        return new LazyColumnPage(columnPage, codec);
    }

    public String toString() {
        return String.format("[converter: %s, data type: %s", this.converter, this.columnPage.getDataType());
    }

    @Override
    public long getLong(int rowId) {
        DataType dataType = this.columnPage.getDataType();
        if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.BYTE) {
            return this.converter.decodeLong(this.columnPage.getByte(rowId));
        }
        if (dataType == DataTypes.SHORT) {
            return this.converter.decodeLong(this.columnPage.getShort(rowId));
        }
        if (dataType == DataTypes.SHORT_INT) {
            return this.converter.decodeLong(this.columnPage.getShortInt(rowId));
        }
        if (dataType == DataTypes.INT) {
            return this.converter.decodeLong(this.columnPage.getInt(rowId));
        }
        if (dataType == DataTypes.LONG) {
            return this.columnPage.getLong(rowId);
        }
        throw new RuntimeException("internal error: " + this.toString());
    }

    @Override
    public double getDouble(int rowId) {
        DataType dataType = this.columnPage.getDataType();
        if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.BYTE) {
            return this.converter.decodeDouble(this.columnPage.getByte(rowId));
        }
        if (dataType == DataTypes.SHORT) {
            return this.converter.decodeDouble(this.columnPage.getShort(rowId));
        }
        if (dataType == DataTypes.SHORT_INT) {
            return this.converter.decodeDouble(this.columnPage.getShortInt(rowId));
        }
        if (dataType == DataTypes.INT) {
            return this.converter.decodeDouble(this.columnPage.getInt(rowId));
        }
        if (dataType == DataTypes.LONG) {
            return this.converter.decodeDouble(this.columnPage.getLong(rowId));
        }
        if (dataType == DataTypes.FLOAT) {
            return this.converter.decodeDouble(this.columnPage.getFloat(rowId));
        }
        if (dataType == DataTypes.DOUBLE) {
            return this.columnPage.getDouble(rowId);
        }
        if (dataType == DataTypes.BINARY) {
            return this.converter.decodeDouble(this.columnPage.getByte(rowId));
        }
        throw new RuntimeException("internal error: " + this.toString());
    }

    @Override
    public float getFloat(int rowId) {
        return (float)this.getDouble(rowId);
    }

    @Override
    public BigDecimal getDecimal(int rowId) {
        DecimalConverterFactory.DecimalConverter decimalConverter = ((DecimalColumnPage)this.columnPage).getDecimalConverter();
        DataType dataType = this.columnPage.getDataType();
        if (dataType == DataTypes.BYTE) {
            return decimalConverter.getDecimal(this.converter.decodeLong(this.columnPage.getByte(rowId)));
        }
        if (dataType == DataTypes.SHORT) {
            return decimalConverter.getDecimal(this.converter.decodeLong(this.columnPage.getShort(rowId)));
        }
        if (dataType == DataTypes.SHORT_INT) {
            return decimalConverter.getDecimal(this.converter.decodeLong(this.columnPage.getShortInt(rowId)));
        }
        if (dataType == DataTypes.INT) {
            return decimalConverter.getDecimal(this.converter.decodeLong(this.columnPage.getInt(rowId)));
        }
        if (dataType == DataTypes.LONG || DataTypes.isDecimal(dataType)) {
            return this.columnPage.getDecimal(rowId);
        }
        throw new RuntimeException("internal error: " + this.toString());
    }

    @Override
    public byte[] getBytes(int rowId) {
        return this.columnPage.getBytes(rowId);
    }

    @Override
    public byte[] getBytePage() {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public short[] getShortPage() {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public byte[] getShortIntPage() {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public int[] getIntPage() {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public long[] getLongPage() {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public float[] getFloatPage() {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public double[] getDoublePage() {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public byte[][] getByteArrayPage() {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void putDecimal(int rowId, BigDecimal decimal) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public byte[] getDecimalPage() {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public byte[] getLVFlattenedBytePage() {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public byte[] getComplexChildrenLVFlattenedBytePage(DataType dataType) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public byte[] getComplexParentFlattenedBytePage() {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void convertValue(ColumnPageValueConverter codec) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void setBytePage(byte[] byteData) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void setShortPage(short[] shortData) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void setShortIntPage(byte[] shortIntData) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void setIntPage(int[] intData) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void setLongPage(long[] longData) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void setFloatPage(float[] floatData) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void setDoublePage(double[] doubleData) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void setByteArrayPage(byte[][] byteArray) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void freeMemory() {
        this.columnPage.freeMemory();
    }

    @Override
    public void putByte(int rowId, byte value) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void putShort(int rowId, short value) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void putInt(int rowId, int value) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void putLong(int rowId, long value) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void putDouble(int rowId, double value) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void putFloat(int rowId, float value) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void putBytes(int rowId, byte[] bytes) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void putShortInt(int rowId, int value) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void putBytes(int rowId, byte[] bytes, int offset, int length) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public byte getByte(int rowId) {
        return this.columnPage.getByte(rowId);
    }

    @Override
    public short getShort(int rowId) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public int getShortInt(int rowId) {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public int getInt(int rowId) {
        throw new UnsupportedOperationException("internal error");
    }
}

