/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.ColumnPageValueConverter;
import org.apache.carbondata.core.keygenerator.KeyGenerator;
import org.apache.carbondata.core.keygenerator.factory.KeyGeneratorFactory;
import org.apache.carbondata.core.localdictionary.PageLevelDictionary;
import org.apache.carbondata.core.localdictionary.exception.DictionaryThresholdReachedException;
import org.apache.carbondata.core.localdictionary.generator.LocalDictionaryGenerator;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.log4j.Logger;

public class LocalDictColumnPage
extends ColumnPage {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)LocalDictColumnPage.class.getName());
    private PageLevelDictionary pageLevelDictionary;
    private ColumnPage actualDataColumnPage;
    private ColumnPage encodedDataColumnPage;
    private boolean isActualPageMemoryFreed;
    private KeyGenerator keyGenerator;
    private int[] dummyKey;
    private boolean isDecoderBasedFallBackEnabled;

    protected LocalDictColumnPage(ColumnPage actualDataColumnPage, ColumnPage encodedColumnpage, LocalDictionaryGenerator localDictionaryGenerator, boolean isComplexTypePrimitive, boolean isDecoderBasedFallBackEnabled) {
        super(actualDataColumnPage.getColumnPageEncoderMeta(), actualDataColumnPage.getPageSize());
        if (!localDictionaryGenerator.isThresholdReached()) {
            this.pageLevelDictionary = new PageLevelDictionary(localDictionaryGenerator, actualDataColumnPage.getColumnSpec().getFieldName(), actualDataColumnPage.getDataType(), isComplexTypePrimitive, actualDataColumnPage.getColumnCompressorName());
            this.encodedDataColumnPage = encodedColumnpage;
            this.keyGenerator = KeyGeneratorFactory.getKeyGenerator(new int[]{100001});
            this.dummyKey = new int[1];
        } else {
            encodedColumnpage.freeMemory();
        }
        this.isDecoderBasedFallBackEnabled = isDecoderBasedFallBackEnabled;
        this.actualDataColumnPage = actualDataColumnPage;
    }

    @Override
    public byte[][] getByteArrayPage() {
        if (null != this.pageLevelDictionary) {
            return this.encodedDataColumnPage.getByteArrayPage();
        }
        return this.actualDataColumnPage.getByteArrayPage();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        if (null != this.pageLevelDictionary) {
            return this.encodedDataColumnPage.getByteBuffer();
        }
        return this.actualDataColumnPage.getByteBuffer();
    }

    @Override
    public boolean isLocalDictGeneratedPage() {
        return null != this.pageLevelDictionary;
    }

    @Override
    public void putBytes(int rowId, byte[] bytes) {
        if (null != this.pageLevelDictionary) {
            try {
                byte[] input;
                this.actualDataColumnPage.putBytes(rowId, bytes);
                DataType dataType = this.actualDataColumnPage.columnPageEncoderMeta.getStoreDataType();
                if (dataType == DataTypes.STRING) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length + 2);
                    byteBuffer.putShort((short)bytes.length);
                    byteBuffer.put(bytes);
                    input = byteBuffer.array();
                } else if (dataType == DataTypes.VARCHAR || dataType == DataTypes.BINARY) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length + 4);
                    byteBuffer.putInt(bytes.length);
                    byteBuffer.put(bytes);
                    input = byteBuffer.array();
                } else {
                    input = bytes;
                }
                this.dummyKey[0] = this.pageLevelDictionary.getDictionaryValue(input);
                this.encodedDataColumnPage.putBytes(rowId, this.keyGenerator.generateKey(this.dummyKey));
            }
            catch (DictionaryThresholdReachedException e) {
                LOGGER.warn((Object)("Local Dictionary threshold reached for the column: " + this.actualDataColumnPage.getColumnSpec().getFieldName() + ", " + e.getMessage()));
                this.pageLevelDictionary = null;
                this.encodedDataColumnPage.freeMemory();
                this.encodedDataColumnPage = null;
            }
        } else {
            this.actualDataColumnPage.putBytes(rowId, bytes);
        }
        if (this.pageSize <= rowId) {
            this.pageSize = rowId + 1;
        }
    }

    @Override
    public void disableLocalDictEncoding() {
        this.pageLevelDictionary = null;
        this.freeEncodedColumnPage();
    }

    @Override
    public PageLevelDictionary getColumnPageDictionary() {
        return this.pageLevelDictionary;
    }

    @Override
    public void setBytePage(byte[] byteData) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void setShortPage(short[] shortData) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void setShortIntPage(byte[] shortIntData) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void setIntPage(int[] intData) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void setLongPage(long[] longData) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void setFloatPage(float[] floatData) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void setDoublePage(double[] doubleData) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void setByteArrayPage(byte[][] byteArray) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void freeMemory() {
        if (null != this.encodedDataColumnPage) {
            this.encodedDataColumnPage.freeMemory();
        }
        if (this.isDecoderBasedFallBackEnabled) {
            this.actualDataColumnPage.freeMemory();
            this.isActualPageMemoryFreed = true;
        } else if (null == this.pageLevelDictionary) {
            this.actualDataColumnPage.freeMemory();
            this.isActualPageMemoryFreed = true;
        }
    }

    public void freeMemoryForce() {
        if (!this.isActualPageMemoryFreed) {
            this.actualDataColumnPage.freeMemory();
            this.isActualPageMemoryFreed = true;
        }
    }

    private void freeEncodedColumnPage() {
        if (null != this.encodedDataColumnPage) {
            this.encodedDataColumnPage.freeMemory();
            this.encodedDataColumnPage = null;
        }
    }

    @Override
    public void putByte(int rowId, byte value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void putShort(int rowId, short value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void putInt(int rowId, int value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void putLong(int rowId, long value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void putDouble(int rowId, double value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void putFloat(int rowId, float value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void putDecimal(int rowId, BigDecimal decimal) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void putShortInt(int rowId, int value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void putBytes(int rowId, byte[] bytes, int offset, int length) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public byte getByte(int rowId) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public short getShort(int rowId) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public int getShortInt(int rowId) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public int getInt(int rowId) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public long getLong(int rowId) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public float getFloat(int rowId) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public double getDouble(int rowId) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public BigDecimal getDecimal(int rowId) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public byte[] getBytes(int rowId) {
        return this.actualDataColumnPage.getBytes(rowId);
    }

    @Override
    public byte[] getBytePage() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public short[] getShortPage() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public byte[] getShortIntPage() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public int[] getIntPage() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public long[] getLongPage() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public float[] getFloatPage() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public double[] getDoublePage() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public byte[] getLVFlattenedBytePage() throws IOException {
        if (null != this.encodedDataColumnPage) {
            return this.encodedDataColumnPage.getLVFlattenedBytePage();
        }
        return this.actualDataColumnPage.getLVFlattenedBytePage();
    }

    @Override
    public byte[] getComplexChildrenLVFlattenedBytePage(DataType dataType) throws IOException {
        if (null != this.encodedDataColumnPage) {
            return this.encodedDataColumnPage.getComplexChildrenLVFlattenedBytePage(dataType);
        }
        return this.actualDataColumnPage.getComplexChildrenLVFlattenedBytePage(dataType);
    }

    @Override
    public byte[] getComplexParentFlattenedBytePage() throws IOException {
        if (null != this.encodedDataColumnPage) {
            return this.encodedDataColumnPage.getComplexParentFlattenedBytePage();
        }
        return this.actualDataColumnPage.getComplexParentFlattenedBytePage();
    }

    @Override
    public byte[] getDecimalPage() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void convertValue(ColumnPageValueConverter codec) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public long getPageLengthInBytes() throws IOException {
        if (null != this.pageLevelDictionary) {
            return this.encodedDataColumnPage.getPageLengthInBytes();
        }
        return this.actualDataColumnPage.getPageLengthInBytes();
    }
}

