/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import java.math.BigDecimal;
import org.apache.carbondata.core.datastore.page.ColumnPageValueConverter;
import org.apache.carbondata.core.datastore.page.DecimalColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.util.ByteUtil;

public class SafeDecimalColumnPage
extends DecimalColumnPage {
    private byte[] byteData;
    private short[] shortData;
    private int[] intData;
    private long[] longData;
    private byte[] shortIntData;
    private byte[][] byteArrayData;

    SafeDecimalColumnPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        super(columnPageEncoderMeta, pageSize);
        this.byteArrayData = new byte[pageSize][];
    }

    @Override
    public void setBytePage(byte[] byteData) {
        this.byteData = byteData;
    }

    @Override
    public void setShortPage(short[] shortData) {
        this.shortData = shortData;
    }

    @Override
    public void setShortIntPage(byte[] shortIntData) {
        this.shortIntData = shortIntData;
    }

    @Override
    public void setIntPage(int[] intData) {
        this.intData = intData;
    }

    @Override
    public void setLongPage(long[] longData) {
        this.longData = longData;
    }

    @Override
    public void setByteArrayPage(byte[][] byteArray) {
        this.byteArrayData = byteArray;
    }

    @Override
    public void putByte(int rowId, byte value) {
        this.byteData[rowId] = value;
    }

    @Override
    public void putShort(int rowId, short value) {
        this.shortData[rowId] = value;
    }

    @Override
    public void putInt(int rowId, int value) {
        this.intData[rowId] = value;
    }

    @Override
    public void putLong(int rowId, long value) {
        this.longData[rowId] = value;
    }

    @Override
    void putBytesAtRow(int rowId, byte[] bytes) {
        this.byteArrayData[rowId] = bytes;
    }

    @Override
    public void putDecimal(int rowId, BigDecimal decimal) {
        switch (this.decimalConverter.getDecimalConverterType()) {
            case DECIMAL_INT: {
                if (null == this.intData) {
                    this.intData = new int[this.pageSize];
                }
                this.putInt(rowId, (Integer)this.decimalConverter.convert(decimal));
                break;
            }
            case DECIMAL_LONG: {
                if (null == this.longData) {
                    this.longData = new long[this.pageSize];
                }
                this.putLong(rowId, (Long)this.decimalConverter.convert(decimal));
                break;
            }
            default: {
                this.putBytes(rowId, (byte[])this.decimalConverter.convert(decimal));
            }
        }
    }

    @Override
    public void putShortInt(int rowId, int value) {
        byte[] converted = ByteUtil.to3Bytes(value);
        System.arraycopy(converted, 0, this.shortIntData, rowId * 3, 3);
    }

    @Override
    public void putBytes(int rowId, byte[] bytes, int offset, int length) {
        this.byteArrayData[rowId] = new byte[length];
        System.arraycopy(bytes, offset, this.byteArrayData[rowId], 0, length);
    }

    @Override
    public byte getByte(int rowId) {
        return this.byteData[rowId];
    }

    @Override
    public byte[] getBytes(int rowId) {
        return this.byteArrayData[rowId];
    }

    @Override
    public short getShort(int rowId) {
        return this.shortData[rowId];
    }

    @Override
    public int getShortInt(int rowId) {
        return ByteUtil.valueOf3Bytes(this.shortIntData, rowId * 3);
    }

    @Override
    public int getInt(int rowId) {
        return this.intData[rowId];
    }

    @Override
    public long getLong(int rowId) {
        return this.longData[rowId];
    }

    @Override
    public void copyBytes(int rowId, byte[] dest, int destOffset, int length) {
        System.arraycopy(this.byteArrayData[rowId], 0, dest, destOffset, length);
    }

    @Override
    public void convertValue(ColumnPageValueConverter codec) {
        switch (this.decimalConverter.getDecimalConverterType()) {
            case DECIMAL_INT: {
                for (int i = 0; i < this.pageSize; ++i) {
                    codec.encode(i, this.intData[i]);
                }
                break;
            }
            case DECIMAL_LONG: {
                for (int i = 0; i < this.pageSize; ++i) {
                    codec.encode(i, this.longData[i]);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("not support value conversion on " + this.columnPageEncoderMeta.getStoreDataType() + " page");
            }
        }
    }

    @Override
    public byte[] getBytePage() {
        return this.byteData;
    }

    @Override
    public short[] getShortPage() {
        return this.shortData;
    }

    @Override
    public byte[] getShortIntPage() {
        return this.shortIntData;
    }

    @Override
    public int[] getIntPage() {
        return this.intData;
    }

    @Override
    public long[] getLongPage() {
        return this.longData;
    }

    @Override
    public byte[][] getByteArrayPage() {
        return this.byteArrayData;
    }

    @Override
    public void freeMemory() {
        this.byteArrayData = null;
        super.freeMemory();
    }
}

