/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.ColumnPageValueConverter;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.ByteUtil;

public class SafeFixLengthColumnPage
extends ColumnPage {
    private byte[] byteData;
    private short[] shortData;
    private int[] intData;
    private long[] longData;
    private float[] floatData;
    private double[] doubleData;
    private byte[] shortIntData;
    private byte[][] fixedLengthdata;
    private int totalLength;
    private int arrayElementCount = 0;

    SafeFixLengthColumnPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        super(columnPageEncoderMeta, pageSize);
    }

    @Override
    public void putByte(int rowId, byte value) {
        this.ensureArraySize(rowId, DataTypes.BYTE);
        this.byteData[rowId] = value;
        ++this.arrayElementCount;
        this.totalLength += DataTypes.BYTE.getSizeInBytes();
    }

    @Override
    public void putShort(int rowId, short value) {
        this.ensureArraySize(rowId, DataTypes.SHORT);
        this.shortData[rowId] = value;
        ++this.arrayElementCount;
        this.totalLength += DataTypes.SHORT.getSizeInBytes();
    }

    @Override
    public void putInt(int rowId, int value) {
        this.ensureArraySize(rowId, DataTypes.INT);
        this.intData[rowId] = value;
        ++this.arrayElementCount;
        this.totalLength += DataTypes.INT.getSizeInBytes();
    }

    @Override
    public void putLong(int rowId, long value) {
        this.ensureArraySize(rowId, DataTypes.LONG);
        this.longData[rowId] = value;
        ++this.arrayElementCount;
        this.totalLength += DataTypes.LONG.getSizeInBytes();
    }

    @Override
    public void putDouble(int rowId, double value) {
        this.ensureArraySize(rowId, DataTypes.DOUBLE);
        this.doubleData[rowId] = value;
        ++this.arrayElementCount;
        this.totalLength += DataTypes.DOUBLE.getSizeInBytes();
    }

    @Override
    public void putFloat(int rowId, float value) {
        this.ensureArraySize(rowId, DataTypes.FLOAT);
        this.floatData[rowId] = value;
        ++this.arrayElementCount;
        this.totalLength += DataTypes.FLOAT.getSizeInBytes();
    }

    @Override
    public void putBytes(int rowId, byte[] bytes) {
        this.ensureArraySize(rowId, DataTypes.BYTE_ARRAY);
        this.fixedLengthdata[rowId] = bytes;
        ++this.arrayElementCount;
        this.totalLength += bytes.length;
    }

    @Override
    public void putShortInt(int rowId, int value) {
        this.ensureArraySize(rowId, DataTypes.SHORT_INT);
        byte[] converted = ByteUtil.to3Bytes(value);
        System.arraycopy(converted, 0, this.shortIntData, rowId * 3, 3);
        ++this.arrayElementCount;
        this.totalLength += DataTypes.SHORT_INT.getSizeInBytes();
    }

    @Override
    public void putBytes(int rowId, byte[] bytes, int offset, int length) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putDecimal(int rowId, BigDecimal decimal) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getDecimalPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte getByte(int rowId) {
        return this.byteData[rowId];
    }

    @Override
    public short getShort(int rowId) {
        return this.shortData[rowId];
    }

    @Override
    public int getShortInt(int rowId) {
        return ByteUtil.valueOf3Bytes(this.shortIntData, rowId * 3);
    }

    @Override
    public int getInt(int rowId) {
        return this.intData[rowId];
    }

    @Override
    public long getLong(int rowId) {
        return this.longData[rowId];
    }

    @Override
    public float getFloat(int rowId) {
        return this.floatData[rowId];
    }

    @Override
    public double getDouble(int rowId) {
        return this.doubleData[rowId];
    }

    @Override
    public BigDecimal getDecimal(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getBytes(int rowId) {
        return this.fixedLengthdata[rowId];
    }

    @Override
    public byte[] getBytePage() {
        return this.byteData;
    }

    @Override
    public short[] getShortPage() {
        return this.shortData;
    }

    @Override
    public byte[] getShortIntPage() {
        return this.shortIntData;
    }

    @Override
    public int[] getIntPage() {
        return this.intData;
    }

    @Override
    public long[] getLongPage() {
        return this.longData;
    }

    @Override
    public float[] getFloatPage() {
        return this.floatData;
    }

    @Override
    public double[] getDoublePage() {
        return this.doubleData;
    }

    @Override
    public byte[][] getByteArrayPage() {
        byte[][] data = new byte[this.arrayElementCount][];
        for (int i = 0; i < this.arrayElementCount; ++i) {
            data[i] = this.fixedLengthdata[i];
        }
        return data;
    }

    @Override
    public byte[] getLVFlattenedBytePage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getComplexChildrenLVFlattenedBytePage(DataType dataType) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        for (int i = 0; i < this.arrayElementCount; ++i) {
            out.write(this.fixedLengthdata[i]);
        }
        return stream.toByteArray();
    }

    @Override
    public byte[] getComplexParentFlattenedBytePage() {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void setBytePage(byte[] byteData) {
        this.byteData = byteData;
    }

    @Override
    public void setShortPage(short[] shortData) {
        this.shortData = shortData;
    }

    @Override
    public void setShortIntPage(byte[] shortIntData) {
        this.shortIntData = shortIntData;
    }

    @Override
    public void setIntPage(int[] intData) {
        this.intData = intData;
    }

    @Override
    public void setLongPage(long[] longData) {
        this.longData = longData;
    }

    @Override
    public void setFloatPage(float[] floatData) {
        this.floatData = floatData;
    }

    @Override
    public void setDoublePage(double[] doubleData) {
        this.doubleData = doubleData;
    }

    @Override
    public void setByteArrayPage(byte[][] byteArray) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void freeMemory() {
        this.byteData = null;
        this.shortData = null;
        this.intData = null;
        this.longData = null;
        this.floatData = null;
        this.doubleData = null;
        this.shortIntData = null;
        this.fixedLengthdata = null;
    }

    @Override
    public void convertValue(ColumnPageValueConverter codec) {
        if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.BYTE) {
            for (int i = 0; i < this.arrayElementCount; ++i) {
                codec.encode(i, this.byteData[i]);
            }
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.SHORT) {
            for (int i = 0; i < this.arrayElementCount; ++i) {
                codec.encode(i, this.shortData[i]);
            }
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.INT) {
            for (int i = 0; i < this.arrayElementCount; ++i) {
                codec.encode(i, this.intData[i]);
            }
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.LONG) {
            for (int i = 0; i < this.arrayElementCount; ++i) {
                codec.encode(i, this.longData[i]);
            }
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.FLOAT) {
            for (int i = 0; i < this.arrayElementCount; ++i) {
                codec.encode(i, this.floatData[i]);
            }
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.DOUBLE) {
            for (int i = 0; i < this.arrayElementCount; ++i) {
                codec.encode(i, this.doubleData[i]);
            }
        } else {
            throw new UnsupportedOperationException("not support value conversion on " + this.columnPageEncoderMeta.getStoreDataType() + " page");
        }
    }

    private void ensureArraySize(int requestSize, DataType dataType) {
        if (dataType == DataTypes.BYTE) {
            if (requestSize >= this.byteData.length) {
                byte[] newArray = new byte[this.arrayElementCount * 2];
                System.arraycopy(this.byteData, 0, newArray, 0, this.arrayElementCount);
                this.byteData = newArray;
            }
        } else if (dataType == DataTypes.SHORT) {
            if (requestSize >= this.shortData.length) {
                short[] newArray = new short[this.arrayElementCount * 2];
                System.arraycopy(this.shortData, 0, newArray, 0, this.arrayElementCount);
                this.shortData = newArray;
            }
        } else if (dataType == DataTypes.SHORT_INT) {
            if (requestSize >= this.shortIntData.length / 3) {
                byte[] newArray = new byte[this.arrayElementCount * 6];
                System.arraycopy(this.shortIntData, 0, newArray, 0, this.arrayElementCount * 3);
                this.shortIntData = newArray;
            }
        } else if (dataType == DataTypes.INT) {
            if (requestSize >= this.intData.length) {
                int[] newArray = new int[this.arrayElementCount * 2];
                System.arraycopy(this.intData, 0, newArray, 0, this.arrayElementCount);
                this.intData = newArray;
            }
        } else if (dataType == DataTypes.LONG) {
            if (requestSize >= this.longData.length) {
                long[] newArray = new long[this.arrayElementCount * 2];
                System.arraycopy(this.longData, 0, newArray, 0, this.arrayElementCount);
                this.longData = newArray;
            }
        } else if (dataType == DataTypes.FLOAT) {
            if (requestSize >= this.floatData.length) {
                float[] newArray = new float[this.arrayElementCount * 2];
                System.arraycopy(this.floatData, 0, newArray, 0, this.arrayElementCount);
                this.floatData = newArray;
            }
        } else if (dataType == DataTypes.DOUBLE) {
            if (requestSize >= this.doubleData.length) {
                double[] newArray = new double[this.arrayElementCount * 2];
                System.arraycopy(this.doubleData, 0, newArray, 0, this.arrayElementCount);
                this.doubleData = newArray;
            }
        } else if (dataType == DataTypes.BYTE_ARRAY) {
            if (this.fixedLengthdata == null) {
                this.fixedLengthdata = new byte[this.pageSize][];
            }
            if (requestSize >= this.fixedLengthdata.length) {
                byte[][] newArray = new byte[this.arrayElementCount * 2][];
                int index = 0;
                for (byte[] data : this.fixedLengthdata) {
                    newArray[index++] = data;
                }
                this.fixedLengthdata = newArray;
            }
        } else {
            throw new UnsupportedOperationException("not support value conversion on " + dataType + " page");
        }
    }

    @Override
    public int getActualRowCount() {
        return this.arrayElementCount;
    }

    @Override
    public long getPageLengthInBytes() {
        return this.totalLength;
    }
}

