/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.datastore.page.VarLengthColumnPageBase;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.util.DataTypeUtil;

public class SafeVarLengthColumnPage
extends VarLengthColumnPageBase {
    private List<byte[]> byteArrayData = new ArrayList<byte[]>();

    SafeVarLengthColumnPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        super(columnPageEncoderMeta, pageSize);
    }

    @Override
    public void freeMemory() {
        this.byteArrayData = null;
        super.freeMemory();
    }

    @Override
    public void putBytesAtRow(int rowId, byte[] bytes) {
        this.byteArrayData.add(bytes);
    }

    @Override
    public void putBytes(int rowId, byte[] bytes, int offset, int length) {
        this.byteArrayData.add(bytes);
    }

    @Override
    public void putDecimal(int rowId, BigDecimal decimal) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public BigDecimal getDecimal(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getBytes(int rowId) {
        return this.byteArrayData.get(rowId);
    }

    @Override
    public void setByteArrayPage(byte[][] byteArray) {
        for (byte[] data : byteArray) {
            this.byteArrayData.add(data);
        }
    }

    @Override
    public byte[] getLVFlattenedBytePage() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        for (byte[] byteArrayDatum : this.byteArrayData) {
            out.writeInt(byteArrayDatum.length);
            out.write(byteArrayDatum);
        }
        return stream.toByteArray();
    }

    @Override
    public byte[] getComplexChildrenLVFlattenedBytePage(DataType dataType) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        for (byte[] byteArrayDatum : this.byteArrayData) {
            if (DataTypeUtil.isByteArrayComplexChildColumn(dataType)) {
                out.writeInt(byteArrayDatum.length);
            } else {
                out.writeShort((short)byteArrayDatum.length);
            }
            out.write(byteArrayDatum);
        }
        return stream.toByteArray();
    }

    @Override
    public byte[] getComplexParentFlattenedBytePage() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        for (byte[] byteArrayDatum : this.byteArrayData) {
            out.write(byteArrayDatum);
        }
        return stream.toByteArray();
    }

    @Override
    public byte[][] getByteArrayPage() {
        return (byte[][])this.byteArrayData.toArray((T[])new byte[this.byteArrayData.size()][]);
    }

    @Override
    void copyBytes(int rowId, byte[] dest, int destOffset, int length) {
        System.arraycopy(this.byteArrayData.get(rowId), 0, dest, destOffset, length);
    }
}

