/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import java.math.BigDecimal;
import org.apache.carbondata.core.datastore.page.ColumnPageValueConverter;
import org.apache.carbondata.core.datastore.page.DecimalColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.memory.UnsafeMemoryManager;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.ByteUtil;

public class UnsafeDecimalColumnPage
extends DecimalColumnPage {
    UnsafeDecimalColumnPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        this(columnPageEncoderMeta, pageSize, (int)((double)(pageSize * 8) * 1.25));
    }

    UnsafeDecimalColumnPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize, int capacity) {
        super(columnPageEncoderMeta, pageSize);
        this.capacity = capacity;
        this.initMemory();
    }

    private void initMemory() {
        if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.BYTE || this.columnPageEncoderMeta.getStoreDataType() == DataTypes.SHORT || this.columnPageEncoderMeta.getStoreDataType() == DataTypes.INT || this.columnPageEncoderMeta.getStoreDataType() == DataTypes.LONG) {
            int size = this.pageSize << this.columnPageEncoderMeta.getStoreDataType().getSizeBits();
            this.memoryBlock = UnsafeMemoryManager.allocateMemoryWithRetry(this.taskId, size);
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.SHORT_INT) {
            int size = this.pageSize * 3;
            this.memoryBlock = UnsafeMemoryManager.allocateMemoryWithRetry(this.taskId, size);
        } else if (DataTypes.isDecimal(this.columnPageEncoderMeta.getStoreDataType())) {
            this.memoryBlock = UnsafeMemoryManager.allocateMemoryWithRetry(this.taskId, this.capacity);
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.BYTE_ARRAY) {
            this.memoryBlock = UnsafeMemoryManager.allocateMemoryWithRetry(this.taskId, this.capacity);
        } else {
            throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
        }
        this.baseAddress = this.memoryBlock.getBaseObject();
        this.baseOffset = this.memoryBlock.getBaseOffset();
    }

    @Override
    public void setBytePage(byte[] byteData) {
        CarbonUnsafe.getUnsafe().copyMemory(byteData, CarbonUnsafe.BYTE_ARRAY_OFFSET, this.baseAddress, this.baseOffset, byteData.length << byteBits);
    }

    @Override
    public void setShortPage(short[] shortData) {
        CarbonUnsafe.getUnsafe().copyMemory(shortData, CarbonUnsafe.SHORT_ARRAY_OFFSET, this.baseAddress, this.baseOffset, shortData.length << shortBits);
    }

    @Override
    public void setShortIntPage(byte[] shortIntData) {
        CarbonUnsafe.getUnsafe().copyMemory(shortIntData, CarbonUnsafe.BYTE_ARRAY_OFFSET, this.baseAddress, this.baseOffset, shortIntData.length);
    }

    @Override
    public void setIntPage(int[] intData) {
        CarbonUnsafe.getUnsafe().copyMemory(intData, CarbonUnsafe.INT_ARRAY_OFFSET, this.baseAddress, this.baseOffset, intData.length << intBits);
    }

    @Override
    public void setLongPage(long[] longData) {
        CarbonUnsafe.getUnsafe().copyMemory(longData, CarbonUnsafe.LONG_ARRAY_OFFSET, this.baseAddress, this.baseOffset, longData.length << longBits);
    }

    @Override
    public void setByteArrayPage(byte[][] byteArray) {
        if (this.totalLength != 0) {
            throw new IllegalStateException("page is not empty");
        }
        for (int i = 0; i < byteArray.length; ++i) {
            this.putBytes(i, byteArray[i]);
        }
    }

    @Override
    public void freeMemory() {
        if (this.memoryBlock != null) {
            UnsafeMemoryManager.INSTANCE.freeMemory(this.taskId, this.memoryBlock);
            this.memoryBlock = null;
            this.baseAddress = null;
            this.baseOffset = 0L;
            super.freeMemory();
        }
    }

    @Override
    public void putByte(int rowId, byte value) {
        long offset = (long)rowId << byteBits;
        CarbonUnsafe.getUnsafe().putByte(this.baseAddress, this.baseOffset + offset, value);
    }

    @Override
    public void putShort(int rowId, short value) {
        long offset = (long)rowId << shortBits;
        CarbonUnsafe.getUnsafe().putShort(this.baseAddress, this.baseOffset + offset, value);
    }

    @Override
    public void putShortInt(int rowId, int value) {
        byte[] data = ByteUtil.to3Bytes(value);
        long offset = (long)rowId * 3L;
        CarbonUnsafe.getUnsafe().putByte(this.baseAddress, this.baseOffset + offset, data[0]);
        CarbonUnsafe.getUnsafe().putByte(this.baseAddress, this.baseOffset + offset + 1L, data[1]);
        CarbonUnsafe.getUnsafe().putByte(this.baseAddress, this.baseOffset + offset + 2L, data[2]);
    }

    @Override
    public void putInt(int rowId, int value) {
        long offset = (long)rowId << intBits;
        CarbonUnsafe.getUnsafe().putInt(this.baseAddress, this.baseOffset + offset, value);
    }

    @Override
    public void putLong(int rowId, long value) {
        long offset = (long)rowId << longBits;
        CarbonUnsafe.getUnsafe().putLong(this.baseAddress, this.baseOffset + offset, value);
    }

    @Override
    public void putBytesAtRow(int rowId, byte[] bytes) {
        this.putBytes(rowId, bytes, 0, bytes.length);
    }

    @Override
    public void putBytes(int rowId, byte[] bytes, int offset, int length) {
        this.ensureMemory(length);
        CarbonUnsafe.getUnsafe().copyMemory(bytes, CarbonUnsafe.BYTE_ARRAY_OFFSET + offset, this.baseAddress, this.baseOffset + (long)this.rowOffset.getInt(rowId), length);
    }

    @Override
    public void putDecimal(int rowId, BigDecimal decimal) {
        switch (this.decimalConverter.getDecimalConverterType()) {
            case DECIMAL_INT: {
                this.putInt(rowId, (Integer)this.decimalConverter.convert(decimal));
                break;
            }
            case DECIMAL_LONG: {
                this.putLong(rowId, (Long)this.decimalConverter.convert(decimal));
                break;
            }
            default: {
                this.putBytes(rowId, (byte[])this.decimalConverter.convert(decimal));
            }
        }
    }

    @Override
    public byte getByte(int rowId) {
        long offset = (long)rowId << byteBits;
        return CarbonUnsafe.getUnsafe().getByte(this.baseAddress, this.baseOffset + offset);
    }

    @Override
    public byte[] getBytes(int rowId) {
        int length = this.rowOffset.getInt(rowId + 1) - this.rowOffset.getInt(rowId);
        byte[] bytes = new byte[length];
        CarbonUnsafe.getUnsafe().copyMemory(this.baseAddress, this.baseOffset + (long)this.rowOffset.getInt(rowId), bytes, CarbonUnsafe.BYTE_ARRAY_OFFSET, length);
        return bytes;
    }

    @Override
    public short getShort(int rowId) {
        long offset = (long)rowId << shortBits;
        return CarbonUnsafe.getUnsafe().getShort(this.baseAddress, this.baseOffset + offset);
    }

    @Override
    public int getShortInt(int rowId) {
        long offset = (long)rowId * 3L;
        byte[] data = new byte[]{CarbonUnsafe.getUnsafe().getByte(this.baseAddress, this.baseOffset + offset), CarbonUnsafe.getUnsafe().getByte(this.baseAddress, this.baseOffset + offset + 1L), CarbonUnsafe.getUnsafe().getByte(this.baseAddress, this.baseOffset + offset + 2L)};
        return ByteUtil.valueOf3Bytes(data, 0);
    }

    @Override
    public int getInt(int rowId) {
        long offset = (long)rowId << intBits;
        return CarbonUnsafe.getUnsafe().getInt(this.baseAddress, this.baseOffset + offset);
    }

    @Override
    public long getLong(int rowId) {
        long offset = (long)rowId << longBits;
        return CarbonUnsafe.getUnsafe().getLong(this.baseAddress, this.baseOffset + offset);
    }

    @Override
    void copyBytes(int rowId, byte[] dest, int destOffset, int length) {
        CarbonUnsafe.getUnsafe().copyMemory(this.baseAddress, this.baseOffset + (long)this.rowOffset.getInt(rowId), dest, CarbonUnsafe.BYTE_ARRAY_OFFSET + destOffset, length);
    }

    @Override
    public void convertValue(ColumnPageValueConverter codec) {
        this.convertValueForDecimalType(codec);
    }

    private void convertValueForDecimalType(ColumnPageValueConverter codec) {
        switch (this.decimalConverter.getDecimalConverterType()) {
            case DECIMAL_INT: {
                for (int i = 0; i < this.pageSize; ++i) {
                    long offset = (long)i << intBits;
                    codec.encode(i, CarbonUnsafe.getUnsafe().getInt(this.baseAddress, this.baseOffset + offset));
                }
                break;
            }
            case DECIMAL_LONG: {
                for (int i = 0; i < this.pageSize; ++i) {
                    long offset = (long)i << longBits;
                    codec.encode(i, CarbonUnsafe.getUnsafe().getLong(this.baseAddress, this.baseOffset + offset));
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("not support value conversion on " + this.columnPageEncoderMeta.getStoreDataType() + " page");
            }
        }
    }
}

