/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.ColumnPageValueConverter;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.memory.MemoryBlock;
import org.apache.carbondata.core.memory.UnsafeMemoryManager;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.ThreadLocalTaskInfo;
import sun.nio.ch.DirectBuffer;

public class UnsafeFixLengthColumnPage
extends ColumnPage {
    private MemoryBlock memoryBlock;
    private Object baseAddress;
    private long baseOffset;
    private int eachRowSize;
    private int totalLength;
    private int capacity;
    private final String taskId = ThreadLocalTaskInfo.getCarbonTaskInfo().getTaskId();
    private static final int byteBits = DataTypes.BYTE.getSizeBits();
    private static final int shortBits = DataTypes.SHORT.getSizeBits();
    private static final int intBits = DataTypes.INT.getSizeBits();
    private static final int longBits = DataTypes.LONG.getSizeBits();
    private static final int floatBits = DataTypes.FLOAT.getSizeBits();
    private static final int doubleBits = DataTypes.DOUBLE.getSizeBits();

    UnsafeFixLengthColumnPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        super(columnPageEncoderMeta, pageSize);
        if (columnPageEncoderMeta.getStoreDataType() == DataTypes.BOOLEAN || columnPageEncoderMeta.getStoreDataType() == DataTypes.BYTE || columnPageEncoderMeta.getStoreDataType() == DataTypes.SHORT || columnPageEncoderMeta.getStoreDataType() == DataTypes.INT || columnPageEncoderMeta.getStoreDataType() == DataTypes.LONG || columnPageEncoderMeta.getStoreDataType() == DataTypes.FLOAT || columnPageEncoderMeta.getStoreDataType() == DataTypes.DOUBLE) {
            int size = pageSize << columnPageEncoderMeta.getStoreDataType().getSizeBits();
            this.memoryBlock = UnsafeMemoryManager.allocateMemoryWithRetry(this.taskId, size);
            this.baseAddress = this.memoryBlock.getBaseObject();
            this.baseOffset = this.memoryBlock.getBaseOffset();
            this.capacity = size;
        } else if (columnPageEncoderMeta.getStoreDataType() == DataTypes.SHORT_INT) {
            int size = pageSize * 3;
            this.memoryBlock = UnsafeMemoryManager.allocateMemoryWithRetry(this.taskId, size);
            this.baseAddress = this.memoryBlock.getBaseObject();
            this.baseOffset = this.memoryBlock.getBaseOffset();
            this.capacity = size;
        } else if (DataTypes.isDecimal(columnPageEncoderMeta.getStoreDataType()) || columnPageEncoderMeta.getStoreDataType() == DataTypes.STRING) {
            throw new UnsupportedOperationException("invalid data type: " + columnPageEncoderMeta.getStoreDataType());
        }
        this.totalLength = 0;
    }

    UnsafeFixLengthColumnPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize, int eachRowSize) {
        this(columnPageEncoderMeta, pageSize);
        this.eachRowSize = eachRowSize;
        this.totalLength = 0;
        if (columnPageEncoderMeta.getStoreDataType() == DataTypes.BYTE_ARRAY) {
            this.capacity = pageSize * eachRowSize;
            this.memoryBlock = UnsafeMemoryManager.allocateMemoryWithRetry(this.taskId, this.capacity);
            this.baseAddress = this.memoryBlock.getBaseObject();
            this.baseOffset = this.memoryBlock.getBaseOffset();
        }
    }

    private void checkDataFileSize() {
        if (this.totalLength > 0x7FFFFFEF) {
            throw new RuntimeException("Carbondata only support maximum 2GB size for one column page");
        }
    }

    private void updatePageSize(int rowId) {
        if (this.pageSize < rowId) {
            this.pageSize = rowId + 1;
        }
    }

    @Override
    public void putByte(int rowId, byte value) {
        this.ensureMemory(1);
        long offset = (long)rowId << byteBits;
        CarbonUnsafe.getUnsafe().putByte(this.baseAddress, this.baseOffset + offset, value);
        ++this.totalLength;
        this.updatePageSize(rowId);
    }

    @Override
    public void putShort(int rowId, short value) {
        this.ensureMemory(shortBits);
        long offset = (long)rowId << shortBits;
        CarbonUnsafe.getUnsafe().putShort(this.baseAddress, this.baseOffset + offset, value);
        this.totalLength += 2;
        this.updatePageSize(rowId);
    }

    @Override
    public void putShortInt(int rowId, int value) {
        this.ensureMemory(3);
        byte[] data = ByteUtil.to3Bytes(value);
        long offset = (long)rowId * 3L;
        CarbonUnsafe.getUnsafe().putByte(this.baseAddress, this.baseOffset + offset, data[0]);
        CarbonUnsafe.getUnsafe().putByte(this.baseAddress, this.baseOffset + offset + 1L, data[1]);
        CarbonUnsafe.getUnsafe().putByte(this.baseAddress, this.baseOffset + offset + 2L, data[2]);
        this.totalLength += 3;
        this.updatePageSize(rowId);
    }

    @Override
    public void putInt(int rowId, int value) {
        this.ensureMemory(4);
        long offset = (long)rowId << intBits;
        CarbonUnsafe.getUnsafe().putInt(this.baseAddress, this.baseOffset + offset, value);
        this.totalLength += 4;
        this.updatePageSize(rowId);
    }

    @Override
    public void putLong(int rowId, long value) {
        this.ensureMemory(8);
        long offset = (long)rowId << longBits;
        CarbonUnsafe.getUnsafe().putLong(this.baseAddress, this.baseOffset + offset, value);
        this.totalLength += 8;
        this.updatePageSize(rowId);
    }

    @Override
    public void putDouble(int rowId, double value) {
        this.ensureMemory(8);
        long offset = (long)rowId << doubleBits;
        CarbonUnsafe.getUnsafe().putDouble(this.baseAddress, this.baseOffset + offset, value);
        this.totalLength += 8;
        this.updatePageSize(rowId);
    }

    @Override
    public void putFloat(int rowId, float value) {
        this.ensureMemory(4);
        long offset = (long)rowId << floatBits;
        CarbonUnsafe.getUnsafe().putFloat(this.baseAddress, this.baseOffset + offset, value);
        this.totalLength += 4;
        this.updatePageSize(rowId);
    }

    @Override
    public void putBytes(int rowId, byte[] bytes) {
        this.ensureMemory(this.eachRowSize);
        long offset = (long)rowId * (long)this.eachRowSize;
        CarbonUnsafe.getUnsafe().copyMemory(bytes, CarbonUnsafe.BYTE_ARRAY_OFFSET, this.memoryBlock.getBaseObject(), this.baseOffset + offset, bytes.length);
        this.updatePageSize(rowId);
        this.totalLength += this.eachRowSize;
    }

    @Override
    public void putBytes(int rowId, byte[] bytes, int offset, int length) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putDecimal(int rowId, BigDecimal decimal) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte getByte(int rowId) {
        long offset = (long)rowId << byteBits;
        return CarbonUnsafe.getUnsafe().getByte(this.baseAddress, this.baseOffset + offset);
    }

    @Override
    public short getShort(int rowId) {
        long offset = (long)rowId << shortBits;
        return CarbonUnsafe.getUnsafe().getShort(this.baseAddress, this.baseOffset + offset);
    }

    @Override
    public int getShortInt(int rowId) {
        long offset = (long)rowId * 3L;
        byte[] data = new byte[]{CarbonUnsafe.getUnsafe().getByte(this.baseAddress, this.baseOffset + offset), CarbonUnsafe.getUnsafe().getByte(this.baseAddress, this.baseOffset + offset + 1L), CarbonUnsafe.getUnsafe().getByte(this.baseAddress, this.baseOffset + offset + 2L)};
        return ByteUtil.valueOf3Bytes(data, 0);
    }

    @Override
    public int getInt(int rowId) {
        long offset = (long)rowId << intBits;
        return CarbonUnsafe.getUnsafe().getInt(this.baseAddress, this.baseOffset + offset);
    }

    @Override
    public long getLong(int rowId) {
        long offset = (long)rowId << longBits;
        return CarbonUnsafe.getUnsafe().getLong(this.baseAddress, this.baseOffset + offset);
    }

    @Override
    public float getFloat(int rowId) {
        long offset = (long)rowId << floatBits;
        return CarbonUnsafe.getUnsafe().getFloat(this.baseAddress, this.baseOffset + offset);
    }

    @Override
    public double getDouble(int rowId) {
        long offset = (long)rowId << doubleBits;
        return CarbonUnsafe.getUnsafe().getDouble(this.baseAddress, this.baseOffset + offset);
    }

    @Override
    public BigDecimal getDecimal(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getBytes(int rowId) {
        byte[] data = new byte[this.eachRowSize];
        CarbonUnsafe.getUnsafe().copyMemory(this.memoryBlock.getBaseObject(), this.baseOffset + (long)rowId * (long)this.eachRowSize, data, CarbonUnsafe.BYTE_ARRAY_OFFSET, this.eachRowSize);
        return data;
    }

    @Override
    public byte[] getDecimalPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getBytePage() {
        byte[] data = new byte[this.getEndLoop()];
        for (long i = 0L; i < (long)data.length; ++i) {
            long offset = i << byteBits;
            data[(int)i] = CarbonUnsafe.getUnsafe().getByte(this.baseAddress, this.baseOffset + offset);
        }
        return data;
    }

    @Override
    public short[] getShortPage() {
        short[] data = new short[this.getEndLoop()];
        for (long i = 0L; i < (long)data.length; ++i) {
            long offset = i << shortBits;
            data[(int)i] = CarbonUnsafe.getUnsafe().getShort(this.baseAddress, this.baseOffset + offset);
        }
        return data;
    }

    @Override
    public byte[] getShortIntPage() {
        byte[] data = new byte[this.getEndLoop() * 3];
        CarbonUnsafe.getUnsafe().copyMemory(this.baseAddress, this.baseOffset, data, CarbonUnsafe.BYTE_ARRAY_OFFSET, data.length);
        return data;
    }

    @Override
    public int[] getIntPage() {
        int[] data = new int[this.getEndLoop()];
        for (long i = 0L; i < (long)data.length; ++i) {
            long offset = i << intBits;
            data[(int)i] = CarbonUnsafe.getUnsafe().getInt(this.baseAddress, this.baseOffset + offset);
        }
        return data;
    }

    @Override
    public long[] getLongPage() {
        long[] data = new long[this.getEndLoop()];
        for (long i = 0L; i < (long)data.length; ++i) {
            long offset = i << longBits;
            data[(int)i] = CarbonUnsafe.getUnsafe().getLong(this.baseAddress, this.baseOffset + offset);
        }
        return data;
    }

    @Override
    public float[] getFloatPage() {
        float[] data = new float[this.getEndLoop()];
        for (long i = 0L; i < (long)data.length; ++i) {
            long offset = i << floatBits;
            data[(int)i] = CarbonUnsafe.getUnsafe().getFloat(this.baseAddress, this.baseOffset + offset);
        }
        return data;
    }

    @Override
    public double[] getDoublePage() {
        double[] data = new double[this.getEndLoop()];
        for (long i = 0L; i < (long)data.length; ++i) {
            long offset = i << doubleBits;
            data[(int)i] = CarbonUnsafe.getUnsafe().getDouble(this.baseAddress, this.baseOffset + offset);
        }
        return data;
    }

    @Override
    public byte[][] getByteArrayPage() {
        byte[][] data = new byte[this.getEndLoop()][this.eachRowSize];
        long offset = this.baseOffset;
        for (int i = 0; i < data.length; ++i) {
            CarbonUnsafe.getUnsafe().copyMemory(this.memoryBlock.getBaseObject(), offset, data[i], CarbonUnsafe.BYTE_ARRAY_OFFSET, this.eachRowSize);
            offset += (long)this.eachRowSize;
        }
        return data;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        int numRow = this.getEndLoop();
        ByteBuffer out = ByteBuffer.allocateDirect(numRow * this.eachRowSize);
        CarbonUnsafe.getUnsafe().copyMemory(this.memoryBlock.getBaseOffset(), ((DirectBuffer)((Object)out)).address(), numRow * this.eachRowSize);
        return out;
    }

    @Override
    public byte[] getLVFlattenedBytePage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getComplexChildrenLVFlattenedBytePage(DataType dataType) {
        byte[] data = new byte[this.totalLength];
        CarbonUnsafe.getUnsafe().copyMemory(this.baseAddress, this.baseOffset, data, CarbonUnsafe.BYTE_ARRAY_OFFSET, this.totalLength);
        return data;
    }

    @Override
    public byte[] getComplexParentFlattenedBytePage() {
        throw new UnsupportedOperationException("internal error");
    }

    @Override
    public void setBytePage(byte[] byteData) {
        CarbonUnsafe.getUnsafe().copyMemory(byteData, CarbonUnsafe.BYTE_ARRAY_OFFSET, this.baseAddress, this.baseOffset, byteData.length << byteBits);
        this.capacity = byteData.length;
    }

    @Override
    public void setShortPage(short[] shortData) {
        CarbonUnsafe.getUnsafe().copyMemory(shortData, CarbonUnsafe.SHORT_ARRAY_OFFSET, this.baseAddress, this.baseOffset, shortData.length << shortBits);
        this.capacity = shortData.length;
    }

    @Override
    public void setShortIntPage(byte[] shortIntData) {
        CarbonUnsafe.getUnsafe().copyMemory(shortIntData, CarbonUnsafe.BYTE_ARRAY_OFFSET, this.baseAddress, this.baseOffset, shortIntData.length);
        this.capacity = shortIntData.length;
    }

    @Override
    public void setIntPage(int[] intData) {
        CarbonUnsafe.getUnsafe().copyMemory(intData, CarbonUnsafe.INT_ARRAY_OFFSET, this.baseAddress, this.baseOffset, intData.length << intBits);
        this.capacity = intData.length;
    }

    @Override
    public void setLongPage(long[] longData) {
        CarbonUnsafe.getUnsafe().copyMemory(longData, CarbonUnsafe.LONG_ARRAY_OFFSET, this.baseAddress, this.baseOffset, longData.length << longBits);
        this.capacity = longData.length;
    }

    @Override
    public void setFloatPage(float[] floatData) {
        CarbonUnsafe.getUnsafe().copyMemory(floatData, CarbonUnsafe.FLOAT_ARRAY_OFFSET, this.baseAddress, this.baseOffset, floatData.length << floatBits);
        this.capacity = floatData.length;
    }

    @Override
    public void setDoublePage(double[] doubleData) {
        CarbonUnsafe.getUnsafe().copyMemory(doubleData, CarbonUnsafe.DOUBLE_ARRAY_OFFSET, this.baseAddress, this.baseOffset, doubleData.length << doubleBits);
        this.capacity = doubleData.length;
    }

    @Override
    public void setByteArrayPage(byte[][] byteArray) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void freeMemory() {
        if (this.memoryBlock != null) {
            UnsafeMemoryManager.INSTANCE.freeMemory(this.taskId, this.memoryBlock);
            this.memoryBlock = null;
            this.baseAddress = null;
            this.baseOffset = 0L;
        }
    }

    @Override
    public void convertValue(ColumnPageValueConverter codec) {
        int endLoop = this.getEndLoop();
        if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.BYTE) {
            for (long i = 0L; i < (long)endLoop; ++i) {
                long offset = i << byteBits;
                codec.encode((int)i, CarbonUnsafe.getUnsafe().getByte(this.baseAddress, this.baseOffset + offset));
            }
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.SHORT) {
            for (long i = 0L; i < (long)endLoop; ++i) {
                long offset = i << shortBits;
                codec.encode((int)i, CarbonUnsafe.getUnsafe().getShort(this.baseAddress, this.baseOffset + offset));
            }
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.INT) {
            for (long i = 0L; i < (long)endLoop; ++i) {
                long offset = i << intBits;
                codec.encode((int)i, CarbonUnsafe.getUnsafe().getInt(this.baseAddress, this.baseOffset + offset));
            }
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.LONG) {
            for (long i = 0L; i < (long)endLoop; ++i) {
                long offset = i << longBits;
                codec.encode((int)i, CarbonUnsafe.getUnsafe().getLong(this.baseAddress, this.baseOffset + offset));
            }
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.FLOAT) {
            for (long i = 0L; i < (long)endLoop; ++i) {
                long offset = i << floatBits;
                codec.encode((int)i, CarbonUnsafe.getUnsafe().getFloat(this.baseAddress, this.baseOffset + offset));
            }
        } else if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.DOUBLE) {
            for (long i = 0L; i < (long)endLoop; ++i) {
                long offset = i << doubleBits;
                codec.encode((int)i, CarbonUnsafe.getUnsafe().getDouble(this.baseAddress, this.baseOffset + offset));
            }
        } else {
            throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
        }
    }

    private int getEndLoop() {
        if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.BYTE) {
            return this.totalLength / 1;
        }
        if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.SHORT) {
            return this.totalLength / 2;
        }
        if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.SHORT_INT) {
            return this.totalLength / 3;
        }
        if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.INT) {
            return this.totalLength / 4;
        }
        if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.LONG) {
            return this.totalLength / 8;
        }
        if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.FLOAT) {
            return this.totalLength / DataTypes.FLOAT.getSizeInBytes();
        }
        if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.DOUBLE) {
            return this.totalLength / DataTypes.DOUBLE.getSizeInBytes();
        }
        if (this.columnPageEncoderMeta.getStoreDataType() == DataTypes.BYTE_ARRAY) {
            return this.totalLength / this.eachRowSize;
        }
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public long getPageLengthInBytes() {
        return this.totalLength;
    }

    protected void ensureMemory(int requestSize) {
        this.checkDataFileSize();
        if (this.totalLength + requestSize > this.capacity) {
            int newSize = Math.max(2 * this.capacity, this.totalLength + requestSize);
            MemoryBlock newBlock = UnsafeMemoryManager.allocateMemoryWithRetry(this.taskId, newSize);
            CarbonUnsafe.getUnsafe().copyMemory(this.baseAddress, this.baseOffset, newBlock.getBaseObject(), newBlock.getBaseOffset(), this.totalLength);
            UnsafeMemoryManager.INSTANCE.freeMemory(this.taskId, this.memoryBlock);
            this.memoryBlock = newBlock;
            this.baseAddress = newBlock.getBaseObject();
            this.baseOffset = newBlock.getBaseOffset();
            this.capacity = newSize;
        }
    }

    @Override
    public int getActualRowCount() {
        return this.getEndLoop();
    }
}

