/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import java.math.BigDecimal;
import org.apache.carbondata.core.datastore.page.UnsafeVarLengthColumnPageBase;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.memory.UnsafeMemoryManager;
import org.apache.carbondata.core.metadata.datatype.DataTypes;

public class UnsafeVarLengthColumnPage
extends UnsafeVarLengthColumnPageBase {
    UnsafeVarLengthColumnPage(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        super(columnPageEncoderMeta, pageSize);
        this.capacity = columnPageEncoderMeta.getStoreDataType() == DataTypes.BINARY ? (int)((double)(pageSize * 512) * 1.25) : (int)((double)(pageSize * 8) * 1.25);
        this.memoryBlock = UnsafeMemoryManager.allocateMemoryWithRetry(this.taskId, this.capacity);
        this.baseAddress = this.memoryBlock.getBaseObject();
        this.baseOffset = this.memoryBlock.getBaseOffset();
    }

    @Override
    public void freeMemory() {
        if (this.memoryBlock != null) {
            UnsafeMemoryManager.INSTANCE.freeMemory(this.taskId, this.memoryBlock);
            this.memoryBlock = null;
            this.baseAddress = null;
            this.baseOffset = 0L;
            super.freeMemory();
        }
    }

    @Override
    public void putBytesAtRow(int rowId, byte[] bytes) {
        this.putBytes(rowId, bytes, 0, bytes.length);
    }

    @Override
    public void putBytes(int rowId, byte[] bytes, int offset, int length) {
        this.ensureMemory(length);
        CarbonUnsafe.getUnsafe().copyMemory(bytes, CarbonUnsafe.BYTE_ARRAY_OFFSET + offset, this.baseAddress, this.baseOffset + (long)this.rowOffset.getInt(rowId), length);
    }

    @Override
    public void setByteArrayPage(byte[][] byteArray) {
        if (this.totalLength != 0) {
            throw new IllegalStateException("page is not empty");
        }
        for (int i = 0; i < byteArray.length; ++i) {
            this.putBytes(i, byteArray[i]);
        }
    }

    @Override
    public void putDecimal(int rowId, BigDecimal decimal) {
    }

    @Override
    public BigDecimal getDecimal(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getBytes(int rowId) {
        int length = this.rowOffset.getInt(rowId + 1) - this.rowOffset.getInt(rowId);
        byte[] bytes = new byte[length];
        CarbonUnsafe.getUnsafe().copyMemory(this.baseAddress, this.baseOffset + (long)this.rowOffset.getInt(rowId), bytes, CarbonUnsafe.BYTE_ARRAY_OFFSET, length);
        return bytes;
    }

    @Override
    public byte[][] getByteArrayPage() {
        byte[][] bytes = new byte[this.rowOffset.getActualRowCount() - 1][];
        for (int rowId = 0; rowId < this.rowOffset.getActualRowCount() - 1; ++rowId) {
            int length = this.rowOffset.getInt(rowId + 1) - this.rowOffset.getInt(rowId);
            byte[] rowData = new byte[length];
            CarbonUnsafe.getUnsafe().copyMemory(this.baseAddress, this.baseOffset + (long)this.rowOffset.getInt(rowId), rowData, CarbonUnsafe.BYTE_ARRAY_OFFSET, length);
            bytes[rowId] = rowData;
        }
        return bytes;
    }

    @Override
    void copyBytes(int rowId, byte[] dest, int destOffset, int length) {
        CarbonUnsafe.getUnsafe().copyMemory(this.baseAddress, this.baseOffset + (long)this.rowOffset.getInt(rowId), dest, CarbonUnsafe.BYTE_ARRAY_OFFSET + destOffset, length);
    }
}

