/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import org.apache.carbondata.core.datastore.page.VarLengthColumnPageBase;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.memory.MemoryBlock;
import org.apache.carbondata.core.memory.UnsafeMemoryManager;

public abstract class UnsafeVarLengthColumnPageBase
extends VarLengthColumnPageBase {
    protected MemoryBlock memoryBlock;
    protected Object baseAddress;
    protected long baseOffset;
    protected int capacity;

    UnsafeVarLengthColumnPageBase(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        super(columnPageEncoderMeta, pageSize);
    }

    protected void ensureMemory(int requestSize) {
        if (this.totalLength + requestSize > this.capacity) {
            int newSize = Math.max(2 * this.capacity, this.totalLength + requestSize);
            MemoryBlock newBlock = UnsafeMemoryManager.allocateMemoryWithRetry(this.taskId, newSize);
            CarbonUnsafe.getUnsafe().copyMemory(this.baseAddress, this.baseOffset, newBlock.getBaseObject(), newBlock.getBaseOffset(), this.capacity);
            UnsafeMemoryManager.INSTANCE.freeMemory(this.taskId, this.memoryBlock);
            this.memoryBlock = newBlock;
            this.baseAddress = newBlock.getBaseObject();
            this.baseOffset = newBlock.getBaseOffset();
            this.capacity = newSize;
        }
    }
}

