/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page;

import java.io.IOException;
import org.apache.carbondata.core.datastore.ColumnType;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.ColumnPageValueConverter;
import org.apache.carbondata.core.datastore.page.DecimalColumnPage;
import org.apache.carbondata.core.datastore.page.SafeDecimalColumnPage;
import org.apache.carbondata.core.datastore.page.UnsafeDecimalColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalConverterFactory;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.ThreadLocalTaskInfo;

public abstract class VarLengthColumnPageBase
extends ColumnPage {
    static final int byteBits = DataTypes.BYTE.getSizeBits();
    static final int shortBits = DataTypes.SHORT.getSizeBits();
    static final int intBits = DataTypes.INT.getSizeBits();
    static final int longBits = DataTypes.LONG.getSizeBits();
    static final int DEFAULT_ROW_SIZE = 8;
    static final int DEFAULT_BINARY_SIZE = 512;
    static final double FACTOR = 1.25;
    final String taskId = ThreadLocalTaskInfo.getCarbonTaskInfo().getTaskId();
    protected ColumnPage rowOffset;
    protected int totalLength;

    VarLengthColumnPageBase(ColumnPageEncoderMeta columnPageEncoderMeta, int pageSize) {
        super(columnPageEncoderMeta, pageSize);
        TableSpec.ColumnSpec spec = TableSpec.ColumnSpec.newInstance(columnPageEncoderMeta.getColumnSpec().getFieldName(), DataTypes.INT, ColumnType.MEASURE);
        this.rowOffset = ColumnPage.newPage(new ColumnPageEncoderMeta(spec, DataTypes.INT, columnPageEncoderMeta.getCompressorName()), pageSize + 1);
        this.totalLength = 0;
    }

    @Override
    public void setBytePage(byte[] byteData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void setShortPage(short[] shortData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void setShortIntPage(byte[] shortIntData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void setIntPage(int[] intData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void setLongPage(long[] longData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void setFloatPage(float[] floatData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void setDoublePage(double[] doubleData) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    public static ColumnPage newDecimalColumnPage(ColumnPageEncoderMeta meta, byte[] lvEncodedBytes, int actualDataLength) {
        TableSpec.ColumnSpec columnSpec = meta.getColumnSpec();
        DecimalConverterFactory.DecimalConverter decimalConverter = DecimalConverterFactory.INSTANCE.getDecimalConverter(columnSpec.getPrecision(), columnSpec.getScale());
        int size = decimalConverter.getSize();
        if (size < 0) {
            return VarLengthColumnPageBase.getLVBytesColumnPage(columnSpec, lvEncodedBytes, DataTypes.createDecimalType(columnSpec.getPrecision(), columnSpec.getScale()), 4, meta.getCompressorName());
        }
        return VarLengthColumnPageBase.getDecimalColumnPage(meta, lvEncodedBytes, size, actualDataLength);
    }

    static ColumnPage newLVBytesColumnPage(TableSpec.ColumnSpec columnSpec, byte[] lvEncodedBytes, int lvLength, String compressorName) {
        return VarLengthColumnPageBase.getLVBytesColumnPage(columnSpec, lvEncodedBytes, DataTypes.BYTE_ARRAY, lvLength, compressorName);
    }

    static ColumnPage newComplexLVBytesColumnPage(TableSpec.ColumnSpec columnSpec, byte[] lvEncodedBytes, int lvLength, String compressorName) {
        return VarLengthColumnPageBase.getComplexLVBytesColumnPage(columnSpec, lvEncodedBytes, DataTypes.BYTE_ARRAY, lvLength, compressorName);
    }

    private static ColumnPage getDecimalColumnPage(ColumnPageEncoderMeta meta, byte[] lvEncodedBytes, int size, int actualDataLength) {
        int offset;
        TableSpec.ColumnSpec columnSpec = meta.getColumnSpec();
        String compressorName = meta.getCompressorName();
        TableSpec.ColumnSpec spec = TableSpec.ColumnSpec.newInstance(columnSpec.getFieldName(), DataTypes.INT, ColumnType.MEASURE);
        ColumnPage rowOffset = ColumnPage.newPage(new ColumnPageEncoderMeta(spec, DataTypes.INT, compressorName), 32000);
        int rowId = 0;
        int counter = 0;
        for (offset = 0; offset < actualDataLength; offset += size) {
            rowOffset.putInt(counter, offset);
            ++rowId;
            ++counter;
        }
        rowOffset.putInt(counter, offset);
        DecimalColumnPage page = VarLengthColumnPageBase.isUnsafeEnabled(meta) ? new UnsafeDecimalColumnPage(new ColumnPageEncoderMeta(columnSpec, columnSpec.getSchemaDataType(), compressorName), rowId) : new SafeDecimalColumnPage(new ColumnPageEncoderMeta(columnSpec, columnSpec.getSchemaDataType(), compressorName), rowId);
        page.totalLength = offset;
        page.rowOffset.freeMemory();
        page.rowOffset = rowOffset;
        for (int i = 0; i < rowId; ++i) {
            page.putBytes(i, lvEncodedBytes, i * size, size);
        }
        return page;
    }

    private static ColumnPage getLVBytesColumnPage(TableSpec.ColumnSpec columnSpec, byte[] lvEncodedBytes, DataType dataType, int lvLength, String compressorName) {
        int rowId = 0;
        TableSpec.ColumnSpec spec = TableSpec.ColumnSpec.newInstance(columnSpec.getFieldName(), DataTypes.INT, ColumnType.MEASURE);
        ColumnPage rowOffset = ColumnPage.newPage(new ColumnPageEncoderMeta(spec, DataTypes.INT, compressorName), 32000);
        int lvEncodedOffset = 0;
        int counter = 0;
        int offset = 0;
        while (lvEncodedOffset < lvEncodedBytes.length) {
            int length = ByteUtil.toInt(lvEncodedBytes, lvEncodedOffset);
            rowOffset.putInt(counter, offset);
            lvEncodedOffset += lvLength + length;
            ++rowId;
            ++counter;
            offset += length;
        }
        rowOffset.putInt(counter, offset);
        return VarLengthColumnPageBase.getVarLengthColumnPage(columnSpec, lvEncodedBytes, dataType, lvLength, rowId, rowOffset, offset, compressorName);
    }

    private static ColumnPage getComplexLVBytesColumnPage(TableSpec.ColumnSpec columnSpec, byte[] lvEncodedBytes, DataType dataType, int lvLength, String compressorName) {
        int rowId = 0;
        TableSpec.ColumnSpec spec = TableSpec.ColumnSpec.newInstance(columnSpec.getFieldName(), DataTypes.INT, ColumnType.MEASURE);
        ColumnPage rowOffset = ColumnPage.newPage(new ColumnPageEncoderMeta(spec, DataTypes.INT, compressorName), 32000);
        int lvEncodedOffset = 0;
        int counter = 0;
        int offset = 0;
        while (lvEncodedOffset < lvEncodedBytes.length) {
            int length;
            if (lvLength == 4) {
                length = ByteUtil.toInt(lvEncodedBytes, lvEncodedOffset);
                rowOffset.putInt(counter, offset);
                lvEncodedOffset += lvLength + length;
            } else {
                length = ByteUtil.toShort(lvEncodedBytes, lvEncodedOffset);
                rowOffset.putInt(counter, offset);
                lvEncodedOffset += lvLength + length;
            }
            ++rowId;
            ++counter;
            offset += length;
        }
        rowOffset.putInt(counter, offset);
        return VarLengthColumnPageBase.getVarLengthColumnPage(columnSpec, lvEncodedBytes, dataType, lvLength, rowId, rowOffset, offset, compressorName);
    }

    private static VarLengthColumnPageBase getVarLengthColumnPage(TableSpec.ColumnSpec columnSpec, byte[] lvEncodedBytes, DataType dataType, int lvLength, int rowId, ColumnPage rowOffset, int offset, String compressorName) {
        int numRows = rowId;
        int inputDataLength = offset;
        DecimalColumnPage page = unsafe ? new UnsafeDecimalColumnPage(new ColumnPageEncoderMeta(columnSpec, dataType, compressorName), numRows, inputDataLength) : new SafeDecimalColumnPage(new ColumnPageEncoderMeta(columnSpec, dataType, compressorName), numRows);
        page.totalLength = offset;
        page.rowOffset.freeMemory();
        page.rowOffset = rowOffset;
        int lvEncodedOffset = 0;
        for (int i = 0; i < numRows; ++i) {
            int length = rowOffset.getInt(i + 1) - rowOffset.getInt(i);
            page.putBytes(i, lvEncodedBytes, lvEncodedOffset + lvLength, length);
            lvEncodedOffset += lvLength + length;
        }
        return page;
    }

    @Override
    public void putByte(int rowId, byte value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putShort(int rowId, short value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putShortInt(int rowId, int value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putInt(int rowId, int value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putLong(int rowId, long value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putDouble(int rowId, double value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void putFloat(int rowId, float value) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    abstract void putBytesAtRow(int var1, byte[] var2);

    @Override
    public void putBytes(int rowId, byte[] bytes) {
        if (bytes.length > Integer.MAX_VALUE - this.totalLength - rowId * 4) {
            throw new RuntimeException("Carbondata only support maximum 2GB size for one column page, exceed this limit at rowId " + rowId);
        }
        if (rowId == 0) {
            this.rowOffset.putInt(0, 0);
        }
        this.rowOffset.putInt(rowId + 1, this.rowOffset.getInt(rowId) + bytes.length);
        this.putBytesAtRow(rowId, bytes);
        this.totalLength += bytes.length;
    }

    @Override
    public byte getByte(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public short getShort(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public int getShortInt(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public int getInt(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public long getLong(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public float getFloat(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public double getDouble(int rowId) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getBytePage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public short[] getShortPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getShortIntPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public int[] getIntPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public long[] getLongPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public float[] getFloatPage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public double[] getDoublePage() {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public byte[] getDecimalPage() {
        int offset = 0;
        byte[] data = new byte[this.totalLength];
        for (int rowId = 0; rowId < this.pageSize; ++rowId) {
            int length = this.rowOffset.getInt(rowId + 1) - this.rowOffset.getInt(rowId);
            this.copyBytes(rowId, data, offset, length);
            offset += length;
        }
        return data;
    }

    abstract void copyBytes(int var1, byte[] var2, int var3, int var4);

    @Override
    public byte[] getLVFlattenedBytePage() throws IOException {
        int offset = 0;
        byte[] data = new byte[this.totalLength + (this.rowOffset.getActualRowCount() - 1) * 4];
        for (int rowId = 0; rowId < this.rowOffset.getActualRowCount() - 1; ++rowId) {
            int length = this.rowOffset.getInt(rowId + 1) - this.rowOffset.getInt(rowId);
            ByteUtil.setInt(data, offset, length);
            this.copyBytes(rowId, data, offset + 4, length);
            offset += 4 + length;
        }
        return data;
    }

    @Override
    public byte[] getComplexChildrenLVFlattenedBytePage(DataType dataType) throws IOException {
        int offset = 0;
        int outputLength = dataType == DataTypes.BYTE_ARRAY ? this.totalLength + (this.rowOffset.getActualRowCount() - 1) * 4 : this.totalLength + (this.rowOffset.getActualRowCount() - 1) * 2;
        byte[] data = new byte[outputLength];
        for (int rowId = 0; rowId < this.rowOffset.getActualRowCount() - 1; ++rowId) {
            int length;
            if (dataType == DataTypes.BYTE_ARRAY) {
                length = this.rowOffset.getInt(rowId + 1) - this.rowOffset.getInt(rowId);
                ByteUtil.setInt(data, offset, length);
                this.copyBytes(rowId, data, offset + 4, length);
                offset += 4 + length;
                continue;
            }
            length = (short)(this.rowOffset.getInt(rowId + 1) - this.rowOffset.getInt(rowId));
            ByteUtil.setShort(data, offset, length);
            this.copyBytes(rowId, data, offset + 2, length);
            offset += 2 + length;
        }
        return data;
    }

    @Override
    public byte[] getComplexParentFlattenedBytePage() throws IOException {
        int offset = 0;
        byte[] data = new byte[this.totalLength];
        for (int rowId = 0; rowId < this.rowOffset.getActualRowCount() - 1; ++rowId) {
            int length = this.rowOffset.getInt(rowId + 1) - this.rowOffset.getInt(rowId);
            this.copyBytes(rowId, data, offset, length);
            offset += length;
        }
        return data;
    }

    @Override
    public void convertValue(ColumnPageValueConverter codec) {
        throw new UnsupportedOperationException("invalid data type: " + this.columnPageEncoderMeta.getStoreDataType());
    }

    @Override
    public void freeMemory() {
        if (null != this.rowOffset) {
            this.rowOffset.freeMemory();
            this.rowOffset = null;
        }
    }

    @Override
    public long getPageLengthInBytes() {
        return this.totalLength;
    }
}

