/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.encoding;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.ColumnType;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.ComplexColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.datastore.page.encoding.DefaultEncodingFactory;
import org.apache.carbondata.core.datastore.page.encoding.EncodedColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.compress.DirectCompressCodec;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.CarbonMetadataUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.format.BlockletMinMaxIndex;
import org.apache.carbondata.format.DataChunk2;
import org.apache.carbondata.format.Encoding;
import org.apache.carbondata.format.LocalDictionaryChunk;
import org.apache.carbondata.format.LocalDictionaryChunkMeta;
import org.apache.carbondata.format.PresenceMeta;
import org.apache.log4j.Logger;

public abstract class ColumnPageEncoder {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)ColumnPageEncoder.class.getName());

    protected abstract ByteBuffer encodeData(ColumnPage var1) throws IOException;

    protected abstract List<Encoding> getEncodingList();

    protected abstract ColumnPageEncoderMeta getEncoderMeta(ColumnPage var1);

    public DataType getTargetDataType(ColumnPage inputPage) {
        ColumnPageEncoderMeta encoderMeta = this.getEncoderMeta(inputPage);
        if (null != encoderMeta) {
            return encoderMeta.getStoreDataType();
        }
        return null;
    }

    public Encoding getEncodingType() {
        List<Encoding> currEncodingList = this.getEncodingList();
        if (CarbonUtil.isEncodedWithMeta(currEncodingList)) {
            return currEncodingList.get(0);
        }
        return null;
    }

    public EncodedColumnPage encode(ColumnPage inputPage) throws IOException {
        ByteBuffer encodedBytes = this.encodeData(inputPage);
        DataChunk2 pageMetadata = this.buildPageMetadata(inputPage, encodedBytes);
        return new EncodedColumnPage(pageMetadata, encodedBytes, inputPage);
    }

    private DataChunk2 buildPageMetadata(ColumnPage inputPage, ByteBuffer encodedBytes) throws IOException {
        DataChunk2 dataChunk = new DataChunk2();
        dataChunk.setData_page_length(encodedBytes.limit() - encodedBytes.position());
        this.fillBasicFields(inputPage, dataChunk);
        this.fillNullBitSet(inputPage, dataChunk);
        this.fillEncoding(inputPage, dataChunk);
        this.fillMinMaxIndex(inputPage, dataChunk);
        this.fillLegacyFields(dataChunk);
        return dataChunk;
    }

    private void fillBasicFields(ColumnPage inputPage, DataChunk2 dataChunk) throws IOException {
        dataChunk.setChunk_meta(CarbonMetadataUtil.getChunkCompressorMeta(inputPage, dataChunk.getData_page_length()));
        dataChunk.setNumberOfRowsInpage(inputPage.getPageSize());
        dataChunk.setRowMajor(false);
    }

    private void fillNullBitSet(ColumnPage inputPage, DataChunk2 dataChunk) {
        PresenceMeta presenceMeta = new PresenceMeta();
        presenceMeta.setPresent_bit_streamIsSet(true);
        Compressor compressor = CompressorFactory.getInstance().getCompressor(inputPage.getColumnCompressorName());
        presenceMeta.setPresent_bit_stream(compressor.compressByte(inputPage.getNullBits().toByteArray()));
        dataChunk.setPresence(presenceMeta);
    }

    private void fillEncoding(ColumnPage inputPage, DataChunk2 dataChunk) throws IOException {
        dataChunk.setEncoders(this.getEncodingList());
        dataChunk.setEncoder_meta(this.buildEncoderMeta(inputPage));
    }

    private List<ByteBuffer> buildEncoderMeta(ColumnPage inputPage) throws IOException {
        ColumnPageEncoderMeta meta = this.getEncoderMeta(inputPage);
        ArrayList<ByteBuffer> metaDatas = new ArrayList<ByteBuffer>();
        if (meta != null) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(stream);
            meta.write(out);
            metaDatas.add(ByteBuffer.wrap(stream.toByteArray()));
        }
        return metaDatas;
    }

    private void fillMinMaxIndex(ColumnPage inputPage, DataChunk2 dataChunk) {
        dataChunk.setMin_max(this.buildMinMaxIndex(inputPage, dataChunk.encoders));
    }

    private BlockletMinMaxIndex buildMinMaxIndex(ColumnPage inputPage, List<Encoding> encoders) {
        ByteBuffer min;
        ByteBuffer max;
        BlockletMinMaxIndex index = new BlockletMinMaxIndex();
        if (CarbonUtil.isEncodedWithMeta(encoders) && inputPage.getColumnSpec().getColumnType() == ColumnType.PLAIN_VALUE) {
            max = ByteBuffer.wrap(DataTypeUtil.getMinMaxBytesBasedOnDataTypeForNoDictionaryColumn(inputPage.getStatistics().getMax(), inputPage.getDataType()));
            min = ByteBuffer.wrap(DataTypeUtil.getMinMaxBytesBasedOnDataTypeForNoDictionaryColumn(inputPage.getStatistics().getMin(), inputPage.getDataType()));
        } else {
            byte[] bytes = CarbonUtil.getValueAsBytes(inputPage.getDataType(), inputPage.getStatistics().getMax());
            max = ByteBuffer.wrap(bytes);
            min = ByteBuffer.wrap(CarbonUtil.getValueAsBytes(inputPage.getDataType(), inputPage.getStatistics().getMin()));
        }
        index.addToMax_values(max);
        index.addToMin_values(min);
        index.addToMin_max_presence(inputPage.getStatistics().writeMinMax());
        return index;
    }

    protected void fillLegacyFields(DataChunk2 dataChunk) {
    }

    public static EncodedColumnPage[] encodeComplexColumn(ComplexColumnPage input) throws IOException {
        EncodedColumnPage[] encodedPages = new EncodedColumnPage[input.getComplexColumnIndex()];
        for (int index = 0; index < input.getComplexColumnIndex(); ++index) {
            ColumnPage subColumnPage = input.getColumnPage(index);
            encodedPages[index] = ColumnPageEncoder.encodedColumn(subColumnPage);
            encodedPages[index].getPageMetadata().getEncoders().add(Encoding.INT_LENGTH_COMPLEX_CHILD_BYTE_ARRAY);
        }
        return encodedPages;
    }

    public static EncodedColumnPage encodedColumn(ColumnPage page) throws IOException {
        ColumnPageEncoder pageEncoder = ColumnPageEncoder.createCodecForDimension(page);
        if (pageEncoder == null) {
            ColumnPageEncoder encoder = new DirectCompressCodec(DataTypes.BYTE_ARRAY).createEncoder(null);
            return encoder.encode(page);
        }
        LOGGER.debug((Object)("Encoder result ---> Source data type: " + pageEncoder.getEncoderMeta(page).getColumnSpec().getSchemaDataType() + " Destination data type: " + pageEncoder.getEncoderMeta(page).getStoreDataType() + " for the column: " + pageEncoder.getEncoderMeta(page).getColumnSpec().getFieldName()));
        return pageEncoder.encode(page);
    }

    private static ColumnPageEncoder createCodecForDimension(ColumnPage inputPage) {
        TableSpec.ColumnSpec columnSpec = inputPage.getColumnSpec();
        if (columnSpec.getColumnType() == ColumnType.COMPLEX_PRIMITIVE) {
            if (inputPage.getDataType() == DataTypes.BYTE_ARRAY || inputPage.getDataType() == DataTypes.STRING) {
                return null;
            }
            if (inputPage.getDataType() == DataTypes.BYTE || inputPage.getDataType() == DataTypes.SHORT || inputPage.getDataType() == DataTypes.INT || inputPage.getDataType() == DataTypes.LONG) {
                return DefaultEncodingFactory.selectCodecByAlgorithmForIntegral(inputPage.getStatistics(), true, columnSpec).createEncoder(null);
            }
            if (inputPage.getDataType() == DataTypes.FLOAT || inputPage.getDataType() == DataTypes.DOUBLE) {
                return DefaultEncodingFactory.selectCodecByAlgorithmForFloating(inputPage.getStatistics(), true, columnSpec).createEncoder(null);
            }
        }
        return null;
    }

    public LocalDictionaryChunk encodeDictionary(ColumnPage dictionaryPage) throws IOException {
        LocalDictionaryChunk localDictionaryChunk = new LocalDictionaryChunk();
        localDictionaryChunk.setDictionary_data(this.encodeData(dictionaryPage));
        LocalDictionaryChunkMeta localDictionaryChunkMeta = new LocalDictionaryChunkMeta();
        localDictionaryChunkMeta.setEncoders(this.getEncodingList());
        localDictionaryChunkMeta.setEncoder_meta(this.buildEncoderMeta(dictionaryPage));
        localDictionaryChunk.setDictionary_meta(localDictionaryChunkMeta);
        return localDictionaryChunk;
    }
}

