/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.encoding;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.metadata.ValueEncoderMeta;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalType;
import org.apache.carbondata.core.metadata.schema.table.Writable;
import org.apache.carbondata.core.util.DataTypeUtil;

public class ColumnPageEncoderMeta
extends ValueEncoderMeta
implements Writable {
    private static final long serialVersionUID = 1905162071950251407L;
    private transient TableSpec.ColumnSpec columnSpec;
    private DataType storeDataType;
    protected String compressorName;
    private transient boolean fillCompleteVector;

    public ColumnPageEncoderMeta() {
    }

    public ColumnPageEncoderMeta(TableSpec.ColumnSpec columnSpec, DataType storeDataType, String compressorName) {
        if (columnSpec == null) {
            throw new IllegalArgumentException("columm spec must not be null");
        }
        if (storeDataType == null) {
            throw new IllegalArgumentException("store data type must not be null");
        }
        if (compressorName == null) {
            throw new IllegalArgumentException("compressor must not be null");
        }
        this.columnSpec = columnSpec;
        this.storeDataType = storeDataType;
        this.compressorName = compressorName;
        this.setType(DataType.convertType(storeDataType));
    }

    public ColumnPageEncoderMeta(TableSpec.ColumnSpec columnSpec, DataType storeDataType, SimpleStatsResult stats, String compressorName) {
        this(columnSpec, storeDataType, compressorName);
        if (stats != null) {
            this.setDecimal(stats.getDecimalCount());
            this.setMaxValue(stats.getMax());
            this.setMinValue(stats.getMin());
        }
    }

    public DataType getStoreDataType() {
        return this.storeDataType;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.columnSpec.write(out);
        out.writeByte(this.storeDataType.getId());
        out.writeInt(this.getDecimal());
        out.writeByte(this.getDataTypeSelected());
        this.writeMinMax(out);
        out.writeUTF(this.compressorName);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.columnSpec = new TableSpec.ColumnSpec();
        this.columnSpec.readFields(in);
        this.storeDataType = DataTypes.valueOf(in.readByte());
        if (DataTypes.isDecimal(this.storeDataType)) {
            DecimalType decimalType = (DecimalType)this.storeDataType;
            decimalType.setPrecision(this.columnSpec.getPrecision());
            decimalType.setScale(this.columnSpec.getScale());
        }
        this.setDecimal(in.readInt());
        this.setDataTypeSelected(in.readByte());
        this.readMinMax(in);
        this.compressorName = in.readUTF();
    }

    private void writeMinMax(DataOutput out) throws IOException {
        DataType dataType = this.columnSpec.getSchemaDataType();
        if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.BYTE) {
            out.writeByte(((Byte)this.getMaxValue()).byteValue());
            out.writeByte(((Byte)this.getMinValue()).byteValue());
            out.writeLong(0L);
        } else if (dataType == DataTypes.SHORT) {
            out.writeShort(((Short)this.getMaxValue()).shortValue());
            out.writeShort(((Short)this.getMinValue()).shortValue());
            out.writeLong(0L);
        } else if (dataType == DataTypes.INT) {
            out.writeInt((Integer)this.getMaxValue());
            out.writeInt((Integer)this.getMinValue());
            out.writeLong(0L);
        } else if (dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
            out.writeLong((Long)this.getMaxValue());
            out.writeLong((Long)this.getMinValue());
            out.writeLong(0L);
        } else if (dataType == DataTypes.DOUBLE) {
            out.writeDouble((Double)this.getMaxValue());
            out.writeDouble((Double)this.getMinValue());
            out.writeDouble(0.0);
        } else if (dataType == DataTypes.FLOAT) {
            out.writeFloat(((Float)this.getMaxValue()).floatValue());
            out.writeFloat(((Float)this.getMinValue()).floatValue());
            out.writeFloat(0.0f);
        } else if (DataTypes.isDecimal(dataType)) {
            byte[] maxAsBytes = this.getMaxAsBytes(this.columnSpec.getSchemaDataType());
            byte[] minAsBytes = this.getMinAsBytes(this.columnSpec.getSchemaDataType());
            byte[] unique = DataTypeUtil.bigDecimalToByte(BigDecimal.ZERO);
            out.writeShort((short)maxAsBytes.length);
            out.write(maxAsBytes);
            out.writeShort((short)minAsBytes.length);
            out.write(minAsBytes);
            out.writeShort((short)unique.length);
            out.write(unique);
            if (DataTypes.isDecimal(dataType)) {
                DecimalType decimalType = (DecimalType)dataType;
                out.writeInt(decimalType.getScale());
                out.writeInt(decimalType.getPrecision());
            } else {
                out.writeInt(-1);
                out.writeInt(-1);
            }
        } else if (dataType != DataTypes.BYTE_ARRAY && dataType != DataTypes.BINARY) {
            throw new IllegalArgumentException("invalid data type: " + this.storeDataType);
        }
    }

    private void readMinMax(DataInput in) throws IOException {
        DataType dataType = this.columnSpec.getSchemaDataType();
        if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.BYTE) {
            this.setMaxValue(in.readByte());
            this.setMinValue(in.readByte());
            in.readLong();
        } else if (dataType == DataTypes.SHORT) {
            this.setMaxValue(in.readShort());
            this.setMinValue(in.readShort());
            in.readLong();
        } else if (dataType == DataTypes.INT) {
            this.setMaxValue(in.readInt());
            this.setMinValue(in.readInt());
            in.readLong();
        } else if (dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
            this.setMaxValue(in.readLong());
            this.setMinValue(in.readLong());
            in.readLong();
        } else if (dataType == DataTypes.DOUBLE) {
            this.setMaxValue(in.readDouble());
            this.setMinValue(in.readDouble());
            in.readDouble();
        } else if (dataType == DataTypes.FLOAT) {
            this.setMaxValue(Float.valueOf(in.readFloat()));
            this.setMinValue(Float.valueOf(in.readFloat()));
            in.readFloat();
        } else if (DataTypes.isDecimal(dataType)) {
            byte[] max = new byte[in.readShort()];
            in.readFully(max);
            this.setMaxValue(DataTypeUtil.byteToBigDecimal(max));
            byte[] min = new byte[in.readShort()];
            in.readFully(min);
            this.setMinValue(DataTypeUtil.byteToBigDecimal(min));
            short uniqueLength = in.readShort();
            in.readFully(new byte[uniqueLength]);
            in.readInt();
            in.readInt();
        } else if (dataType != DataTypes.BYTE_ARRAY && dataType != DataTypes.BINARY) {
            throw new IllegalArgumentException("invalid data type: " + this.storeDataType);
        }
    }

    private byte[] getMaxAsBytes(DataType dataType) {
        return this.getValueAsBytes(this.getMaxValue(), dataType);
    }

    private byte[] getMinAsBytes(DataType dataType) {
        return this.getValueAsBytes(this.getMinValue(), dataType);
    }

    private byte[] getValueAsBytes(Object value, DataType dataType) {
        if (dataType == DataTypes.BYTE_ARRAY) {
            ByteBuffer b = ByteBuffer.allocate(8);
            b.putLong(((Byte)value).byteValue());
            b.flip();
            return b.array();
        }
        if (dataType == DataTypes.SHORT) {
            ByteBuffer b = ByteBuffer.allocate(8);
            b.putLong(((Short)value).shortValue());
            b.flip();
            return b.array();
        }
        if (dataType == DataTypes.INT) {
            ByteBuffer b = ByteBuffer.allocate(8);
            b.putLong(((Integer)value).intValue());
            b.flip();
            return b.array();
        }
        if (dataType == DataTypes.LONG) {
            ByteBuffer b = ByteBuffer.allocate(8);
            b.putLong((Long)value);
            b.flip();
            return b.array();
        }
        if (dataType == DataTypes.DOUBLE) {
            ByteBuffer b = ByteBuffer.allocate(8);
            b.putDouble((Double)value);
            b.flip();
            return b.array();
        }
        if (DataTypes.isDecimal(dataType)) {
            return DataTypeUtil.bigDecimalToByte((BigDecimal)value);
        }
        if (dataType == DataTypes.STRING || dataType == DataTypes.TIMESTAMP || dataType == DataTypes.DATE) {
            return (byte[])value;
        }
        throw new IllegalArgumentException("Invalid data type: " + this.storeDataType);
    }

    public int getScale() {
        if (DataTypes.isDecimal(this.columnSpec.getSchemaDataType())) {
            return this.columnSpec.getScale();
        }
        throw new UnsupportedOperationException();
    }

    public int getPrecision() {
        if (DataTypes.isDecimal(this.columnSpec.getSchemaDataType())) {
            return this.columnSpec.getPrecision();
        }
        throw new UnsupportedOperationException();
    }

    public TableSpec.ColumnSpec getColumnSpec() {
        return this.columnSpec;
    }

    public String getCompressorName() {
        return this.compressorName;
    }

    public DataType getSchemaDataType() {
        return this.columnSpec.getSchemaDataType();
    }

    public boolean isFillCompleteVector() {
        return this.fillCompleteVector;
    }

    public void setFillCompleteVector(boolean fillCompleteVector) {
        this.fillCompleteVector = fillCompleteVector;
    }
}

