/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.encoding;

import java.math.BigDecimal;
import org.apache.carbondata.core.datastore.ColumnType;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.DecimalColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageCodec;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoder;
import org.apache.carbondata.core.datastore.page.encoding.EncodingFactory;
import org.apache.carbondata.core.datastore.page.encoding.adaptive.AdaptiveDeltaFloatingCodec;
import org.apache.carbondata.core.datastore.page.encoding.adaptive.AdaptiveDeltaIntegralCodec;
import org.apache.carbondata.core.datastore.page.encoding.adaptive.AdaptiveFloatingCodec;
import org.apache.carbondata.core.datastore.page.encoding.adaptive.AdaptiveIntegralCodec;
import org.apache.carbondata.core.datastore.page.encoding.compress.DirectCompressCodec;
import org.apache.carbondata.core.datastore.page.encoding.dimension.legacy.ComplexDimensionIndexCodec;
import org.apache.carbondata.core.datastore.page.encoding.dimension.legacy.DirectDictDimensionIndexCodec;
import org.apache.carbondata.core.datastore.page.encoding.dimension.legacy.PlainDimensionIndexCodec;
import org.apache.carbondata.core.datastore.page.statistics.PrimitivePageStatsCollector;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalConverterFactory;
import org.apache.carbondata.core.util.DataTypeUtil;

public class DefaultEncodingFactory
extends EncodingFactory {
    private static final int THREE_BYTES_MAX = (int)Math.pow(2.0, 23.0) - 1;
    private static final int THREE_BYTES_MIN = -THREE_BYTES_MAX - 1;
    private static final boolean newWay = false;
    private static EncodingFactory encodingFactory = new DefaultEncodingFactory();

    public static EncodingFactory getInstance() {
        return encodingFactory;
    }

    @Override
    public ColumnPageEncoder createEncoder(TableSpec.ColumnSpec columnSpec, ColumnPage inputPage) {
        if (columnSpec instanceof TableSpec.MeasureSpec || DataTypeUtil.isPrimitiveColumn(columnSpec.getSchemaDataType()) && columnSpec.getColumnType() == ColumnType.PLAIN_VALUE) {
            return this.createEncoderForMeasureOrNoDictionaryPrimitive(inputPage, columnSpec);
        }
        assert (columnSpec instanceof TableSpec.DimensionSpec);
        return this.createEncoderForDimensionLegacy((TableSpec.DimensionSpec)columnSpec);
    }

    private ColumnPageEncoder createEncoderForDimension(TableSpec.DimensionSpec columnSpec, ColumnPage inputPage) {
        switch (columnSpec.getColumnType()) {
            case DIRECT_DICTIONARY: 
            case PLAIN_VALUE: {
                return new DirectCompressCodec(inputPage.getDataType()).createEncoder(null);
            }
            case COMPLEX: {
                return new ComplexDimensionIndexCodec(false, false).createEncoder(null);
            }
        }
        throw new RuntimeException("unsupported dimension type: " + (Object)((Object)columnSpec.getColumnType()));
    }

    private ColumnPageEncoder createEncoderForDimensionLegacy(TableSpec.DimensionSpec dimensionSpec) {
        switch (dimensionSpec.getColumnType()) {
            case DIRECT_DICTIONARY: {
                return new DirectDictDimensionIndexCodec(dimensionSpec.isInSortColumns(), dimensionSpec.isInSortColumns() && dimensionSpec.isDoInvertedIndex()).createEncoder(null);
            }
            case PLAIN_VALUE: {
                return new PlainDimensionIndexCodec(dimensionSpec.isInSortColumns(), dimensionSpec.isInSortColumns() && dimensionSpec.isDoInvertedIndex(), dimensionSpec.getSchemaDataType() == DataTypes.VARCHAR || dimensionSpec.getSchemaDataType() == DataTypes.BINARY).createEncoder(null);
            }
        }
        throw new RuntimeException("unsupported dimension type: " + (Object)((Object)dimensionSpec.getColumnType()));
    }

    private ColumnPageEncoder createEncoderForMeasureOrNoDictionaryPrimitive(ColumnPage columnPage, TableSpec.ColumnSpec columnSpec) {
        SimpleStatsResult stats = columnPage.getStatistics();
        DataType dataType = stats.getDataType();
        if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.BYTE_ARRAY || columnPage.getDataType() == DataTypes.BINARY) {
            return new DirectCompressCodec(columnPage.getDataType()).createEncoder(null);
        }
        if (dataType == DataTypes.BYTE || dataType == DataTypes.SHORT || dataType == DataTypes.INT || dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
            return DefaultEncodingFactory.selectCodecByAlgorithmForIntegral(stats, false, columnSpec).createEncoder(null);
        }
        if (DataTypes.isDecimal(dataType)) {
            return this.createEncoderForDecimalDataTypeMeasure(columnPage, columnSpec);
        }
        if (dataType == DataTypes.FLOAT || dataType == DataTypes.DOUBLE) {
            return DefaultEncodingFactory.selectCodecByAlgorithmForFloating(stats, false, columnSpec).createEncoder(null);
        }
        throw new RuntimeException("unsupported data type: " + stats.getDataType());
    }

    private ColumnPageEncoder createEncoderForDecimalDataTypeMeasure(ColumnPage columnPage, TableSpec.ColumnSpec columnSpec) {
        DecimalConverterFactory.DecimalConverterType decimalConverterType = ((DecimalColumnPage)columnPage).getDecimalConverter().getDecimalConverterType();
        switch (decimalConverterType) {
            case DECIMAL_INT: 
            case DECIMAL_LONG: {
                return DefaultEncodingFactory.selectCodecByAlgorithmForDecimal(columnPage.getStatistics(), decimalConverterType, columnSpec).createEncoder(null);
            }
        }
        return new DirectCompressCodec(columnPage.getDataType()).createEncoder(null);
    }

    private static DataType fitLongMinMax(long max, long min) {
        if (max <= 127L && min >= -128L) {
            return DataTypes.BYTE;
        }
        if (max <= 32767L && min >= -32768L) {
            return DataTypes.SHORT;
        }
        if (max <= (long)THREE_BYTES_MAX && min >= (long)THREE_BYTES_MIN) {
            return DataTypes.SHORT_INT;
        }
        if (max <= Integer.MAX_VALUE && min >= Integer.MIN_VALUE) {
            return DataTypes.INT;
        }
        return DataTypes.LONG;
    }

    private static DataType fitMinMax(DataType dataType, Object max, Object min) {
        if (dataType == DataTypes.BYTE || dataType == DataTypes.BOOLEAN) {
            return DefaultEncodingFactory.fitLongMinMax(((Byte)max).byteValue(), ((Byte)min).byteValue());
        }
        if (dataType == DataTypes.SHORT) {
            return DefaultEncodingFactory.fitLongMinMax(((Short)max).shortValue(), ((Short)min).shortValue());
        }
        if (dataType == DataTypes.INT) {
            return DefaultEncodingFactory.fitLongMinMax(((Integer)max).intValue(), ((Integer)min).intValue());
        }
        if (dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
            return DefaultEncodingFactory.fitLongMinMax((Long)max, (Long)min);
        }
        if (dataType == DataTypes.DOUBLE) {
            return DefaultEncodingFactory.fitLongMinMax((long)((Double)max).doubleValue(), (long)((Double)min).doubleValue());
        }
        throw new RuntimeException("internal error: " + dataType);
    }

    private static DataType fitMinMaxForDecimalType(DataType dataType, Object max, Object min, DecimalConverterFactory.DecimalConverterType decimalConverterType) {
        long maxValue = ((BigDecimal)max).unscaledValue().longValue();
        long minValue = ((BigDecimal)min).unscaledValue().longValue();
        switch (decimalConverterType) {
            case DECIMAL_INT: {
                return DefaultEncodingFactory.fitLongMinMax((int)maxValue, (int)minValue);
            }
            case DECIMAL_LONG: {
                return DefaultEncodingFactory.fitLongMinMax(maxValue, minValue);
            }
        }
        throw new RuntimeException("internal error: " + dataType);
    }

    private static DataType fitDeltaForDecimalType(DataType dataType, Object max, Object min, DecimalConverterFactory.DecimalConverterType decimalConverterType) {
        long maxValue = ((BigDecimal)max).unscaledValue().longValue();
        long minValue = ((BigDecimal)min).unscaledValue().longValue();
        switch (decimalConverterType) {
            case DECIMAL_INT: {
                long value = maxValue - minValue;
                return DefaultEncodingFactory.compareMinMaxAndSelectDataType(value);
            }
            case DECIMAL_LONG: {
                return DataTypes.LONG;
            }
        }
        throw new RuntimeException("internal error: " + dataType);
    }

    private static DataType fitDelta(DataType dataType, Object max, Object min) {
        long value;
        if (dataType == DataTypes.BYTE || dataType == DataTypes.BOOLEAN) {
            value = (long)((Byte)max).byteValue() - (long)((Byte)min).byteValue();
        } else if (dataType == DataTypes.SHORT) {
            value = (long)((Short)max).shortValue() - (long)((Short)min).shortValue();
        } else if (dataType == DataTypes.INT) {
            value = (long)((Integer)max).intValue() - (long)((Integer)min).intValue();
        } else if (dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
            boolean overflow;
            value = (Long)max - (Long)min;
            boolean bl = overflow = (((Long)max ^ (Long)min) & ((Long)max ^ value)) < 0L;
            if (overflow) {
                return DataTypes.LONG;
            }
        } else {
            if (dataType == DataTypes.DOUBLE) {
                return DataTypes.LONG;
            }
            throw new RuntimeException("internal error: " + dataType);
        }
        return DefaultEncodingFactory.compareMinMaxAndSelectDataType(value);
    }

    private static DataType compareMinMaxAndSelectDataType(long value) {
        if (value <= 127L && value >= -128L) {
            return DataTypes.BYTE;
        }
        if (value <= 32767L && value >= -32768L) {
            return DataTypes.SHORT;
        }
        if (value <= (long)THREE_BYTES_MAX && value >= (long)THREE_BYTES_MIN) {
            return DataTypes.SHORT_INT;
        }
        if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
            return DataTypes.INT;
        }
        return DataTypes.LONG;
    }

    static ColumnPageCodec selectCodecByAlgorithmForIntegral(SimpleStatsResult stats, boolean isComplexPrimitive, TableSpec.ColumnSpec columnSpec) {
        DataType srcDataType = stats.getDataType();
        DataType adaptiveDataType = DefaultEncodingFactory.fitMinMax(stats.getDataType(), stats.getMax(), stats.getMin());
        DataType deltaDataType = DefaultEncodingFactory.fitDelta(stats.getDataType(), stats.getMax(), stats.getMin());
        if (!isComplexPrimitive && Math.min(adaptiveDataType.getSizeInBytes(), deltaDataType.getSizeInBytes()) == srcDataType.getSizeInBytes()) {
            return new DirectCompressCodec(stats.getDataType());
        }
        boolean isInvertedIndex = DefaultEncodingFactory.isInvertedIndex(isComplexPrimitive, columnSpec);
        if (adaptiveDataType.getSizeInBytes() <= deltaDataType.getSizeInBytes()) {
            return new AdaptiveIntegralCodec(stats.getDataType(), adaptiveDataType, stats, isInvertedIndex);
        }
        return new AdaptiveDeltaIntegralCodec(stats.getDataType(), deltaDataType, stats, isInvertedIndex);
    }

    private static boolean isInvertedIndex(boolean isComplexPrimitive, TableSpec.ColumnSpec columnSpec) {
        boolean isInvertedIndex = false;
        if (columnSpec instanceof TableSpec.DimensionSpec && !isComplexPrimitive) {
            boolean isSort = ((TableSpec.DimensionSpec)columnSpec).isInSortColumns();
            isInvertedIndex = isSort && ((TableSpec.DimensionSpec)columnSpec).isDoInvertedIndex();
        }
        return isInvertedIndex;
    }

    static ColumnPageCodec selectCodecByAlgorithmForFloating(SimpleStatsResult stats, boolean isComplexPrimitive, TableSpec.ColumnSpec columnSpec) {
        double minValue;
        double maxValue;
        DataType srcDataType = stats.getDataType();
        if (srcDataType == DataTypes.FLOAT) {
            maxValue = ((Float)stats.getMax()).floatValue();
            minValue = ((Float)stats.getMin()).floatValue();
        } else {
            maxValue = (Double)stats.getMax();
            minValue = (Double)stats.getMin();
        }
        int decimalCount = stats.getDecimalCount();
        if (isComplexPrimitive && decimalCount == -1 && stats instanceof PrimitivePageStatsCollector) {
            decimalCount = ((PrimitivePageStatsCollector)stats).getDecimalForComplexPrimitive();
        }
        double absMaxValue = Math.max(Math.abs(maxValue), Math.abs(minValue));
        if (srcDataType == DataTypes.FLOAT && decimalCount == 0) {
            return DefaultEncodingFactory.getColumnPageCodec(stats, isComplexPrimitive, columnSpec, srcDataType, maxValue, minValue, decimalCount, absMaxValue);
        }
        if (decimalCount == 0) {
            return DefaultEncodingFactory.selectCodecByAlgorithmForIntegral(stats, false, columnSpec);
        }
        if (decimalCount < 0 && !isComplexPrimitive) {
            return new DirectCompressCodec(DataTypes.DOUBLE);
        }
        return DefaultEncodingFactory.getColumnPageCodec(stats, isComplexPrimitive, columnSpec, srcDataType, maxValue, minValue, decimalCount, absMaxValue);
    }

    private static ColumnPageCodec getColumnPageCodec(SimpleStatsResult stats, boolean isComplexPrimitive, TableSpec.ColumnSpec columnSpec, DataType srcDataType, double maxValue, double minValue, int decimalCount, double absMaxValue) {
        if (Math.pow(10.0, decimalCount) * absMaxValue > 9.223372036854776E18) {
            return new DirectCompressCodec(DataTypes.DOUBLE);
        }
        long max = (long)(Math.pow(10.0, decimalCount) * absMaxValue);
        DataType adaptiveDataType = DefaultEncodingFactory.fitLongMinMax(max, 0L);
        DataType deltaDataType = DefaultEncodingFactory.compareMinMaxAndSelectDataType((long)(Math.pow(10.0, decimalCount) * (maxValue - minValue)));
        if (adaptiveDataType.getSizeInBytes() > deltaDataType.getSizeInBytes()) {
            return new AdaptiveDeltaFloatingCodec(srcDataType, deltaDataType, stats, DefaultEncodingFactory.isInvertedIndex(isComplexPrimitive, columnSpec));
        }
        if (adaptiveDataType.getSizeInBytes() < DataTypes.DOUBLE.getSizeInBytes() || isComplexPrimitive && adaptiveDataType.getSizeInBytes() == DataTypes.DOUBLE.getSizeInBytes()) {
            return new AdaptiveFloatingCodec(srcDataType, adaptiveDataType, stats, DefaultEncodingFactory.isInvertedIndex(isComplexPrimitive, columnSpec));
        }
        return new DirectCompressCodec(DataTypes.DOUBLE);
    }

    static ColumnPageCodec selectCodecByAlgorithmForDecimal(SimpleStatsResult stats, DecimalConverterFactory.DecimalConverterType decimalConverterType, TableSpec.ColumnSpec columnSpec) {
        DataType srcDataType = stats.getDataType();
        DataType adaptiveDataType = DefaultEncodingFactory.fitMinMaxForDecimalType(stats.getDataType(), stats.getMax(), stats.getMin(), decimalConverterType);
        DataType deltaDataType = adaptiveDataType == DataTypes.LONG ? DataTypes.LONG : DefaultEncodingFactory.fitDeltaForDecimalType(stats.getDataType(), stats.getMax(), stats.getMin(), decimalConverterType);
        if (Math.min(adaptiveDataType.getSizeInBytes(), deltaDataType.getSizeInBytes()) == srcDataType.getSizeInBytes()) {
            return new DirectCompressCodec(stats.getDataType());
        }
        if (adaptiveDataType.getSizeInBytes() <= deltaDataType.getSizeInBytes()) {
            return new AdaptiveIntegralCodec(stats.getDataType(), adaptiveDataType, stats, DefaultEncodingFactory.isInvertedIndex(columnSpec.getColumnType() == ColumnType.COMPLEX_PRIMITIVE, columnSpec));
        }
        return new AdaptiveDeltaIntegralCodec(stats.getDataType(), deltaDataType, stats, DefaultEncodingFactory.isInvertedIndex(columnSpec.getColumnType() == ColumnType.COMPLEX_PRIMITIVE, columnSpec));
    }
}

