/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.encoding;

import java.nio.ByteBuffer;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.LocalDictColumnPage;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.localdictionary.PageLevelDictionary;
import org.apache.carbondata.core.memory.UnsafeMemoryManager;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.format.DataChunk2;
import org.apache.thrift.TBase;

public class EncodedColumnPage {
    protected final ByteBuffer encodedData;
    private DataChunk2 pageMetadata;
    private ColumnPage actualPage;

    public EncodedColumnPage(DataChunk2 pageMetadata, ByteBuffer encodedData, ColumnPage actualPage) {
        if (pageMetadata == null) {
            throw new IllegalArgumentException("data chunk2 must not be null");
        }
        if (encodedData == null) {
            throw new IllegalArgumentException("encoded data must not be null");
        }
        this.pageMetadata = pageMetadata;
        this.encodedData = encodedData;
        this.actualPage = actualPage;
    }

    public ByteBuffer getEncodedData() {
        return this.encodedData;
    }

    public DataChunk2 getPageMetadata() {
        return this.pageMetadata;
    }

    public int getTotalSerializedSize() {
        int metadataSize = CarbonUtil.getByteArray((TBase)this.pageMetadata).length;
        int dataSize = this.encodedData.limit() - this.encodedData.position();
        return metadataSize + dataSize;
    }

    public SimpleStatsResult getStats() {
        return this.actualPage.getStatistics();
    }

    public ColumnPage getActualPage() {
        return this.actualPage;
    }

    public boolean isLocalDictGeneratedPage() {
        return this.actualPage.isLocalDictGeneratedPage();
    }

    public PageLevelDictionary getPageDictionary() {
        return this.actualPage.getColumnPageDictionary();
    }

    public void freeMemory() {
        if (this.actualPage instanceof LocalDictColumnPage) {
            LocalDictColumnPage page = (LocalDictColumnPage)this.actualPage;
            page.freeMemoryForce();
        }
    }

    public void cleanBuffer() {
        UnsafeMemoryManager.destroyDirectByteBuffer(this.encodedData);
    }
}

