/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.encoding;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.carbondata.core.datastore.ColumnType;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageCodec;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageDecoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.datastore.page.encoding.DefaultEncodingFactory;
import org.apache.carbondata.core.datastore.page.encoding.adaptive.AdaptiveDeltaFloatingCodec;
import org.apache.carbondata.core.datastore.page.encoding.adaptive.AdaptiveDeltaIntegralCodec;
import org.apache.carbondata.core.datastore.page.encoding.adaptive.AdaptiveFloatingCodec;
import org.apache.carbondata.core.datastore.page.encoding.adaptive.AdaptiveIntegralCodec;
import org.apache.carbondata.core.datastore.page.encoding.compress.DirectCompressCodec;
import org.apache.carbondata.core.datastore.page.encoding.rle.RLECodec;
import org.apache.carbondata.core.datastore.page.encoding.rle.RLEEncoderMeta;
import org.apache.carbondata.core.datastore.page.statistics.PrimitivePageStatsCollector;
import org.apache.carbondata.core.metadata.ValueEncoderMeta;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.format.Encoding;

public abstract class EncodingFactory {
    public abstract ColumnPageEncoder createEncoder(TableSpec.ColumnSpec var1, ColumnPage var2);

    public ColumnPageDecoder createDecoder(List<Encoding> encodings, List<ByteBuffer> encoderMetas, String compressor) throws IOException {
        return this.createDecoder(encodings, encoderMetas, compressor, false);
    }

    public ColumnPageDecoder createDecoder(List<Encoding> encodings, List<ByteBuffer> encoderMetas, String compressor, boolean fullVectorFill) throws IOException {
        assert (encodings.size() >= 1);
        assert (encoderMetas.size() == 1);
        boolean isComplexPrimitiveIntLengthEncoding = encodings.contains(Encoding.INT_LENGTH_COMPLEX_CHILD_BYTE_ARRAY);
        Encoding encoding = encodings.get(0);
        byte[] encoderMeta = encoderMetas.get(0).array();
        ByteArrayInputStream stream = new ByteArrayInputStream(encoderMeta);
        DataInputStream in = new DataInputStream(stream);
        if (encoding == Encoding.DIRECT_COMPRESS || encoding == Encoding.DIRECT_COMPRESS_VARCHAR) {
            ColumnPageEncoderMeta metadata = new ColumnPageEncoderMeta();
            metadata.setFillCompleteVector(fullVectorFill);
            metadata.readFields(in);
            DirectCompressCodec directCompressCodec = new DirectCompressCodec(metadata.getStoreDataType());
            directCompressCodec.setComplexPrimitiveIntLengthEncoding(isComplexPrimitiveIntLengthEncoding);
            return directCompressCodec.createDecoder(metadata);
        }
        if (encoding == Encoding.ADAPTIVE_INTEGRAL) {
            ColumnPageEncoderMeta metadata = new ColumnPageEncoderMeta();
            metadata.setFillCompleteVector(fullVectorFill);
            metadata.readFields(in);
            PrimitivePageStatsCollector stats = PrimitivePageStatsCollector.newInstance(metadata);
            return new AdaptiveIntegralCodec(metadata.getSchemaDataType(), metadata.getStoreDataType(), stats, encodings.contains(Encoding.INVERTED_INDEX)).createDecoder(metadata);
        }
        if (encoding == Encoding.ADAPTIVE_DELTA_INTEGRAL) {
            ColumnPageEncoderMeta metadata = new ColumnPageEncoderMeta();
            metadata.setFillCompleteVector(fullVectorFill);
            metadata.readFields(in);
            PrimitivePageStatsCollector stats = PrimitivePageStatsCollector.newInstance(metadata);
            return new AdaptiveDeltaIntegralCodec(metadata.getSchemaDataType(), metadata.getStoreDataType(), stats, encodings.contains(Encoding.INVERTED_INDEX)).createDecoder(metadata);
        }
        if (encoding == Encoding.ADAPTIVE_FLOATING) {
            ColumnPageEncoderMeta metadata = new ColumnPageEncoderMeta();
            metadata.setFillCompleteVector(fullVectorFill);
            metadata.readFields(in);
            PrimitivePageStatsCollector stats = PrimitivePageStatsCollector.newInstance(metadata);
            return new AdaptiveFloatingCodec(metadata.getSchemaDataType(), metadata.getStoreDataType(), stats, encodings.contains(Encoding.INVERTED_INDEX)).createDecoder(metadata);
        }
        if (encoding == Encoding.ADAPTIVE_DELTA_FLOATING) {
            ColumnPageEncoderMeta metadata = new ColumnPageEncoderMeta();
            metadata.setFillCompleteVector(fullVectorFill);
            metadata.readFields(in);
            PrimitivePageStatsCollector stats = PrimitivePageStatsCollector.newInstance(metadata);
            return new AdaptiveDeltaFloatingCodec(metadata.getSchemaDataType(), metadata.getStoreDataType(), stats, encodings.contains(Encoding.INVERTED_INDEX)).createDecoder(metadata);
        }
        if (encoding == Encoding.RLE_INTEGRAL) {
            RLEEncoderMeta metadata = new RLEEncoderMeta();
            metadata.readFields(in);
            return new RLECodec().createDecoder(metadata);
        }
        if (encoding == Encoding.BOOL_BYTE) {
            ColumnPageEncoderMeta metadata = new ColumnPageEncoderMeta();
            metadata.setFillCompleteVector(fullVectorFill);
            metadata.readFields(in);
            return new DirectCompressCodec(metadata.getStoreDataType()).createDecoder(metadata);
        }
        ValueEncoderMeta metadata = CarbonUtil.deserializeEncoderMetaV3(encoderMeta);
        return this.createDecoderLegacy(metadata, compressor, fullVectorFill);
    }

    public ColumnPageDecoder createDecoderLegacy(ValueEncoderMeta metadata, String compressor) {
        return this.createDecoderLegacy(metadata, compressor, false);
    }

    private ColumnPageDecoder createDecoderLegacy(ValueEncoderMeta metadata, String compressor, boolean fullVectorFill) {
        if (null == metadata) {
            throw new RuntimeException("internal error");
        }
        PrimitivePageStatsCollector stats = PrimitivePageStatsCollector.newInstance(metadata);
        TableSpec.ColumnSpec spec = TableSpec.ColumnSpec.newInstanceLegacy("legacy", stats.getDataType(), ColumnType.MEASURE);
        DataType dataType = DataType.getDataType(metadata.getType());
        if (dataType == DataTypes.BYTE || dataType == DataTypes.SHORT || dataType == DataTypes.INT || dataType == DataTypes.LONG) {
            ColumnPageCodec codec = DefaultEncodingFactory.selectCodecByAlgorithmForIntegral(stats, false, spec);
            if (codec instanceof AdaptiveIntegralCodec) {
                AdaptiveIntegralCodec adaptiveCodec = (AdaptiveIntegralCodec)codec;
                ColumnPageEncoderMeta meta = new ColumnPageEncoderMeta(spec, adaptiveCodec.getTargetDataType(), stats, compressor);
                meta.setFillCompleteVector(fullVectorFill);
                return codec.createDecoder(meta);
            }
            if (codec instanceof AdaptiveDeltaIntegralCodec) {
                AdaptiveDeltaIntegralCodec adaptiveCodec = (AdaptiveDeltaIntegralCodec)codec;
                ColumnPageEncoderMeta meta = new ColumnPageEncoderMeta(spec, adaptiveCodec.getTargetDataType(), stats, compressor);
                meta.setFillCompleteVector(fullVectorFill);
                return codec.createDecoder(meta);
            }
            if (codec instanceof DirectCompressCodec) {
                ColumnPageEncoderMeta meta = new ColumnPageEncoderMeta(spec, DataType.getDataType(metadata.getType()), stats, compressor);
                meta.setFillCompleteVector(fullVectorFill);
                return codec.createDecoder(meta);
            }
            throw new RuntimeException("internal error");
        }
        if (dataType == DataTypes.FLOAT || dataType == DataTypes.DOUBLE) {
            ColumnPageCodec codec = DefaultEncodingFactory.selectCodecByAlgorithmForFloating(stats, false, spec);
            if (codec instanceof AdaptiveFloatingCodec) {
                AdaptiveFloatingCodec adaptiveCodec = (AdaptiveFloatingCodec)codec;
                ColumnPageEncoderMeta meta = new ColumnPageEncoderMeta(spec, adaptiveCodec.getTargetDataType(), stats, compressor);
                meta.setFillCompleteVector(fullVectorFill);
                return codec.createDecoder(meta);
            }
            if (codec instanceof DirectCompressCodec) {
                ColumnPageEncoderMeta meta = new ColumnPageEncoderMeta(spec, DataType.getDataType(metadata.getType()), stats, compressor);
                meta.setFillCompleteVector(fullVectorFill);
                return codec.createDecoder(meta);
            }
            if (codec instanceof AdaptiveDeltaFloatingCodec) {
                AdaptiveDeltaFloatingCodec adaptiveCodec = (AdaptiveDeltaFloatingCodec)codec;
                ColumnPageEncoderMeta meta = new ColumnPageEncoderMeta(spec, adaptiveCodec.getTargetDataType(), stats, compressor);
                meta.setFillCompleteVector(fullVectorFill);
                return codec.createDecoder(meta);
            }
            throw new RuntimeException("internal error");
        }
        if (DataTypes.isDecimal(dataType) || dataType == DataTypes.BYTE_ARRAY) {
            ColumnPageEncoderMeta meta = new ColumnPageEncoderMeta(spec, stats.getDataType(), stats, compressor);
            meta.setFillCompleteVector(fullVectorFill);
            return new DirectCompressCodec(stats.getDataType()).createDecoder(meta);
        }
        throw new RuntimeException("unsupported data type: " + stats.getDataType());
    }
}

