/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.encoding.adaptive;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.carbondata.core.datastore.columnar.BlockIndexerStorage;
import org.apache.carbondata.core.datastore.columnar.ObjectArrayBlockIndexerStorage;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.ColumnPageValueConverter;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageCodec;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.format.DataChunk2;
import org.apache.carbondata.format.SortState;

public abstract class AdaptiveCodec
implements ColumnPageCodec {
    protected final SimpleStatsResult stats;
    protected final DataType targetDataType;
    protected final DataType srcDataType;
    protected boolean isInvertedIndex;
    protected BlockIndexerStorage<Object[]> indexStorage;
    protected ColumnPage encodedPage;

    protected AdaptiveCodec(DataType srcDataType, DataType targetDataType, SimpleStatsResult stats, boolean isInvertedIndex) {
        this.stats = stats;
        this.srcDataType = srcDataType;
        this.targetDataType = targetDataType;
        this.isInvertedIndex = isInvertedIndex;
    }

    public DataType getTargetDataType() {
        return this.targetDataType;
    }

    public Object[] getPageBasedOnDataType(ColumnPage input) {
        Object[] data;
        block8: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block7: {
                                    data = new Object[input.getActualRowCount()];
                                    if (this.srcDataType != DataTypes.BYTE && this.srcDataType != DataTypes.BOOLEAN) break block7;
                                    for (int i = 0; i < input.getActualRowCount(); ++i) {
                                        data[i] = input.getByte(i);
                                    }
                                    break block8;
                                }
                                if (this.srcDataType != DataTypes.SHORT) break block9;
                                for (int i = 0; i < input.getActualRowCount(); ++i) {
                                    data[i] = input.getShort(i);
                                }
                                break block8;
                            }
                            if (this.srcDataType != DataTypes.SHORT_INT) break block10;
                            for (int i = 0; i < input.getActualRowCount(); ++i) {
                                data[i] = input.getShortInt(i);
                            }
                            break block8;
                        }
                        if (this.srcDataType != DataTypes.INT) break block11;
                        for (int i = 0; i < input.getActualRowCount(); ++i) {
                            data[i] = input.getInt(i);
                        }
                        break block8;
                    }
                    if (this.srcDataType != DataTypes.LONG) break block12;
                    for (int i = 0; i < input.getActualRowCount(); ++i) {
                        data[i] = input.getLong(i);
                    }
                    break block8;
                }
                if (this.srcDataType != DataTypes.FLOAT) break block13;
                for (int i = 0; i < input.getActualRowCount(); ++i) {
                    data[i] = Float.valueOf(input.getFloat(i));
                }
                break block8;
            }
            if (this.srcDataType != DataTypes.DOUBLE) break block8;
            for (int i = 0; i < input.getActualRowCount(); ++i) {
                data[i] = input.getDouble(i);
            }
        }
        return data;
    }

    public void putDataToPage(ColumnPage page, Object[] dataPage) {
        block8: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block7: {
                                    if (this.srcDataType != DataTypes.BYTE && this.srcDataType != DataTypes.BOOLEAN) break block7;
                                    for (int i = 0; i < dataPage.length; ++i) {
                                        page.putByte(i, (Byte)dataPage[i]);
                                    }
                                    break block8;
                                }
                                if (this.srcDataType != DataTypes.SHORT) break block9;
                                for (int i = 0; i < dataPage.length; ++i) {
                                    page.putShort(i, (Short)dataPage[i]);
                                }
                                break block8;
                            }
                            if (this.srcDataType != DataTypes.SHORT_INT) break block10;
                            for (int i = 0; i < dataPage.length; ++i) {
                                page.putShortInt(i, (Integer)dataPage[i]);
                            }
                            break block8;
                        }
                        if (this.srcDataType != DataTypes.INT) break block11;
                        for (int i = 0; i < dataPage.length; ++i) {
                            page.putInt(i, (Integer)dataPage[i]);
                        }
                        break block8;
                    }
                    if (this.srcDataType != DataTypes.LONG) break block12;
                    for (int i = 0; i < dataPage.length; ++i) {
                        page.putLong(i, (Long)dataPage[i]);
                    }
                    break block8;
                }
                if (this.srcDataType != DataTypes.DOUBLE) break block13;
                for (int i = 0; i < dataPage.length; ++i) {
                    page.putDouble(i, (Double)dataPage[i]);
                }
                break block8;
            }
            if (this.srcDataType != DataTypes.FLOAT) break block8;
            for (int i = 0; i < dataPage.length; ++i) {
                page.putFloat(i, ((Float)dataPage[i]).floatValue());
            }
        }
    }

    public ByteBuffer writeInvertedIndexIfRequired(ByteBuffer result) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        if (null != this.indexStorage) {
            if (result.isDirect()) {
                for (int i = result.position(); i < result.limit(); ++i) {
                    out.writeByte(result.get(i));
                }
            } else {
                out.write(result.array(), result.position(), result.limit());
            }
            if (this.indexStorage.getRowIdPageLengthInBytes() > 0) {
                short[] rowIdPage;
                out.writeInt(this.indexStorage.getRowIdPageLengthInBytes());
                for (short rowId : rowIdPage = this.indexStorage.getRowIdPage()) {
                    out.writeShort(rowId);
                }
                if (this.indexStorage.getRowIdRlePageLengthInBytes() > 0) {
                    short[] rowIdRlePage;
                    for (short rowIdRle : rowIdRlePage = this.indexStorage.getRowIdRlePage()) {
                        out.writeShort(rowIdRle);
                    }
                }
            }
        }
        byte[] bytes = stream.toByteArray();
        stream.close();
        return ByteBuffer.wrap(bytes);
    }

    public void fillLegacyFieldsIfRequired(DataChunk2 dataChunk, ByteBuffer result) {
        if (null != this.indexStorage) {
            SortState sort = this.indexStorage.getRowIdPageLengthInBytes() > 0 ? SortState.SORT_EXPLICIT : SortState.SORT_NATIVE;
            dataChunk.setSort_state(sort);
            if (this.indexStorage.getRowIdPageLengthInBytes() > 0) {
                int rowIdPageLength = 4 + this.indexStorage.getRowIdPageLengthInBytes() + this.indexStorage.getRowIdRlePageLengthInBytes();
                dataChunk.setRowid_page_length(rowIdPageLength);
            }
        } else {
            dataChunk.setRowid_page_length(0);
        }
        if (null != result) {
            dataChunk.setData_page_length(result.limit() - result.position());
        }
    }

    public ColumnPage getSortedColumnPageIfRequired(ColumnPage input) {
        if (null != this.indexStorage) {
            Object[] dataPage = this.indexStorage.getDataPage();
            ColumnPageEncoderMeta columnPageEncoderMeta = new ColumnPageEncoderMeta(input.getColumnSpec(), input.getDataType(), input.getColumnPageEncoderMeta().getCompressorName());
            ColumnPage columnPage = ColumnPage.newPage(columnPageEncoderMeta, input.getPageSize());
            this.putDataToPage(columnPage, dataPage);
            return columnPage;
        }
        return input;
    }

    public ByteBuffer encodeAndCompressPage(ColumnPage input, ColumnPageValueConverter converter, Compressor compressor) throws IOException {
        this.encodedPage = ColumnPage.newPage(new ColumnPageEncoderMeta(input.getColumnPageEncoderMeta().getColumnSpec(), this.targetDataType, input.getColumnPageEncoderMeta().getCompressorName()), input.getPageSize());
        if (this.isInvertedIndex) {
            this.indexStorage = new ObjectArrayBlockIndexerStorage(this.getPageBasedOnDataType(input), input.getDataType(), this.isInvertedIndex);
        }
        ColumnPage columnPage = this.getSortedColumnPageIfRequired(input);
        columnPage.convertValue(converter);
        return this.encodedPage.compress(compressor);
    }

    public String toString() {
        return String.format("%s[src type: %s, target type: %s, stats(%s)]", this.getClass().getName(), this.srcDataType, this.targetDataType, this.stats);
    }

    protected String debugInfo() {
        return this.toString();
    }
}

