/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.encoding.adaptive;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.ColumnPageValueConverter;
import org.apache.carbondata.core.datastore.page.LazyColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageCodec;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageDecoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.datastore.page.encoding.adaptive.AdaptiveCodec;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ColumnarVectorWrapperDirectFactory;
import org.apache.carbondata.core.scan.result.vector.impl.directread.SequentialFill;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.format.DataChunk2;
import org.apache.carbondata.format.Encoding;

public class AdaptiveDeltaFloatingCodec
extends AdaptiveCodec {
    private Double factor;
    private long max;
    private ColumnPageValueConverter converter = new ColumnPageValueConverter(){

        @Override
        public void encode(int rowId, byte value) {
            throw new RuntimeException("internal error: " + AdaptiveDeltaFloatingCodec.this.debugInfo());
        }

        @Override
        public void encode(int rowId, short value) {
            throw new RuntimeException("internal error: " + AdaptiveDeltaFloatingCodec.this.debugInfo());
        }

        @Override
        public void encode(int rowId, int value) {
            throw new RuntimeException("internal error: " + AdaptiveDeltaFloatingCodec.this.debugInfo());
        }

        @Override
        public void encode(int rowId, long value) {
            throw new RuntimeException("internal error: " + AdaptiveDeltaFloatingCodec.this.debugInfo());
        }

        @Override
        public void encode(int rowId, float value) {
            if (AdaptiveDeltaFloatingCodec.this.targetDataType.equals(DataTypes.BYTE)) {
                AdaptiveDeltaFloatingCodec.this.encodedPage.putByte(rowId, (byte)((double)AdaptiveDeltaFloatingCodec.this.max - (double)value * AdaptiveDeltaFloatingCodec.this.factor));
            } else if (AdaptiveDeltaFloatingCodec.this.targetDataType.equals(DataTypes.SHORT)) {
                AdaptiveDeltaFloatingCodec.this.encodedPage.putShort(rowId, (short)((double)AdaptiveDeltaFloatingCodec.this.max - (double)value * AdaptiveDeltaFloatingCodec.this.factor));
            } else if (AdaptiveDeltaFloatingCodec.this.targetDataType.equals(DataTypes.SHORT_INT)) {
                AdaptiveDeltaFloatingCodec.this.encodedPage.putShortInt(rowId, (int)((double)AdaptiveDeltaFloatingCodec.this.max - (double)value * AdaptiveDeltaFloatingCodec.this.factor));
            } else if (AdaptiveDeltaFloatingCodec.this.targetDataType.equals(DataTypes.INT)) {
                AdaptiveDeltaFloatingCodec.this.encodedPage.putInt(rowId, (int)((double)AdaptiveDeltaFloatingCodec.this.max - (double)value * AdaptiveDeltaFloatingCodec.this.factor));
            } else {
                throw new RuntimeException("internal error: " + AdaptiveDeltaFloatingCodec.this.debugInfo());
            }
        }

        @Override
        public void encode(int rowId, double value) {
            if (AdaptiveDeltaFloatingCodec.this.targetDataType.equals(DataTypes.BYTE)) {
                AdaptiveDeltaFloatingCodec.this.encodedPage.putByte(rowId, (byte)(AdaptiveDeltaFloatingCodec.this.max - Math.round(value * AdaptiveDeltaFloatingCodec.this.factor)));
            } else if (AdaptiveDeltaFloatingCodec.this.targetDataType.equals(DataTypes.SHORT)) {
                AdaptiveDeltaFloatingCodec.this.encodedPage.putShort(rowId, (short)(AdaptiveDeltaFloatingCodec.this.max - Math.round(value * AdaptiveDeltaFloatingCodec.this.factor)));
            } else if (AdaptiveDeltaFloatingCodec.this.targetDataType.equals(DataTypes.SHORT_INT)) {
                AdaptiveDeltaFloatingCodec.this.encodedPage.putShortInt(rowId, (int)(AdaptiveDeltaFloatingCodec.this.max - Math.round(value * AdaptiveDeltaFloatingCodec.this.factor)));
            } else if (AdaptiveDeltaFloatingCodec.this.targetDataType.equals(DataTypes.INT)) {
                AdaptiveDeltaFloatingCodec.this.encodedPage.putInt(rowId, (int)(AdaptiveDeltaFloatingCodec.this.max - Math.round(value * AdaptiveDeltaFloatingCodec.this.factor)));
            } else if (AdaptiveDeltaFloatingCodec.this.targetDataType.equals(DataTypes.DOUBLE)) {
                AdaptiveDeltaFloatingCodec.this.encodedPage.putDouble(rowId, value);
            } else {
                throw new RuntimeException("internal error: " + AdaptiveDeltaFloatingCodec.this.debugInfo());
            }
        }

        @Override
        public long decodeLong(byte value) {
            throw new RuntimeException("internal error: " + AdaptiveDeltaFloatingCodec.this.debugInfo());
        }

        @Override
        public long decodeLong(short value) {
            throw new RuntimeException("internal error: " + AdaptiveDeltaFloatingCodec.this.debugInfo());
        }

        @Override
        public long decodeLong(int value) {
            throw new RuntimeException("internal error: " + AdaptiveDeltaFloatingCodec.this.debugInfo());
        }

        @Override
        public double decodeDouble(byte value) {
            return (double)(AdaptiveDeltaFloatingCodec.this.max - (long)value) / AdaptiveDeltaFloatingCodec.this.factor;
        }

        @Override
        public double decodeDouble(short value) {
            return (double)(AdaptiveDeltaFloatingCodec.this.max - (long)value) / AdaptiveDeltaFloatingCodec.this.factor;
        }

        @Override
        public double decodeDouble(int value) {
            return (double)(AdaptiveDeltaFloatingCodec.this.max - (long)value) / AdaptiveDeltaFloatingCodec.this.factor;
        }

        @Override
        public double decodeDouble(long value) {
            return (double)(AdaptiveDeltaFloatingCodec.this.max - value) / AdaptiveDeltaFloatingCodec.this.factor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void decodeAndFillVector(byte[] pageData, ColumnVectorInfo vectorInfo, BitSet nullBits, DataType pageDataType, int pageSize) {
            int i;
            CarbonColumnVector vector = vectorInfo.vector;
            BitSet deletedRows = vectorInfo.deletedRows;
            DataType vectorDataType = vector.getType();
            vector = ColumnarVectorWrapperDirectFactory.getDirectVectorWrapperFactory(vector, null, nullBits, deletedRows, true, false);
            int rowId = 0;
            if (vectorDataType == DataTypes.FLOAT) {
                int i2;
                int size;
                float floatFactor = AdaptiveDeltaFloatingCodec.this.factor.floatValue();
                if (pageDataType == DataTypes.BOOLEAN || pageDataType == DataTypes.BYTE) {
                    for (i = 0; i < pageSize; ++i) {
                        vector.putFloat(i, (float)(AdaptiveDeltaFloatingCodec.this.max - (long)pageData[i]) / floatFactor);
                    }
                } else if (pageDataType == DataTypes.SHORT) {
                    size = pageSize * DataTypes.SHORT.getSizeInBytes();
                    for (i2 = 0; i2 < size; i2 += DataTypes.SHORT.getSizeInBytes()) {
                        vector.putFloat(rowId++, (float)(AdaptiveDeltaFloatingCodec.this.max - (long)ByteUtil.toShortLittleEndian(pageData, i2)) / floatFactor);
                    }
                } else if (pageDataType == DataTypes.SHORT_INT) {
                    size = pageSize * DataTypes.SHORT_INT.getSizeInBytes();
                    for (i2 = 0; i2 < size; i2 += DataTypes.SHORT_INT.getSizeInBytes()) {
                        int shortInt = ByteUtil.valueOf3Bytes(pageData, i2);
                        vector.putFloat(rowId++, (float)(AdaptiveDeltaFloatingCodec.this.max - (long)shortInt) / floatFactor);
                    }
                } else {
                    if (pageDataType != DataTypes.INT) throw new RuntimeException("internal error: " + this.toString());
                    size = pageSize * DataTypes.INT.getSizeInBytes();
                    for (i2 = 0; i2 < size; i2 += DataTypes.INT.getSizeInBytes()) {
                        vector.putFloat(rowId++, (float)(AdaptiveDeltaFloatingCodec.this.max - (long)ByteUtil.toIntLittleEndian(pageData, i2)) / floatFactor);
                    }
                }
            } else if (pageDataType == DataTypes.BOOLEAN || pageDataType == DataTypes.BYTE) {
                for (int i3 = 0; i3 < pageSize; ++i3) {
                    vector.putDouble(rowId++, (double)(AdaptiveDeltaFloatingCodec.this.max - (long)pageData[i3]) / AdaptiveDeltaFloatingCodec.this.factor);
                }
            } else if (pageDataType == DataTypes.SHORT) {
                int size = pageSize * DataTypes.SHORT.getSizeInBytes();
                for (i = 0; i < size; i += DataTypes.SHORT.getSizeInBytes()) {
                    vector.putDouble(rowId++, (double)(AdaptiveDeltaFloatingCodec.this.max - (long)ByteUtil.toShortLittleEndian(pageData, i)) / AdaptiveDeltaFloatingCodec.this.factor);
                }
            } else if (pageDataType == DataTypes.SHORT_INT) {
                int size = pageSize * DataTypes.SHORT_INT.getSizeInBytes();
                for (i = 0; i < size; i += DataTypes.SHORT_INT.getSizeInBytes()) {
                    int shortInt = ByteUtil.valueOf3Bytes(pageData, i);
                    vector.putDouble(rowId++, (double)(AdaptiveDeltaFloatingCodec.this.max - (long)shortInt) / AdaptiveDeltaFloatingCodec.this.factor);
                }
            } else if (pageDataType == DataTypes.INT) {
                int size = pageSize * DataTypes.INT.getSizeInBytes();
                for (i = 0; i < size; i += DataTypes.INT.getSizeInBytes()) {
                    vector.putDouble(rowId++, (double)(AdaptiveDeltaFloatingCodec.this.max - (long)ByteUtil.toIntLittleEndian(pageData, i)) / AdaptiveDeltaFloatingCodec.this.factor);
                }
            } else {
                if (pageDataType != DataTypes.LONG) throw new RuntimeException("Unsupported datatype : " + pageDataType);
                int size = pageSize * DataTypes.LONG.getSizeInBytes();
                for (i = 0; i < size; i += DataTypes.LONG.getSizeInBytes()) {
                    vector.putDouble(rowId++, (double)(AdaptiveDeltaFloatingCodec.this.max - ByteUtil.toLongLittleEndian(pageData, i)) / AdaptiveDeltaFloatingCodec.this.factor);
                }
            }
            if (deletedRows != null && !deletedRows.isEmpty() || vectorInfo.vector instanceof SequentialFill) return;
            int i4 = nullBits.nextSetBit(0);
            while (i4 >= 0) {
                vector.putNull(i4);
                i4 = nullBits.nextSetBit(i4 + 1);
            }
        }

        @Override
        public double decodeDouble(float value) {
            throw new RuntimeException("internal error: " + AdaptiveDeltaFloatingCodec.this.debugInfo());
        }

        @Override
        public double decodeDouble(double value) {
            throw new RuntimeException("internal error: " + AdaptiveDeltaFloatingCodec.this.debugInfo());
        }
    };

    public static ColumnPageCodec newInstance(DataType srcDataType, DataType targetDataType, SimpleStatsResult stats, boolean isInvertedIndex) {
        return new AdaptiveDeltaFloatingCodec(srcDataType, targetDataType, stats, isInvertedIndex);
    }

    public AdaptiveDeltaFloatingCodec(DataType srcDataType, DataType targetDataType, SimpleStatsResult stats, boolean isInvertedIndex) {
        super(srcDataType, targetDataType, stats, isInvertedIndex);
        this.factor = Math.pow(10.0, stats.getDecimalCount());
        this.max = srcDataType == DataTypes.FLOAT ? (long)((float)((long)Math.pow(10.0, stats.getDecimalCount())) * ((Float)stats.getMax()).floatValue()) : (long)((double)((long)Math.pow(10.0, stats.getDecimalCount())) * (Double)stats.getMax());
    }

    @Override
    public String getName() {
        return "AdaptiveDeltaFloatingCodec";
    }

    @Override
    public ColumnPageEncoder createEncoder(Map<String, String> parameter) {
        return new ColumnPageEncoder(){
            ByteBuffer result = null;

            @Override
            protected ByteBuffer encodeData(ColumnPage input) throws IOException {
                if (AdaptiveDeltaFloatingCodec.this.encodedPage != null) {
                    throw new IllegalStateException("already encoded");
                }
                Compressor compressor = CompressorFactory.getInstance().getCompressor(input.getColumnCompressorName());
                this.result = AdaptiveDeltaFloatingCodec.this.encodeAndCompressPage(input, AdaptiveDeltaFloatingCodec.this.converter, compressor);
                ByteBuffer bytes = AdaptiveDeltaFloatingCodec.this.writeInvertedIndexIfRequired(this.result);
                AdaptiveDeltaFloatingCodec.this.encodedPage.freeMemory();
                if (bytes.limit() != 0) {
                    return bytes;
                }
                return this.result;
            }

            @Override
            protected List<Encoding> getEncodingList() {
                ArrayList<Encoding> encodings = new ArrayList<Encoding>();
                encodings.add(Encoding.ADAPTIVE_DELTA_FLOATING);
                if (null != AdaptiveDeltaFloatingCodec.this.indexStorage && AdaptiveDeltaFloatingCodec.this.indexStorage.getRowIdPageLengthInBytes() > 0) {
                    encodings.add(Encoding.INVERTED_INDEX);
                }
                return encodings;
            }

            @Override
            protected ColumnPageEncoderMeta getEncoderMeta(ColumnPage inputPage) {
                return new ColumnPageEncoderMeta(inputPage.getColumnSpec(), AdaptiveDeltaFloatingCodec.this.targetDataType, AdaptiveDeltaFloatingCodec.this.stats, inputPage.getColumnCompressorName());
            }

            @Override
            protected void fillLegacyFields(DataChunk2 dataChunk) {
                AdaptiveDeltaFloatingCodec.this.fillLegacyFieldsIfRequired(dataChunk, this.result);
            }
        };
    }

    @Override
    public ColumnPageDecoder createDecoder(final ColumnPageEncoderMeta meta) {
        return new ColumnPageDecoder(){

            @Override
            public ColumnPage decode(byte[] input, int offset, int length) {
                ColumnPage page = ColumnPage.decompress(meta, input, offset, length, false, false);
                return LazyColumnPage.newPage(page, AdaptiveDeltaFloatingCodec.this.converter);
            }

            @Override
            public void decodeAndFillVector(byte[] input, int offset, int length, ColumnVectorInfo vectorInfo, BitSet nullBits, boolean isLVEncoded, int pageSize, ReusableDataBuffer reusableDataBuffer) {
                byte[] unCompressData;
                Compressor compressor = CompressorFactory.getInstance().getCompressor(meta.getCompressorName());
                if (null != reusableDataBuffer && compressor.supportReusableBuffer()) {
                    int uncompressedLength = compressor.unCompressedLength(input, offset, length);
                    unCompressData = reusableDataBuffer.getDataBuffer(uncompressedLength);
                    compressor.rawUncompress(input, offset, length, unCompressData);
                } else {
                    unCompressData = compressor.unCompressByte(input, offset, length);
                }
                AdaptiveDeltaFloatingCodec.this.converter.decodeAndFillVector(unCompressData, vectorInfo, nullBits, meta.getStoreDataType(), pageSize);
            }

            @Override
            public ColumnPage decode(byte[] input, int offset, int length, boolean isLVEncoded) {
                return this.decode(input, offset, length);
            }
        };
    }
}

