/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.encoding.adaptive;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.ColumnPageValueConverter;
import org.apache.carbondata.core.datastore.page.LazyColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageDecoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.datastore.page.encoding.adaptive.AdaptiveCodec;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalConverterFactory;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ColumnarVectorWrapperDirectFactory;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ConvertableVector;
import org.apache.carbondata.core.scan.result.vector.impl.directread.SequentialFill;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.format.DataChunk2;
import org.apache.carbondata.format.Encoding;

public class AdaptiveDeltaIntegralCodec
extends AdaptiveCodec {
    private long max;
    private ColumnPageValueConverter converter = new ColumnPageValueConverter(){

        @Override
        public void encode(int rowId, byte value) {
            if (AdaptiveDeltaIntegralCodec.this.targetDataType != DataTypes.BYTE) {
                throw new RuntimeException("internal error");
            }
            AdaptiveDeltaIntegralCodec.this.encodedPage.putByte(rowId, (byte)(AdaptiveDeltaIntegralCodec.this.max - (long)value));
        }

        @Override
        public void encode(int rowId, short value) {
            if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.BYTE) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putByte(rowId, (byte)(AdaptiveDeltaIntegralCodec.this.max - (long)value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.SHORT) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putShort(rowId, (short)(AdaptiveDeltaIntegralCodec.this.max - (long)value));
            } else {
                throw new RuntimeException("internal error");
            }
        }

        @Override
        public void encode(int rowId, int value) {
            if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.BYTE) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putByte(rowId, (byte)(AdaptiveDeltaIntegralCodec.this.max - (long)value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.SHORT) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putShort(rowId, (short)(AdaptiveDeltaIntegralCodec.this.max - (long)value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.SHORT_INT) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putShortInt(rowId, (int)(AdaptiveDeltaIntegralCodec.this.max - (long)value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.INT) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putInt(rowId, (int)(AdaptiveDeltaIntegralCodec.this.max - (long)value));
            } else {
                throw new RuntimeException("internal error");
            }
        }

        @Override
        public void encode(int rowId, long value) {
            if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.BYTE) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putByte(rowId, (byte)(AdaptiveDeltaIntegralCodec.this.max - value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.SHORT) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putShort(rowId, (short)(AdaptiveDeltaIntegralCodec.this.max - value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.SHORT_INT) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putShortInt(rowId, (int)(AdaptiveDeltaIntegralCodec.this.max - value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.INT) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putInt(rowId, (int)(AdaptiveDeltaIntegralCodec.this.max - value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.LONG) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putLong(rowId, AdaptiveDeltaIntegralCodec.this.max - value);
            } else {
                throw new RuntimeException("internal error");
            }
        }

        @Override
        public void encode(int rowId, float value) {
            if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.BYTE) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putByte(rowId, (byte)((float)AdaptiveDeltaIntegralCodec.this.max - value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.SHORT) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putShort(rowId, (short)((float)AdaptiveDeltaIntegralCodec.this.max - value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.SHORT_INT) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putShortInt(rowId, (int)((float)AdaptiveDeltaIntegralCodec.this.max - value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.INT) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putInt(rowId, (int)((float)AdaptiveDeltaIntegralCodec.this.max - value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.LONG) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putLong(rowId, (long)((float)AdaptiveDeltaIntegralCodec.this.max - value));
            } else {
                throw new RuntimeException("internal error");
            }
        }

        @Override
        public void encode(int rowId, double value) {
            if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.BYTE) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putByte(rowId, (byte)((double)AdaptiveDeltaIntegralCodec.this.max - value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.SHORT) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putShort(rowId, (short)((double)AdaptiveDeltaIntegralCodec.this.max - value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.SHORT_INT) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putShortInt(rowId, (int)((double)AdaptiveDeltaIntegralCodec.this.max - value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.INT) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putInt(rowId, (int)((double)AdaptiveDeltaIntegralCodec.this.max - value));
            } else if (AdaptiveDeltaIntegralCodec.this.targetDataType == DataTypes.LONG) {
                AdaptiveDeltaIntegralCodec.this.encodedPage.putLong(rowId, (long)((double)AdaptiveDeltaIntegralCodec.this.max - value));
            } else {
                throw new RuntimeException("internal error");
            }
        }

        @Override
        public long decodeLong(byte value) {
            return AdaptiveDeltaIntegralCodec.this.max - (long)value;
        }

        @Override
        public long decodeLong(short value) {
            return AdaptiveDeltaIntegralCodec.this.max - (long)value;
        }

        @Override
        public long decodeLong(int value) {
            return AdaptiveDeltaIntegralCodec.this.max - (long)value;
        }

        @Override
        public double decodeDouble(byte value) {
            return AdaptiveDeltaIntegralCodec.this.max - (long)value;
        }

        @Override
        public double decodeDouble(short value) {
            return AdaptiveDeltaIntegralCodec.this.max - (long)value;
        }

        @Override
        public double decodeDouble(int value) {
            return AdaptiveDeltaIntegralCodec.this.max - (long)value;
        }

        @Override
        public double decodeDouble(long value) {
            return AdaptiveDeltaIntegralCodec.this.max - value;
        }

        @Override
        public double decodeDouble(float value) {
            throw new RuntimeException("internal error");
        }

        @Override
        public double decodeDouble(double value) {
            throw new RuntimeException("internal error");
        }

        @Override
        public void decodeAndFillVector(byte[] pageData, ColumnVectorInfo vectorInfo, BitSet nullBits, DataType pageDataType, int pageSize) {
            CarbonColumnVector vector = vectorInfo.vector;
            DataType vectorDataType = vector.getType();
            BitSet deletedRows = vectorInfo.deletedRows;
            vector = ColumnarVectorWrapperDirectFactory.getDirectVectorWrapperFactory(vector, vectorInfo.invertedIndex, nullBits, deletedRows, true, false);
            this.fillVector(pageData, vector, vectorDataType, pageDataType, pageSize, vectorInfo);
            if ((deletedRows == null || deletedRows.isEmpty()) && !(vectorInfo.vector instanceof SequentialFill)) {
                int i = nullBits.nextSetBit(0);
                while (i >= 0) {
                    vector.putNull(i);
                    i = nullBits.nextSetBit(i + 1);
                }
            }
            if (vector instanceof ConvertableVector) {
                ((ConvertableVector)((Object)vector)).convert();
            }
        }

        private void fillVector(byte[] pageData, CarbonColumnVector vector, DataType vectorDataType, DataType pageDataType, int pageSize, ColumnVectorInfo vectorInfo) {
            int newScale = 0;
            if (vectorInfo.measure != null) {
                newScale = vectorInfo.measure.getMeasure().getScale();
            }
            int rowId = 0;
            if (pageDataType == DataTypes.BOOLEAN || pageDataType == DataTypes.BYTE) {
                if (vectorDataType == DataTypes.SHORT) {
                    for (int i = 0; i < pageSize; ++i) {
                        vector.putShort(i, (short)(AdaptiveDeltaIntegralCodec.this.max - (long)pageData[i]));
                    }
                } else if (vectorDataType == DataTypes.INT) {
                    for (int i = 0; i < pageSize; ++i) {
                        vector.putInt(i, (int)(AdaptiveDeltaIntegralCodec.this.max - (long)pageData[i]));
                    }
                } else if (vectorDataType == DataTypes.LONG) {
                    for (int i = 0; i < pageSize; ++i) {
                        vector.putLong(i, AdaptiveDeltaIntegralCodec.this.max - (long)pageData[i]);
                    }
                } else if (vectorDataType == DataTypes.TIMESTAMP) {
                    for (int i = 0; i < pageSize; ++i) {
                        vector.putLong(i, (AdaptiveDeltaIntegralCodec.this.max - (long)pageData[i]) * 1000L);
                    }
                } else if (vectorDataType == DataTypes.BOOLEAN) {
                    for (int i = 0; i < pageSize; ++i) {
                        vector.putByte(i, (byte)(AdaptiveDeltaIntegralCodec.this.max - (long)pageData[i]));
                    }
                } else if (DataTypes.isDecimal(vectorDataType)) {
                    DecimalConverterFactory.DecimalConverter decimalConverter = vectorInfo.decimalConverter;
                    int precision = vectorInfo.measure.getMeasure().getPrecision();
                    for (int i = 0; i < pageSize; ++i) {
                        BigDecimal decimal = decimalConverter.getDecimal(AdaptiveDeltaIntegralCodec.this.max - (long)pageData[i]);
                        if (decimal.scale() < newScale) {
                            decimal = decimal.setScale(newScale);
                        }
                        vector.putDecimal(i, decimal, precision);
                    }
                } else if (vectorDataType == DataTypes.FLOAT) {
                    for (int i = 0; i < pageSize; ++i) {
                        vector.putFloat(i, (int)(AdaptiveDeltaIntegralCodec.this.max - (long)pageData[i]));
                    }
                } else {
                    for (int i = 0; i < pageSize; ++i) {
                        vector.putDouble(i, AdaptiveDeltaIntegralCodec.this.max - (long)pageData[i]);
                    }
                }
            } else if (pageDataType == DataTypes.SHORT) {
                int size = pageSize * DataTypes.SHORT.getSizeInBytes();
                if (vectorDataType == DataTypes.SHORT) {
                    for (int i = 0; i < size; i += DataTypes.SHORT.getSizeInBytes()) {
                        vector.putShort(rowId++, (short)(AdaptiveDeltaIntegralCodec.this.max - (long)ByteUtil.toShortLittleEndian(pageData, i)));
                    }
                } else if (vectorDataType == DataTypes.INT) {
                    for (int i = 0; i < size; i += DataTypes.SHORT.getSizeInBytes()) {
                        vector.putInt(rowId++, (int)(AdaptiveDeltaIntegralCodec.this.max - (long)ByteUtil.toShortLittleEndian(pageData, i)));
                    }
                } else if (vectorDataType == DataTypes.LONG) {
                    for (int i = 0; i < size; i += DataTypes.SHORT.getSizeInBytes()) {
                        vector.putLong(rowId++, AdaptiveDeltaIntegralCodec.this.max - (long)ByteUtil.toShortLittleEndian(pageData, i));
                    }
                } else if (vectorDataType == DataTypes.TIMESTAMP) {
                    for (int i = 0; i < size; i += DataTypes.SHORT.getSizeInBytes()) {
                        vector.putLong(rowId++, (AdaptiveDeltaIntegralCodec.this.max - (long)ByteUtil.toShortLittleEndian(pageData, i)) * 1000L);
                    }
                } else if (DataTypes.isDecimal(vectorDataType)) {
                    DecimalConverterFactory.DecimalConverter decimalConverter = vectorInfo.decimalConverter;
                    int precision = vectorInfo.measure.getMeasure().getPrecision();
                    for (int i = 0; i < size; i += DataTypes.SHORT.getSizeInBytes()) {
                        BigDecimal decimal = decimalConverter.getDecimal(AdaptiveDeltaIntegralCodec.this.max - (long)ByteUtil.toShortLittleEndian(pageData, i));
                        if (decimal.scale() < newScale) {
                            decimal = decimal.setScale(newScale);
                        }
                        vector.putDecimal(rowId++, decimal, precision);
                    }
                } else if (vectorDataType == DataTypes.FLOAT) {
                    for (int i = 0; i < size; i += DataTypes.SHORT.getSizeInBytes()) {
                        vector.putFloat(rowId++, (int)(AdaptiveDeltaIntegralCodec.this.max - (long)ByteUtil.toShortLittleEndian(pageData, i)));
                    }
                } else {
                    for (int i = 0; i < size; i += DataTypes.SHORT.getSizeInBytes()) {
                        vector.putDouble(rowId++, AdaptiveDeltaIntegralCodec.this.max - (long)ByteUtil.toShortLittleEndian(pageData, i));
                    }
                }
            } else if (pageDataType == DataTypes.SHORT_INT) {
                int size = pageSize * DataTypes.SHORT_INT.getSizeInBytes();
                if (vectorDataType == DataTypes.INT) {
                    for (int i = 0; i < size; i += DataTypes.SHORT_INT.getSizeInBytes()) {
                        int shortInt = ByteUtil.valueOf3Bytes(pageData, i);
                        vector.putInt(rowId++, (int)(AdaptiveDeltaIntegralCodec.this.max - (long)shortInt));
                    }
                } else if (vectorDataType == DataTypes.LONG) {
                    for (int i = 0; i < size; i += DataTypes.SHORT_INT.getSizeInBytes()) {
                        int shortInt = ByteUtil.valueOf3Bytes(pageData, i);
                        vector.putLong(rowId++, AdaptiveDeltaIntegralCodec.this.max - (long)shortInt);
                    }
                } else if (vectorDataType == DataTypes.TIMESTAMP) {
                    for (int i = 0; i < size; i += DataTypes.SHORT_INT.getSizeInBytes()) {
                        vector.putLong(rowId++, (AdaptiveDeltaIntegralCodec.this.max - (long)ByteUtil.valueOf3Bytes(pageData, i)) * 1000L);
                    }
                } else if (DataTypes.isDecimal(vectorDataType)) {
                    DecimalConverterFactory.DecimalConverter decimalConverter = vectorInfo.decimalConverter;
                    int precision = vectorInfo.measure.getMeasure().getPrecision();
                    for (int i = 0; i < pageSize; ++i) {
                        int shortInt = ByteUtil.valueOf3Bytes(pageData, i * 3);
                        BigDecimal decimal = decimalConverter.getDecimal(AdaptiveDeltaIntegralCodec.this.max - (long)shortInt);
                        if (decimal.scale() < newScale) {
                            decimal = decimal.setScale(newScale);
                        }
                        vector.putDecimal(i, decimal, precision);
                    }
                } else if (vectorDataType == DataTypes.FLOAT) {
                    for (int i = 0; i < size; i += DataTypes.SHORT_INT.getSizeInBytes()) {
                        int shortInt = ByteUtil.valueOf3Bytes(pageData, i);
                        vector.putFloat(rowId++, (int)(AdaptiveDeltaIntegralCodec.this.max - (long)shortInt));
                    }
                } else {
                    for (int i = 0; i < size; i += DataTypes.SHORT_INT.getSizeInBytes()) {
                        int shortInt = ByteUtil.valueOf3Bytes(pageData, i);
                        vector.putDouble(rowId++, AdaptiveDeltaIntegralCodec.this.max - (long)shortInt);
                    }
                }
            } else if (pageDataType == DataTypes.INT) {
                int size = pageSize * DataTypes.INT.getSizeInBytes();
                if (vectorDataType == DataTypes.INT) {
                    for (int i = 0; i < size; i += DataTypes.INT.getSizeInBytes()) {
                        vector.putInt(rowId++, (int)(AdaptiveDeltaIntegralCodec.this.max - (long)ByteUtil.toIntLittleEndian(pageData, i)));
                    }
                } else if (vectorDataType == DataTypes.LONG) {
                    for (int i = 0; i < size; i += DataTypes.INT.getSizeInBytes()) {
                        vector.putLong(rowId++, AdaptiveDeltaIntegralCodec.this.max - (long)ByteUtil.toIntLittleEndian(pageData, i));
                    }
                } else if (vectorDataType == DataTypes.TIMESTAMP) {
                    for (int i = 0; i < size; i += DataTypes.INT.getSizeInBytes()) {
                        vector.putLong(rowId++, (AdaptiveDeltaIntegralCodec.this.max - (long)ByteUtil.toIntLittleEndian(pageData, i)) * 1000L);
                    }
                } else if (DataTypes.isDecimal(vectorDataType)) {
                    DecimalConverterFactory.DecimalConverter decimalConverter = vectorInfo.decimalConverter;
                    int precision = vectorInfo.measure.getMeasure().getPrecision();
                    for (int i = 0; i < size; i += DataTypes.INT.getSizeInBytes()) {
                        BigDecimal decimal = decimalConverter.getDecimal(AdaptiveDeltaIntegralCodec.this.max - (long)ByteUtil.toIntLittleEndian(pageData, i));
                        if (decimal.scale() < newScale) {
                            decimal = decimal.setScale(newScale);
                        }
                        vector.putDecimal(rowId++, decimal, precision);
                    }
                } else {
                    for (int i = 0; i < size; i += DataTypes.INT.getSizeInBytes()) {
                        vector.putDouble(rowId++, AdaptiveDeltaIntegralCodec.this.max - (long)ByteUtil.toIntLittleEndian(pageData, i));
                    }
                }
            } else if (pageDataType == DataTypes.LONG) {
                int size = pageSize * DataTypes.LONG.getSizeInBytes();
                if (vectorDataType == DataTypes.LONG) {
                    for (int i = 0; i < size; i += DataTypes.LONG.getSizeInBytes()) {
                        vector.putLong(rowId++, AdaptiveDeltaIntegralCodec.this.max - ByteUtil.toLongLittleEndian(pageData, i));
                    }
                } else if (vectorDataType == DataTypes.TIMESTAMP) {
                    for (int i = 0; i < size; i += DataTypes.LONG.getSizeInBytes()) {
                        vector.putLong(rowId++, (AdaptiveDeltaIntegralCodec.this.max - ByteUtil.toLongLittleEndian(pageData, i)) * 1000L);
                    }
                } else if (DataTypes.isDecimal(vectorDataType)) {
                    DecimalConverterFactory.DecimalConverter decimalConverter = vectorInfo.decimalConverter;
                    int precision = vectorInfo.measure.getMeasure().getPrecision();
                    for (int i = 0; i < size; i += DataTypes.LONG.getSizeInBytes()) {
                        BigDecimal decimal = decimalConverter.getDecimal(AdaptiveDeltaIntegralCodec.this.max - ByteUtil.toLongLittleEndian(pageData, i));
                        if (decimal.scale() < newScale) {
                            decimal = decimal.setScale(newScale);
                        }
                        vector.putDecimal(rowId++, decimal, precision);
                    }
                }
            } else {
                throw new RuntimeException("Unsupported datatype : " + pageDataType);
            }
        }
    };

    public AdaptiveDeltaIntegralCodec(DataType srcDataType, DataType targetDataType, SimpleStatsResult stats, boolean isInvertedIndex) {
        super(srcDataType, targetDataType, stats, isInvertedIndex);
        if (srcDataType == DataTypes.BYTE) {
            this.max = ((Byte)stats.getMax()).byteValue();
        } else if (srcDataType == DataTypes.SHORT) {
            this.max = ((Short)stats.getMax()).shortValue();
        } else if (srcDataType == DataTypes.INT) {
            this.max = ((Integer)stats.getMax()).intValue();
        } else if (srcDataType == DataTypes.LONG || srcDataType == DataTypes.TIMESTAMP) {
            this.max = (Long)stats.getMax();
        } else if (srcDataType == DataTypes.DOUBLE) {
            this.max = (long)((Double)stats.getMax()).doubleValue();
        } else if (DataTypes.isDecimal(srcDataType)) {
            this.max = ((BigDecimal)stats.getMax()).unscaledValue().longValue();
        } else {
            throw new UnsupportedOperationException("unsupported data type for Delta compress: " + srcDataType);
        }
    }

    @Override
    public String getName() {
        return "DeltaIntegralCodec";
    }

    @Override
    public ColumnPageEncoder createEncoder(Map<String, String> parameter) {
        return new ColumnPageEncoder(){
            ByteBuffer result = null;

            @Override
            protected ByteBuffer encodeData(ColumnPage input) throws IOException {
                if (AdaptiveDeltaIntegralCodec.this.encodedPage != null) {
                    throw new IllegalStateException("already encoded");
                }
                Compressor compressor = CompressorFactory.getInstance().getCompressor(input.getColumnCompressorName());
                this.result = AdaptiveDeltaIntegralCodec.this.encodeAndCompressPage(input, AdaptiveDeltaIntegralCodec.this.converter, compressor);
                ByteBuffer bytes = AdaptiveDeltaIntegralCodec.this.writeInvertedIndexIfRequired(this.result);
                AdaptiveDeltaIntegralCodec.this.encodedPage.freeMemory();
                if (bytes.limit() != 0) {
                    return bytes;
                }
                return this.result;
            }

            @Override
            protected ColumnPageEncoderMeta getEncoderMeta(ColumnPage inputPage) {
                return new ColumnPageEncoderMeta(inputPage.getColumnSpec(), AdaptiveDeltaIntegralCodec.this.targetDataType, inputPage.getStatistics(), inputPage.getColumnCompressorName());
            }

            @Override
            protected List<Encoding> getEncodingList() {
                ArrayList<Encoding> encodings = new ArrayList<Encoding>();
                encodings.add(Encoding.ADAPTIVE_DELTA_INTEGRAL);
                if (null != AdaptiveDeltaIntegralCodec.this.indexStorage && AdaptiveDeltaIntegralCodec.this.indexStorage.getRowIdPageLengthInBytes() > 0) {
                    encodings.add(Encoding.INVERTED_INDEX);
                }
                return encodings;
            }

            @Override
            protected void fillLegacyFields(DataChunk2 dataChunk) {
                AdaptiveDeltaIntegralCodec.this.fillLegacyFieldsIfRequired(dataChunk, this.result);
            }
        };
    }

    @Override
    public ColumnPageDecoder createDecoder(final ColumnPageEncoderMeta meta) {
        return new ColumnPageDecoder(){

            @Override
            public ColumnPage decode(byte[] input, int offset, int length) {
                ColumnPage page = null;
                page = DataTypes.isDecimal(meta.getSchemaDataType()) ? ColumnPage.decompressDecimalPage(meta, input, offset, length) : ColumnPage.decompress(meta, input, offset, length, false, false);
                return LazyColumnPage.newPage(page, AdaptiveDeltaIntegralCodec.this.converter);
            }

            @Override
            public void decodeAndFillVector(byte[] input, int offset, int length, ColumnVectorInfo vectorInfo, BitSet nullBits, boolean isLVEncoded, int pageSize, ReusableDataBuffer reusableDataBuffer) {
                byte[] unCompressData;
                Compressor compressor = CompressorFactory.getInstance().getCompressor(meta.getCompressorName());
                if (null != reusableDataBuffer && compressor.supportReusableBuffer()) {
                    int uncompressedLength = compressor.unCompressedLength(input, offset, length);
                    unCompressData = reusableDataBuffer.getDataBuffer(uncompressedLength);
                    compressor.rawUncompress(input, offset, length, unCompressData);
                } else {
                    unCompressData = compressor.unCompressByte(input, offset, length);
                }
                if (DataTypes.isDecimal(meta.getSchemaDataType())) {
                    DecimalConverterFactory.DecimalConverter decimalConverter;
                    TableSpec.ColumnSpec columnSpec = meta.getColumnSpec();
                    vectorInfo.decimalConverter = decimalConverter = DecimalConverterFactory.INSTANCE.getDecimalConverter(columnSpec.getPrecision(), columnSpec.getScale());
                }
                AdaptiveDeltaIntegralCodec.this.converter.decodeAndFillVector(unCompressData, vectorInfo, nullBits, meta.getStoreDataType(), pageSize);
            }

            @Override
            public ColumnPage decode(byte[] input, int offset, int length, boolean isLVEncoded) {
                return this.decode(input, offset, length);
            }
        };
    }
}

