/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.encoding.adaptive;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.ColumnPageValueConverter;
import org.apache.carbondata.core.datastore.page.LazyColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageDecoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.datastore.page.encoding.adaptive.AdaptiveCodec;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ColumnarVectorWrapperDirectFactory;
import org.apache.carbondata.core.scan.result.vector.impl.directread.SequentialFill;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.format.DataChunk2;
import org.apache.carbondata.format.Encoding;

public class AdaptiveFloatingCodec
extends AdaptiveCodec {
    private double factor;
    private float floatFactor;
    private ColumnPageValueConverter converter = new ColumnPageValueConverter(){

        @Override
        public void encode(int rowId, byte value) {
            throw new RuntimeException("internal error: " + AdaptiveFloatingCodec.this.debugInfo());
        }

        @Override
        public void encode(int rowId, short value) {
            throw new RuntimeException("internal error: " + AdaptiveFloatingCodec.this.debugInfo());
        }

        @Override
        public void encode(int rowId, int value) {
            throw new RuntimeException("internal error: " + AdaptiveFloatingCodec.this.debugInfo());
        }

        @Override
        public void encode(int rowId, long value) {
            throw new RuntimeException("internal error: " + AdaptiveFloatingCodec.this.debugInfo());
        }

        @Override
        public void encode(int rowId, float value) {
            this.encode(rowId, (double)value);
        }

        @Override
        public void encode(int rowId, double value) {
            if (AdaptiveFloatingCodec.this.targetDataType == DataTypes.BYTE) {
                AdaptiveFloatingCodec.this.encodedPage.putByte(rowId, (byte)Math.round(value * AdaptiveFloatingCodec.this.factor));
            } else if (AdaptiveFloatingCodec.this.targetDataType == DataTypes.SHORT) {
                AdaptiveFloatingCodec.this.encodedPage.putShort(rowId, (short)Math.round(value * AdaptiveFloatingCodec.this.factor));
            } else if (AdaptiveFloatingCodec.this.targetDataType == DataTypes.SHORT_INT) {
                AdaptiveFloatingCodec.this.encodedPage.putShortInt(rowId, (int)Math.round(value * AdaptiveFloatingCodec.this.factor));
            } else if (AdaptiveFloatingCodec.this.targetDataType == DataTypes.INT) {
                AdaptiveFloatingCodec.this.encodedPage.putInt(rowId, (int)Math.round(value * AdaptiveFloatingCodec.this.factor));
            } else if (AdaptiveFloatingCodec.this.targetDataType == DataTypes.LONG) {
                AdaptiveFloatingCodec.this.encodedPage.putLong(rowId, Math.round(value * AdaptiveFloatingCodec.this.factor));
            } else if (AdaptiveFloatingCodec.this.targetDataType == DataTypes.DOUBLE) {
                AdaptiveFloatingCodec.this.encodedPage.putDouble(rowId, value);
            } else {
                throw new RuntimeException("internal error: " + AdaptiveFloatingCodec.this.debugInfo());
            }
        }

        @Override
        public long decodeLong(byte value) {
            throw new RuntimeException("internal error: " + AdaptiveFloatingCodec.this.debugInfo());
        }

        @Override
        public long decodeLong(short value) {
            throw new RuntimeException("internal error: " + AdaptiveFloatingCodec.this.debugInfo());
        }

        @Override
        public long decodeLong(int value) {
            throw new RuntimeException("internal error: " + AdaptiveFloatingCodec.this.debugInfo());
        }

        @Override
        public double decodeDouble(byte value) {
            return (double)value / AdaptiveFloatingCodec.this.factor;
        }

        @Override
        public double decodeDouble(short value) {
            return (double)value / AdaptiveFloatingCodec.this.factor;
        }

        @Override
        public double decodeDouble(int value) {
            return (double)value / AdaptiveFloatingCodec.this.factor;
        }

        @Override
        public double decodeDouble(long value) {
            return (double)value / AdaptiveFloatingCodec.this.factor;
        }

        @Override
        public double decodeDouble(float value) {
            throw new RuntimeException("internal error: " + AdaptiveFloatingCodec.this.debugInfo());
        }

        @Override
        public double decodeDouble(double value) {
            throw new RuntimeException("internal error: " + AdaptiveFloatingCodec.this.debugInfo());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void decodeAndFillVector(byte[] pageData, ColumnVectorInfo vectorInfo, BitSet nullBits, DataType pageDataType, int pageSize) {
            int i;
            int size;
            int i2;
            CarbonColumnVector vector = vectorInfo.vector;
            BitSet deletedRows = vectorInfo.deletedRows;
            DataType vectorDataType = vector.getType();
            vector = ColumnarVectorWrapperDirectFactory.getDirectVectorWrapperFactory(vector, null, nullBits, deletedRows, true, false);
            int rowId = 0;
            if (vectorDataType == DataTypes.FLOAT) {
                if (pageDataType == DataTypes.BOOLEAN || pageDataType == DataTypes.BYTE) {
                    for (i2 = 0; i2 < pageSize; ++i2) {
                        vector.putFloat(i2, (float)pageData[i2] / AdaptiveFloatingCodec.this.floatFactor);
                    }
                } else if (pageDataType == DataTypes.SHORT) {
                    size = pageSize * DataTypes.SHORT.getSizeInBytes();
                    for (i = 0; i < size; i += DataTypes.SHORT.getSizeInBytes()) {
                        vector.putFloat(rowId++, (float)ByteUtil.toShortLittleEndian(pageData, i) / AdaptiveFloatingCodec.this.floatFactor);
                    }
                } else if (pageDataType == DataTypes.SHORT_INT) {
                    size = pageSize * DataTypes.SHORT_INT.getSizeInBytes();
                    for (i = 0; i < size; i += DataTypes.SHORT_INT.getSizeInBytes()) {
                        vector.putFloat(rowId++, (float)ByteUtil.valueOf3Bytes(pageData, i) / AdaptiveFloatingCodec.this.floatFactor);
                    }
                } else {
                    if (pageDataType != DataTypes.INT) throw new RuntimeException("internal error: " + this.toString());
                    size = pageSize * DataTypes.INT.getSizeInBytes();
                    for (i = 0; i < size; i += DataTypes.INT.getSizeInBytes()) {
                        vector.putFloat(rowId++, (float)ByteUtil.toIntLittleEndian(pageData, i) / AdaptiveFloatingCodec.this.floatFactor);
                    }
                }
            } else if (pageDataType == DataTypes.BOOLEAN || pageDataType == DataTypes.BYTE) {
                for (i2 = 0; i2 < pageSize; ++i2) {
                    vector.putDouble(i2, (double)pageData[i2] / AdaptiveFloatingCodec.this.factor);
                }
            } else if (pageDataType == DataTypes.SHORT) {
                size = pageSize * DataTypes.SHORT.getSizeInBytes();
                for (i = 0; i < size; i += DataTypes.SHORT.getSizeInBytes()) {
                    vector.putDouble(rowId++, (double)ByteUtil.toShortLittleEndian(pageData, i) / AdaptiveFloatingCodec.this.factor);
                }
            } else if (pageDataType == DataTypes.SHORT_INT) {
                size = pageSize * DataTypes.SHORT_INT.getSizeInBytes();
                for (i = 0; i < size; i += DataTypes.SHORT_INT.getSizeInBytes()) {
                    vector.putDouble(rowId++, (double)ByteUtil.valueOf3Bytes(pageData, i) / AdaptiveFloatingCodec.this.factor);
                }
            } else if (pageDataType == DataTypes.INT) {
                size = pageSize * DataTypes.INT.getSizeInBytes();
                for (i = 0; i < size; i += DataTypes.INT.getSizeInBytes()) {
                    vector.putDouble(rowId++, (double)ByteUtil.toIntLittleEndian(pageData, i) / AdaptiveFloatingCodec.this.factor);
                }
            } else {
                if (pageDataType != DataTypes.LONG) throw new RuntimeException("Unsupported datatype : " + pageDataType);
                size = pageSize * DataTypes.LONG.getSizeInBytes();
                for (i = 0; i < size; i += DataTypes.LONG.getSizeInBytes()) {
                    vector.putDouble(rowId++, (double)ByteUtil.toLongLittleEndian(pageData, i) / AdaptiveFloatingCodec.this.factor);
                }
            }
            if (deletedRows != null && !deletedRows.isEmpty() || vectorInfo.vector instanceof SequentialFill) return;
            i2 = nullBits.nextSetBit(0);
            while (i2 >= 0) {
                vector.putNull(i2);
                i2 = nullBits.nextSetBit(i2 + 1);
            }
        }
    };

    public AdaptiveFloatingCodec(DataType srcDataType, DataType targetDataType, SimpleStatsResult stats, boolean isInvertedIndex) {
        super(srcDataType, targetDataType, stats, isInvertedIndex);
        this.factor = Math.pow(10.0, stats.getDecimalCount());
        this.floatFactor = (float)this.factor;
    }

    @Override
    public String getName() {
        return "AdaptiveFloatingCodec";
    }

    @Override
    public ColumnPageEncoder createEncoder(Map<String, String> parameter) {
        return new ColumnPageEncoder(){
            ByteBuffer result = null;

            @Override
            protected ByteBuffer encodeData(ColumnPage input) throws IOException {
                if (AdaptiveFloatingCodec.this.encodedPage != null) {
                    throw new IllegalStateException("already encoded");
                }
                Compressor compressor = CompressorFactory.getInstance().getCompressor(input.getColumnCompressorName());
                this.result = AdaptiveFloatingCodec.this.encodeAndCompressPage(input, AdaptiveFloatingCodec.this.converter, compressor);
                ByteBuffer bytes = AdaptiveFloatingCodec.this.writeInvertedIndexIfRequired(this.result);
                AdaptiveFloatingCodec.this.encodedPage.freeMemory();
                if (bytes.limit() != 0) {
                    return bytes;
                }
                return this.result;
            }

            @Override
            protected List<Encoding> getEncodingList() {
                ArrayList<Encoding> encodings = new ArrayList<Encoding>();
                encodings.add(Encoding.ADAPTIVE_FLOATING);
                if (null != AdaptiveFloatingCodec.this.indexStorage && AdaptiveFloatingCodec.this.indexStorage.getRowIdPageLengthInBytes() > 0) {
                    encodings.add(Encoding.INVERTED_INDEX);
                }
                return encodings;
            }

            @Override
            protected ColumnPageEncoderMeta getEncoderMeta(ColumnPage inputPage) {
                return new ColumnPageEncoderMeta(inputPage.getColumnSpec(), AdaptiveFloatingCodec.this.targetDataType, AdaptiveFloatingCodec.this.stats, inputPage.getColumnCompressorName());
            }

            @Override
            protected void fillLegacyFields(DataChunk2 dataChunk) {
                AdaptiveFloatingCodec.this.fillLegacyFieldsIfRequired(dataChunk, this.result);
            }
        };
    }

    @Override
    public ColumnPageDecoder createDecoder(final ColumnPageEncoderMeta meta) {
        return new ColumnPageDecoder(){

            @Override
            public ColumnPage decode(byte[] input, int offset, int length) {
                ColumnPage page = ColumnPage.decompress(meta, input, offset, length, false, false);
                return LazyColumnPage.newPage(page, AdaptiveFloatingCodec.this.converter);
            }

            @Override
            public void decodeAndFillVector(byte[] input, int offset, int length, ColumnVectorInfo vectorInfo, BitSet nullBits, boolean isLVEncoded, int pageSize, ReusableDataBuffer reusableDataBuffer) {
                byte[] unCompressData;
                Compressor compressor = CompressorFactory.getInstance().getCompressor(meta.getCompressorName());
                if (null != reusableDataBuffer && compressor.supportReusableBuffer()) {
                    int uncompressedLength = compressor.unCompressedLength(input, offset, length);
                    unCompressData = reusableDataBuffer.getDataBuffer(uncompressedLength);
                    compressor.rawUncompress(input, offset, length, unCompressData);
                } else {
                    unCompressData = compressor.unCompressByte(input, offset, length);
                }
                AdaptiveFloatingCodec.this.converter.decodeAndFillVector(unCompressData, vectorInfo, nullBits, meta.getStoreDataType(), pageSize);
            }

            @Override
            public ColumnPage decode(byte[] input, int offset, int length, boolean isLVEncoded) {
                return this.decode(input, offset, length);
            }
        };
    }
}

