/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.encoding.adaptive;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.ColumnPageValueConverter;
import org.apache.carbondata.core.datastore.page.LazyColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageDecoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.datastore.page.encoding.adaptive.AdaptiveCodec;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalConverterFactory;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ColumnarVectorWrapperDirectFactory;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ConvertableVector;
import org.apache.carbondata.core.scan.result.vector.impl.directread.SequentialFill;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.format.DataChunk2;
import org.apache.carbondata.format.Encoding;

public class AdaptiveIntegralCodec
extends AdaptiveCodec {
    private ColumnPageValueConverter converter = new ColumnPageValueConverter(){

        @Override
        public void encode(int rowId, byte value) {
            if (AdaptiveIntegralCodec.this.targetDataType != DataTypes.BYTE) {
                throw new RuntimeException("internal error: " + AdaptiveIntegralCodec.this.debugInfo());
            }
            AdaptiveIntegralCodec.this.encodedPage.putByte(rowId, value);
        }

        @Override
        public void encode(int rowId, short value) {
            if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.BYTE) {
                AdaptiveIntegralCodec.this.encodedPage.putByte(rowId, (byte)value);
            } else if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.SHORT) {
                AdaptiveIntegralCodec.this.encodedPage.putShort(rowId, value);
            } else {
                throw new RuntimeException("internal error: " + AdaptiveIntegralCodec.this.debugInfo());
            }
        }

        @Override
        public void encode(int rowId, int value) {
            if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.BYTE) {
                AdaptiveIntegralCodec.this.encodedPage.putByte(rowId, (byte)value);
            } else if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.SHORT) {
                AdaptiveIntegralCodec.this.encodedPage.putShort(rowId, (short)value);
            } else if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.SHORT_INT) {
                AdaptiveIntegralCodec.this.encodedPage.putShortInt(rowId, value);
            } else if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.INT) {
                AdaptiveIntegralCodec.this.encodedPage.putInt(rowId, value);
            } else {
                throw new RuntimeException("internal error: " + AdaptiveIntegralCodec.this.debugInfo());
            }
        }

        @Override
        public void encode(int rowId, long value) {
            if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.BYTE) {
                AdaptiveIntegralCodec.this.encodedPage.putByte(rowId, (byte)value);
            } else if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.SHORT) {
                AdaptiveIntegralCodec.this.encodedPage.putShort(rowId, (short)value);
            } else if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.SHORT_INT) {
                AdaptiveIntegralCodec.this.encodedPage.putShortInt(rowId, (int)value);
            } else if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.INT) {
                AdaptiveIntegralCodec.this.encodedPage.putInt(rowId, (int)value);
            } else if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.LONG) {
                AdaptiveIntegralCodec.this.encodedPage.putLong(rowId, value);
            } else {
                throw new RuntimeException("internal error: " + AdaptiveIntegralCodec.this.debugInfo());
            }
        }

        @Override
        public void encode(int rowId, float value) {
            if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.BYTE) {
                AdaptiveIntegralCodec.this.encodedPage.putByte(rowId, (byte)value);
            } else if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.SHORT) {
                AdaptiveIntegralCodec.this.encodedPage.putShort(rowId, (short)value);
            } else if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.SHORT_INT) {
                AdaptiveIntegralCodec.this.encodedPage.putShortInt(rowId, (int)value);
            } else if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.INT) {
                AdaptiveIntegralCodec.this.encodedPage.putInt(rowId, (int)value);
            } else {
                throw new RuntimeException("internal error: " + AdaptiveIntegralCodec.this.debugInfo());
            }
        }

        @Override
        public void encode(int rowId, double value) {
            if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.BYTE) {
                AdaptiveIntegralCodec.this.encodedPage.putByte(rowId, (byte)value);
            } else if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.SHORT) {
                AdaptiveIntegralCodec.this.encodedPage.putShort(rowId, (short)value);
            } else if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.SHORT_INT) {
                AdaptiveIntegralCodec.this.encodedPage.putShortInt(rowId, (int)value);
            } else if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.INT) {
                AdaptiveIntegralCodec.this.encodedPage.putInt(rowId, (int)value);
            } else if (AdaptiveIntegralCodec.this.targetDataType == DataTypes.LONG) {
                AdaptiveIntegralCodec.this.encodedPage.putLong(rowId, (long)value);
            } else {
                throw new RuntimeException("internal error: " + AdaptiveIntegralCodec.this.debugInfo());
            }
        }

        @Override
        public long decodeLong(byte value) {
            return value;
        }

        @Override
        public long decodeLong(short value) {
            return value;
        }

        @Override
        public long decodeLong(int value) {
            return value;
        }

        @Override
        public double decodeDouble(byte value) {
            return value;
        }

        @Override
        public double decodeDouble(short value) {
            return value;
        }

        @Override
        public double decodeDouble(int value) {
            return value;
        }

        @Override
        public double decodeDouble(long value) {
            return value;
        }

        @Override
        public double decodeDouble(float value) {
            throw new RuntimeException("internal error: " + AdaptiveIntegralCodec.this.debugInfo());
        }

        @Override
        public double decodeDouble(double value) {
            throw new RuntimeException("internal error: " + AdaptiveIntegralCodec.this.debugInfo());
        }

        @Override
        public void decodeAndFillVector(byte[] pageData, ColumnVectorInfo vectorInfo, BitSet nullBits, DataType pageDataType, int pageSize) {
            CarbonColumnVector vector = vectorInfo.vector;
            DataType vectorDataType = vector.getType();
            BitSet deletedRows = vectorInfo.deletedRows;
            vector = ColumnarVectorWrapperDirectFactory.getDirectVectorWrapperFactory(vector, vectorInfo.invertedIndex, nullBits, deletedRows, true, false);
            this.fillVector(pageData, vector, vectorDataType, pageDataType, pageSize, vectorInfo, nullBits);
            if ((deletedRows == null || deletedRows.isEmpty()) && !(vectorInfo.vector instanceof SequentialFill)) {
                int i = nullBits.nextSetBit(0);
                while (i >= 0) {
                    vector.putNull(i);
                    i = nullBits.nextSetBit(i + 1);
                }
            }
            if (vector instanceof ConvertableVector) {
                ((ConvertableVector)((Object)vector)).convert();
            }
        }

        private void fillVector(byte[] pageData, CarbonColumnVector vector, DataType vectorDataType, DataType pageDataType, int pageSize, ColumnVectorInfo vectorInfo, BitSet nullBits) {
            block69: {
                int rowId;
                block73: {
                    block75: {
                        int size;
                        block74: {
                            block72: {
                                block71: {
                                    block70: {
                                        block68: {
                                            rowId = 0;
                                            if (pageDataType != DataTypes.BOOLEAN && pageDataType != DataTypes.BYTE) break block68;
                                            if (vectorDataType == DataTypes.SHORT) {
                                                for (int i = 0; i < pageSize; ++i) {
                                                    vector.putShort(i, pageData[i]);
                                                }
                                            } else if (vectorDataType == DataTypes.INT) {
                                                for (int i = 0; i < pageSize; ++i) {
                                                    vector.putInt(i, pageData[i]);
                                                }
                                            } else if (vectorDataType == DataTypes.LONG) {
                                                for (int i = 0; i < pageSize; ++i) {
                                                    vector.putLong(i, pageData[i]);
                                                }
                                            } else if (vectorDataType == DataTypes.TIMESTAMP) {
                                                for (int i = 0; i < pageSize; ++i) {
                                                    vector.putLong(i, (long)pageData[i] * 1000L);
                                                }
                                            } else if (vectorDataType == DataTypes.BOOLEAN) {
                                                vector.putBytes(0, pageSize, pageData, 0);
                                            } else if (DataTypes.isDecimal(vectorDataType)) {
                                                DecimalConverterFactory.DecimalConverter decimalConverter = vectorInfo.decimalConverter;
                                                decimalConverter.fillVector(pageData, pageSize, vectorInfo, nullBits, pageDataType);
                                            } else if (vectorDataType == DataTypes.FLOAT) {
                                                for (int i = 0; i < pageSize; ++i) {
                                                    vector.putFloat(i, pageData[i]);
                                                }
                                            } else {
                                                for (int i = 0; i < pageSize; ++i) {
                                                    vector.putDouble(i, pageData[i]);
                                                }
                                            }
                                            break block69;
                                        }
                                        if (pageDataType != DataTypes.SHORT) break block70;
                                        int size2 = pageSize * DataTypes.SHORT.getSizeInBytes();
                                        if (vectorDataType == DataTypes.SHORT) {
                                            for (int i = 0; i < size2; i += DataTypes.SHORT.getSizeInBytes()) {
                                                vector.putShort(rowId++, ByteUtil.toShortLittleEndian(pageData, i));
                                            }
                                        } else if (vectorDataType == DataTypes.INT) {
                                            for (int i = 0; i < size2; i += DataTypes.SHORT.getSizeInBytes()) {
                                                vector.putInt(rowId++, ByteUtil.toShortLittleEndian(pageData, i));
                                            }
                                        } else if (vectorDataType == DataTypes.LONG) {
                                            for (int i = 0; i < size2; i += DataTypes.SHORT.getSizeInBytes()) {
                                                vector.putLong(rowId++, ByteUtil.toShortLittleEndian(pageData, i));
                                            }
                                        } else if (vectorDataType == DataTypes.TIMESTAMP) {
                                            for (int i = 0; i < size2; i += DataTypes.SHORT.getSizeInBytes()) {
                                                vector.putLong(rowId++, (long)ByteUtil.toShortLittleEndian(pageData, i) * 1000L);
                                            }
                                        } else if (DataTypes.isDecimal(vectorDataType)) {
                                            DecimalConverterFactory.DecimalConverter decimalConverter = vectorInfo.decimalConverter;
                                            decimalConverter.fillVector(pageData, pageSize, vectorInfo, nullBits, pageDataType);
                                        } else if (vectorDataType == DataTypes.FLOAT) {
                                            for (int i = 0; i < size2; i += DataTypes.SHORT.getSizeInBytes()) {
                                                vector.putFloat(rowId++, ByteUtil.toShortLittleEndian(pageData, i));
                                            }
                                        } else {
                                            for (int i = 0; i < size2; i += DataTypes.SHORT.getSizeInBytes()) {
                                                vector.putDouble(rowId++, ByteUtil.toShortLittleEndian(pageData, i));
                                            }
                                        }
                                        break block69;
                                    }
                                    if (pageDataType != DataTypes.SHORT_INT) break block71;
                                    if (vectorDataType == DataTypes.INT) {
                                        for (int i = 0; i < pageSize; ++i) {
                                            int shortInt = ByteUtil.valueOf3Bytes(pageData, i * 3);
                                            vector.putInt(i, shortInt);
                                        }
                                    } else if (vectorDataType == DataTypes.LONG) {
                                        for (int i = 0; i < pageSize; ++i) {
                                            int shortInt = ByteUtil.valueOf3Bytes(pageData, i * 3);
                                            vector.putLong(i, shortInt);
                                        }
                                    } else if (vectorDataType == DataTypes.TIMESTAMP) {
                                        for (int i = 0; i < pageSize; ++i) {
                                            int shortInt = ByteUtil.valueOf3Bytes(pageData, i * 3);
                                            vector.putLong(i, (long)shortInt * 1000L);
                                        }
                                    } else if (DataTypes.isDecimal(vectorDataType)) {
                                        DecimalConverterFactory.DecimalConverter decimalConverter = vectorInfo.decimalConverter;
                                        decimalConverter.fillVector(pageData, pageSize, vectorInfo, nullBits, DataTypes.SHORT_INT);
                                    } else if (vectorDataType == DataTypes.FLOAT) {
                                        for (int i = 0; i < pageSize; ++i) {
                                            int shortInt = ByteUtil.valueOf3Bytes(pageData, i * 3);
                                            vector.putFloat(i, shortInt);
                                        }
                                    } else {
                                        for (int i = 0; i < pageSize; ++i) {
                                            int shortInt = ByteUtil.valueOf3Bytes(pageData, i * 3);
                                            vector.putDouble(i, shortInt);
                                        }
                                    }
                                    break block69;
                                }
                                if (pageDataType != DataTypes.INT) break block72;
                                int size3 = pageSize * DataTypes.INT.getSizeInBytes();
                                if (vectorDataType == DataTypes.INT) {
                                    for (int i = 0; i < size3; i += DataTypes.INT.getSizeInBytes()) {
                                        vector.putInt(rowId++, ByteUtil.toIntLittleEndian(pageData, i));
                                    }
                                } else if (vectorDataType == DataTypes.LONG) {
                                    for (int i = 0; i < size3; i += DataTypes.INT.getSizeInBytes()) {
                                        vector.putLong(rowId++, ByteUtil.toIntLittleEndian(pageData, i));
                                    }
                                } else if (vectorDataType == DataTypes.TIMESTAMP) {
                                    for (int i = 0; i < size3; i += DataTypes.INT.getSizeInBytes()) {
                                        vector.putLong(rowId++, (long)ByteUtil.toIntLittleEndian(pageData, i) * 1000L);
                                    }
                                } else if (DataTypes.isDecimal(vectorDataType)) {
                                    DecimalConverterFactory.DecimalConverter decimalConverter = vectorInfo.decimalConverter;
                                    decimalConverter.fillVector(pageData, pageSize, vectorInfo, nullBits, pageDataType);
                                } else {
                                    for (int i = 0; i < size3; i += DataTypes.INT.getSizeInBytes()) {
                                        vector.putDouble(rowId++, ByteUtil.toIntLittleEndian(pageData, i));
                                    }
                                }
                                break block69;
                            }
                            if (pageDataType != DataTypes.LONG) break block73;
                            size = pageSize * DataTypes.LONG.getSizeInBytes();
                            if (vectorDataType != DataTypes.LONG) break block74;
                            for (int i = 0; i < size; i += DataTypes.LONG.getSizeInBytes()) {
                                vector.putLong(rowId++, ByteUtil.toLongLittleEndian(pageData, i));
                            }
                            break block69;
                        }
                        if (vectorDataType != DataTypes.TIMESTAMP) break block75;
                        for (int i = 0; i < size; i += DataTypes.LONG.getSizeInBytes()) {
                            vector.putLong(rowId++, ByteUtil.toLongLittleEndian(pageData, i) * 1000L);
                        }
                        break block69;
                    }
                    if (!DataTypes.isDecimal(vectorDataType)) break block69;
                    DecimalConverterFactory.DecimalConverter decimalConverter = vectorInfo.decimalConverter;
                    decimalConverter.fillVector(pageData, pageSize, vectorInfo, nullBits, pageDataType);
                    break block69;
                }
                int size = pageSize * DataTypes.DOUBLE.getSizeInBytes();
                for (int i = 0; i < size; i += DataTypes.DOUBLE.getSizeInBytes()) {
                    vector.putDouble(rowId++, ByteUtil.toDoubleLittleEndian(pageData, i));
                }
            }
        }
    };

    public AdaptiveIntegralCodec(DataType srcDataType, DataType targetDataType, SimpleStatsResult stats, boolean isInvertedIndex) {
        super(srcDataType, targetDataType, stats, isInvertedIndex);
    }

    @Override
    public String getName() {
        return "AdaptiveIntegralCodec";
    }

    @Override
    public ColumnPageEncoder createEncoder(Map<String, String> parameter) {
        return new ColumnPageEncoder(){
            ByteBuffer result = null;

            @Override
            protected ByteBuffer encodeData(ColumnPage input) throws IOException {
                if (AdaptiveIntegralCodec.this.encodedPage != null) {
                    throw new IllegalStateException("already encoded");
                }
                Compressor compressor = CompressorFactory.getInstance().getCompressor(input.getColumnCompressorName());
                this.result = AdaptiveIntegralCodec.this.encodeAndCompressPage(input, AdaptiveIntegralCodec.this.converter, compressor);
                ByteBuffer bytes = AdaptiveIntegralCodec.this.writeInvertedIndexIfRequired(this.result);
                AdaptiveIntegralCodec.this.encodedPage.freeMemory();
                if (bytes.limit() != 0) {
                    return bytes;
                }
                return this.result;
            }

            @Override
            protected List<Encoding> getEncodingList() {
                ArrayList<Encoding> encodings = new ArrayList<Encoding>();
                encodings.add(Encoding.ADAPTIVE_INTEGRAL);
                if (null != AdaptiveIntegralCodec.this.indexStorage && AdaptiveIntegralCodec.this.indexStorage.getRowIdPageLengthInBytes() > 0) {
                    encodings.add(Encoding.INVERTED_INDEX);
                }
                return encodings;
            }

            @Override
            protected ColumnPageEncoderMeta getEncoderMeta(ColumnPage inputPage) {
                return new ColumnPageEncoderMeta(inputPage.getColumnSpec(), AdaptiveIntegralCodec.this.targetDataType, AdaptiveIntegralCodec.this.stats, inputPage.getColumnCompressorName());
            }

            @Override
            protected void fillLegacyFields(DataChunk2 dataChunk) {
                AdaptiveIntegralCodec.this.fillLegacyFieldsIfRequired(dataChunk, this.result);
            }
        };
    }

    @Override
    public ColumnPageDecoder createDecoder(final ColumnPageEncoderMeta meta) {
        return new ColumnPageDecoder(){

            @Override
            public ColumnPage decode(byte[] input, int offset, int length) {
                ColumnPage page = null;
                page = DataTypes.isDecimal(meta.getSchemaDataType()) ? ColumnPage.decompressDecimalPage(meta, input, offset, length) : ColumnPage.decompress(meta, input, offset, length, false, false);
                return LazyColumnPage.newPage(page, AdaptiveIntegralCodec.this.converter);
            }

            @Override
            public void decodeAndFillVector(byte[] input, int offset, int length, ColumnVectorInfo vectorInfo, BitSet nullBits, boolean isLVEncoded, int pageSize, ReusableDataBuffer reusableDataBuffer) {
                byte[] unCompressData;
                Compressor compressor = CompressorFactory.getInstance().getCompressor(meta.getCompressorName());
                if (null != reusableDataBuffer && compressor.supportReusableBuffer()) {
                    int uncompressedLength = compressor.unCompressedLength(input, offset, length);
                    unCompressData = reusableDataBuffer.getDataBuffer(uncompressedLength);
                    compressor.rawUncompress(input, offset, length, unCompressData);
                } else {
                    unCompressData = compressor.unCompressByte(input, offset, length);
                }
                if (DataTypes.isDecimal(meta.getSchemaDataType())) {
                    DecimalConverterFactory.DecimalConverter decimalConverter;
                    TableSpec.ColumnSpec columnSpec = meta.getColumnSpec();
                    vectorInfo.decimalConverter = decimalConverter = DecimalConverterFactory.INSTANCE.getDecimalConverter(columnSpec.getPrecision(), columnSpec.getScale());
                }
                AdaptiveIntegralCodec.this.converter.decodeAndFillVector(unCompressData, vectorInfo, nullBits, meta.getStoreDataType(), pageSize);
            }

            @Override
            public ColumnPage decode(byte[] input, int offset, int length, boolean isLVEncoded) {
                return this.decode(input, offset, length);
            }
        };
    }
}

