/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.encoding.compress;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.ColumnPageValueConverter;
import org.apache.carbondata.core.datastore.page.LazyColumnPage;
import org.apache.carbondata.core.datastore.page.VarLengthColumnPageBase;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageCodec;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageDecoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalConverterFactory;
import org.apache.carbondata.core.scan.result.vector.CarbonColumnVector;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ColumnarVectorWrapperDirectFactory;
import org.apache.carbondata.core.scan.result.vector.impl.directread.ConvertableVector;
import org.apache.carbondata.core.scan.result.vector.impl.directread.SequentialFill;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.format.Encoding;

public class DirectCompressCodec
implements ColumnPageCodec {
    private DataType dataType;
    boolean isComplexPrimitiveIntLengthEncoding = false;
    private ColumnPageValueConverter converter = new ColumnPageValueConverter(){

        @Override
        public void encode(int rowId, byte value) {
            throw new RuntimeException("internal error");
        }

        @Override
        public void encode(int rowId, short value) {
            throw new RuntimeException("internal error");
        }

        @Override
        public void encode(int rowId, int value) {
            throw new RuntimeException("internal error");
        }

        @Override
        public void encode(int rowId, long value) {
            throw new RuntimeException("internal error");
        }

        @Override
        public void encode(int rowId, float value) {
            throw new RuntimeException("internal error");
        }

        @Override
        public void encode(int rowId, double value) {
            throw new RuntimeException("internal error");
        }

        @Override
        public long decodeLong(byte value) {
            return value;
        }

        @Override
        public long decodeLong(short value) {
            return value;
        }

        @Override
        public long decodeLong(int value) {
            return value;
        }

        @Override
        public double decodeDouble(byte value) {
            return value;
        }

        @Override
        public double decodeDouble(short value) {
            return value;
        }

        @Override
        public double decodeDouble(int value) {
            return value;
        }

        @Override
        public double decodeDouble(long value) {
            return value;
        }

        @Override
        public double decodeDouble(float value) {
            return value;
        }

        @Override
        public double decodeDouble(double value) {
            return value;
        }

        @Override
        public void decodeAndFillVector(byte[] pageData, ColumnVectorInfo vectorInfo, BitSet nullBits, DataType pageDataType, int pageSize) {
            CarbonColumnVector vector = vectorInfo.vector;
            DataType vectorDataType = vector.getType();
            BitSet deletedRows = vectorInfo.deletedRows;
            vector = ColumnarVectorWrapperDirectFactory.getDirectVectorWrapperFactory(vector, vectorInfo.invertedIndex, nullBits, deletedRows, true, false);
            this.fillVector(pageData, vector, vectorDataType, pageDataType, pageSize, vectorInfo, nullBits);
            if ((deletedRows == null || deletedRows.isEmpty()) && !(vectorInfo.vector instanceof SequentialFill)) {
                int i = nullBits.nextSetBit(0);
                while (i >= 0) {
                    vector.putNull(i);
                    i = nullBits.nextSetBit(i + 1);
                }
            }
            if (vector instanceof ConvertableVector) {
                ((ConvertableVector)((Object)vector)).convert();
            }
        }

        private void fillVector(byte[] pageData, CarbonColumnVector vector, DataType vectorDataType, DataType pageDataType, int pageSize, ColumnVectorInfo vectorInfo, BitSet nullBits) {
            block63: {
                int rowId;
                block67: {
                    block69: {
                        int size;
                        block68: {
                            block66: {
                                block65: {
                                    block64: {
                                        block62: {
                                            rowId = 0;
                                            if (pageDataType != DataTypes.BOOLEAN && pageDataType != DataTypes.BYTE) break block62;
                                            if (vectorDataType == DataTypes.SHORT) {
                                                for (int i = 0; i < pageSize; ++i) {
                                                    vector.putShort(i, pageData[i]);
                                                }
                                            } else if (vectorDataType == DataTypes.INT) {
                                                for (int i = 0; i < pageSize; ++i) {
                                                    vector.putInt(i, pageData[i]);
                                                }
                                            } else if (vectorDataType == DataTypes.LONG) {
                                                for (int i = 0; i < pageSize; ++i) {
                                                    vector.putLong(i, pageData[i]);
                                                }
                                            } else if (vectorDataType == DataTypes.TIMESTAMP) {
                                                for (int i = 0; i < pageSize; ++i) {
                                                    vector.putLong(i, (long)pageData[i] * 1000L);
                                                }
                                            } else if (vectorDataType == DataTypes.BOOLEAN || vectorDataType == DataTypes.BYTE) {
                                                vector.putBytes(0, pageSize, pageData, 0);
                                            } else if (DataTypes.isDecimal(vectorDataType)) {
                                                DecimalConverterFactory.DecimalConverter decimalConverter = vectorInfo.decimalConverter;
                                                decimalConverter.fillVector(pageData, pageSize, vectorInfo, nullBits, pageDataType);
                                            } else {
                                                for (int i = 0; i < pageSize; ++i) {
                                                    vector.putDouble(i, pageData[i]);
                                                }
                                            }
                                            break block63;
                                        }
                                        if (pageDataType != DataTypes.SHORT) break block64;
                                        int size2 = pageSize * DataTypes.SHORT.getSizeInBytes();
                                        if (vectorDataType == DataTypes.SHORT) {
                                            for (int i = 0; i < size2; i += DataTypes.SHORT.getSizeInBytes()) {
                                                vector.putShort(rowId++, ByteUtil.toShortLittleEndian(pageData, i));
                                            }
                                        } else if (vectorDataType == DataTypes.INT) {
                                            for (int i = 0; i < size2; i += DataTypes.SHORT.getSizeInBytes()) {
                                                vector.putInt(rowId++, ByteUtil.toShortLittleEndian(pageData, i));
                                            }
                                        } else if (vectorDataType == DataTypes.LONG) {
                                            for (int i = 0; i < size2; i += DataTypes.SHORT.getSizeInBytes()) {
                                                vector.putLong(rowId++, ByteUtil.toShortLittleEndian(pageData, i));
                                            }
                                        } else if (vectorDataType == DataTypes.TIMESTAMP) {
                                            for (int i = 0; i < size2; i += DataTypes.SHORT.getSizeInBytes()) {
                                                vector.putLong(rowId++, (long)ByteUtil.toShortLittleEndian(pageData, i) * 1000L);
                                            }
                                        } else if (DataTypes.isDecimal(vectorDataType)) {
                                            DecimalConverterFactory.DecimalConverter decimalConverter = vectorInfo.decimalConverter;
                                            decimalConverter.fillVector(pageData, pageSize, vectorInfo, nullBits, pageDataType);
                                        } else {
                                            for (int i = 0; i < size2; i += DataTypes.SHORT.getSizeInBytes()) {
                                                vector.putDouble(rowId++, ByteUtil.toShortLittleEndian(pageData, i));
                                            }
                                        }
                                        break block63;
                                    }
                                    if (pageDataType != DataTypes.SHORT_INT) break block65;
                                    if (vectorDataType == DataTypes.INT) {
                                        for (int i = 0; i < pageSize; ++i) {
                                            int shortInt = ByteUtil.valueOf3Bytes(pageData, i * 3);
                                            vector.putInt(i, shortInt);
                                        }
                                    } else if (vectorDataType == DataTypes.LONG) {
                                        for (int i = 0; i < pageSize; ++i) {
                                            int shortInt = ByteUtil.valueOf3Bytes(pageData, i * 3);
                                            vector.putLong(i, shortInt);
                                        }
                                    } else if (vectorDataType == DataTypes.TIMESTAMP) {
                                        for (int i = 0; i < pageSize; ++i) {
                                            int shortInt = ByteUtil.valueOf3Bytes(pageData, i * 3);
                                            vector.putLong(i, (long)shortInt * 1000L);
                                        }
                                    } else if (DataTypes.isDecimal(vectorDataType)) {
                                        DecimalConverterFactory.DecimalConverter decimalConverter = vectorInfo.decimalConverter;
                                        decimalConverter.fillVector(pageData, pageSize, vectorInfo, nullBits, pageDataType);
                                    } else {
                                        for (int i = 0; i < pageSize; ++i) {
                                            int shortInt = ByteUtil.valueOf3Bytes(pageData, i * 3);
                                            vector.putDouble(i, shortInt);
                                        }
                                    }
                                    break block63;
                                }
                                if (pageDataType != DataTypes.INT) break block66;
                                int size3 = pageSize * DataTypes.INT.getSizeInBytes();
                                if (vectorDataType == DataTypes.INT) {
                                    for (int i = 0; i < size3; i += DataTypes.INT.getSizeInBytes()) {
                                        vector.putInt(rowId++, ByteUtil.toIntLittleEndian(pageData, i));
                                    }
                                } else if (vectorDataType == DataTypes.LONG) {
                                    for (int i = 0; i < size3; i += DataTypes.INT.getSizeInBytes()) {
                                        vector.putLong(rowId++, ByteUtil.toIntLittleEndian(pageData, i));
                                    }
                                } else if (vectorDataType == DataTypes.TIMESTAMP) {
                                    for (int i = 0; i < size3; i += DataTypes.INT.getSizeInBytes()) {
                                        vector.putLong(rowId++, (long)ByteUtil.toIntLittleEndian(pageData, i) * 1000L);
                                    }
                                } else if (DataTypes.isDecimal(vectorDataType)) {
                                    DecimalConverterFactory.DecimalConverter decimalConverter = vectorInfo.decimalConverter;
                                    decimalConverter.fillVector(pageData, pageSize, vectorInfo, nullBits, pageDataType);
                                } else {
                                    for (int i = 0; i < size3; i += DataTypes.INT.getSizeInBytes()) {
                                        vector.putDouble(rowId++, ByteUtil.toIntLittleEndian(pageData, i));
                                    }
                                }
                                break block63;
                            }
                            if (pageDataType != DataTypes.LONG) break block67;
                            size = pageSize * DataTypes.LONG.getSizeInBytes();
                            if (vectorDataType != DataTypes.LONG) break block68;
                            for (int i = 0; i < size; i += DataTypes.LONG.getSizeInBytes()) {
                                vector.putLong(rowId++, ByteUtil.toLongLittleEndian(pageData, i));
                            }
                            break block63;
                        }
                        if (vectorDataType != DataTypes.TIMESTAMP) break block69;
                        for (int i = 0; i < size; i += DataTypes.LONG.getSizeInBytes()) {
                            vector.putLong(rowId++, ByteUtil.toLongLittleEndian(pageData, i) * 1000L);
                        }
                        break block63;
                    }
                    if (!DataTypes.isDecimal(vectorDataType)) break block63;
                    DecimalConverterFactory.DecimalConverter decimalConverter = vectorInfo.decimalConverter;
                    decimalConverter.fillVector(pageData, pageSize, vectorInfo, nullBits, pageDataType);
                    break block63;
                }
                if (vectorDataType == DataTypes.FLOAT) {
                    int size = pageSize * DataTypes.FLOAT.getSizeInBytes();
                    for (int i = 0; i < size; i += DataTypes.FLOAT.getSizeInBytes()) {
                        vector.putFloat(rowId++, ByteUtil.toFloatLittleEndian(pageData, i));
                    }
                } else {
                    int size = pageSize * DataTypes.DOUBLE.getSizeInBytes();
                    for (int i = 0; i < size; i += DataTypes.DOUBLE.getSizeInBytes()) {
                        vector.putDouble(rowId++, ByteUtil.toDoubleLittleEndian(pageData, i));
                    }
                }
            }
        }
    };

    public DirectCompressCodec(DataType dataType) {
        this.dataType = dataType;
    }

    public void setComplexPrimitiveIntLengthEncoding(boolean complexPrimitiveIntLengthEncoding) {
        this.isComplexPrimitiveIntLengthEncoding = complexPrimitiveIntLengthEncoding;
    }

    @Override
    public String getName() {
        return "DirectCompressCodec";
    }

    @Override
    public ColumnPageEncoder createEncoder(Map<String, String> parameter) {
        return new ColumnPageEncoder(){

            @Override
            protected ByteBuffer encodeData(ColumnPage input) throws IOException {
                Compressor compressor = CompressorFactory.getInstance().getCompressor(input.getColumnCompressorName());
                return input.compress(compressor);
            }

            @Override
            protected List<Encoding> getEncodingList() {
                ArrayList<Encoding> encodings = new ArrayList<Encoding>();
                encodings.add(DirectCompressCodec.this.dataType == DataTypes.VARCHAR ? Encoding.DIRECT_COMPRESS_VARCHAR : Encoding.DIRECT_COMPRESS);
                return encodings;
            }

            @Override
            protected ColumnPageEncoderMeta getEncoderMeta(ColumnPage inputPage) {
                return new ColumnPageEncoderMeta(inputPage.getColumnSpec(), inputPage.getDataType(), inputPage.getStatistics(), inputPage.getColumnCompressorName());
            }
        };
    }

    @Override
    public ColumnPageDecoder createDecoder(final ColumnPageEncoderMeta meta) {
        return new ColumnPageDecoder(){

            @Override
            public ColumnPage decode(byte[] input, int offset, int length) {
                ColumnPage decodedPage = DataTypes.isDecimal(DirectCompressCodec.this.dataType) ? ColumnPage.decompressDecimalPage(meta, input, offset, length) : ColumnPage.decompress(meta, input, offset, length, false, DirectCompressCodec.this.isComplexPrimitiveIntLengthEncoding);
                return LazyColumnPage.newPage(decodedPage, DirectCompressCodec.this.converter);
            }

            @Override
            public void decodeAndFillVector(byte[] input, int offset, int length, ColumnVectorInfo vectorInfo, BitSet nullBits, boolean isLVEncoded, int pageSize, ReusableDataBuffer reusableDataBuffer) {
                byte[] unCompressData;
                int uncompressedLength;
                Compressor compressor = CompressorFactory.getInstance().getCompressor(meta.getCompressorName());
                if (null != reusableDataBuffer && compressor.supportReusableBuffer()) {
                    uncompressedLength = compressor.unCompressedLength(input, offset, length);
                    unCompressData = reusableDataBuffer.getDataBuffer(uncompressedLength);
                    compressor.rawUncompress(input, offset, length, unCompressData);
                } else {
                    unCompressData = compressor.unCompressByte(input, offset, length);
                    uncompressedLength = unCompressData.length;
                }
                if (DataTypes.isDecimal(DirectCompressCodec.this.dataType)) {
                    DecimalConverterFactory.DecimalConverter decimalConverter;
                    TableSpec.ColumnSpec columnSpec = meta.getColumnSpec();
                    vectorInfo.decimalConverter = decimalConverter = DecimalConverterFactory.INSTANCE.getDecimalConverter(columnSpec.getPrecision(), columnSpec.getScale());
                    if (DataTypes.isDecimal(meta.getStoreDataType())) {
                        ColumnPage decimalColumnPage = VarLengthColumnPageBase.newDecimalColumnPage(meta, unCompressData, uncompressedLength);
                        decimalConverter.fillVector(decimalColumnPage.getByteArrayPage(), pageSize, vectorInfo, nullBits, meta.getStoreDataType());
                    } else {
                        DirectCompressCodec.this.converter.decodeAndFillVector(unCompressData, vectorInfo, nullBits, meta.getStoreDataType(), pageSize);
                    }
                } else {
                    DirectCompressCodec.this.converter.decodeAndFillVector(unCompressData, vectorInfo, nullBits, meta.getStoreDataType(), pageSize);
                }
            }

            @Override
            public ColumnPage decode(byte[] input, int offset, int length, boolean isLVEncoded) {
                return LazyColumnPage.newPage(ColumnPage.decompress(meta, input, offset, length, isLVEncoded, DirectCompressCodec.this.isComplexPrimitiveIntLengthEncoding), DirectCompressCodec.this.converter);
            }
        };
    }
}

