/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.encoding.dimension.legacy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.datastore.columnar.BlockIndexerStorage;
import org.apache.carbondata.core.datastore.columnar.ByteArrayBlockIndexerStorage;
import org.apache.carbondata.core.datastore.columnar.ByteArrayBlockIndexerStorageWithoutRowId;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoder;
import org.apache.carbondata.core.datastore.page.encoding.dimension.legacy.IndexStorageCodec;
import org.apache.carbondata.core.datastore.page.encoding.dimension.legacy.IndexStorageEncoder;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.format.Encoding;

public class DirectDictDimensionIndexCodec
extends IndexStorageCodec {
    public DirectDictDimensionIndexCodec(boolean isSort, boolean isInvertedIndex) {
        super(isSort, isInvertedIndex);
    }

    @Override
    public String getName() {
        return "DirectDictDimensionIndexCodec";
    }

    @Override
    public ColumnPageEncoder createEncoder(Map<String, String> parameter) {
        return new IndexStorageEncoder(){

            @Override
            void encodeIndexStorage(ColumnPage inputPage) {
                byte[][] data = inputPage.getByteArrayPage();
                BlockIndexerStorage indexStorage = DirectDictDimensionIndexCodec.this.isInvertedIndex ? new ByteArrayBlockIndexerStorage(data, false, false, DirectDictDimensionIndexCodec.this.isSort) : new ByteArrayBlockIndexerStorageWithoutRowId(data, false);
                byte[] flattened = ByteUtil.flatten((byte[][])indexStorage.getDataPage());
                Compressor compressor = CompressorFactory.getInstance().getCompressor(inputPage.getColumnCompressorName());
                this.compressedDataPage = compressor.compressByte(flattened);
                this.indexStorage = indexStorage;
            }

            @Override
            protected List<Encoding> getEncodingList() {
                ArrayList<Encoding> encodings = new ArrayList<Encoding>();
                encodings.add(Encoding.DICTIONARY);
                encodings.add(Encoding.RLE);
                if (DirectDictDimensionIndexCodec.this.isInvertedIndex) {
                    encodings.add(Encoding.INVERTED_INDEX);
                }
                return encodings;
            }
        };
    }
}

