/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.encoding.dimension.legacy;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.carbondata.core.datastore.columnar.BlockIndexerStorage;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.format.DataChunk2;
import org.apache.carbondata.format.SortState;

public abstract class IndexStorageEncoder
extends ColumnPageEncoder {
    BlockIndexerStorage indexStorage;
    ByteBuffer compressedDataPage;

    abstract void encodeIndexStorage(ColumnPage var1);

    @Override
    protected ByteBuffer encodeData(ColumnPage input) throws IOException {
        this.encodeIndexStorage(input);
        if (this.indexStorage.getRowIdPageLengthInBytes() > 0 || this.indexStorage.getDataRlePageLengthInBytes() > 0) {
            return this.appendToCompressedData();
        }
        return this.compressedDataPage;
    }

    private ByteBuffer appendToCompressedData() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        ByteBuffer buffer = this.compressedDataPage.asReadOnlyBuffer();
        int length = buffer.limit();
        for (int i = 0; i < length; ++i) {
            out.writeByte(buffer.get(i));
        }
        if (this.indexStorage.getRowIdPageLengthInBytes() > 0) {
            out.writeInt(this.indexStorage.getRowIdPageLengthInBytes());
            for (short rowId : this.indexStorage.getRowIdPage()) {
                out.writeShort(rowId);
            }
            if (this.indexStorage.getRowIdRlePageLengthInBytes() > 0) {
                for (short rowIdRle : this.indexStorage.getRowIdRlePage()) {
                    out.writeShort(rowIdRle);
                }
            }
        }
        if (this.indexStorage.getDataRlePageLengthInBytes() > 0) {
            for (short dataRle : this.indexStorage.getDataRlePage()) {
                out.writeShort(dataRle);
            }
        }
        byte[] output = stream.toByteArray();
        out.close();
        return ByteBuffer.wrap(output);
    }

    @Override
    protected ColumnPageEncoderMeta getEncoderMeta(ColumnPage inputPage) {
        return null;
    }

    @Override
    protected void fillLegacyFields(DataChunk2 dataChunk) {
        SortState sort = this.indexStorage.getRowIdPageLengthInBytes() > 0 ? SortState.SORT_EXPLICIT : SortState.SORT_NATIVE;
        dataChunk.setSort_state(sort);
        if (this.indexStorage.getRowIdPageLengthInBytes() > 0) {
            int rowIdPageLength = 4 + this.indexStorage.getRowIdPageLengthInBytes() + this.indexStorage.getRowIdRlePageLengthInBytes();
            dataChunk.setRowid_page_length(rowIdPageLength);
        }
        if (this.indexStorage.getDataRlePageLengthInBytes() > 0) {
            dataChunk.setRle_page_length(this.indexStorage.getDataRlePageLengthInBytes());
        }
        dataChunk.setData_page_length(this.compressedDataPage.limit() - this.compressedDataPage.position());
    }
}

