/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.encoding.dimension.legacy;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.datastore.columnar.BlockIndexerStorage;
import org.apache.carbondata.core.datastore.columnar.ByteArrayBlockIndexerStorage;
import org.apache.carbondata.core.datastore.columnar.ByteArrayBlockIndexerStorageWithoutRowId;
import org.apache.carbondata.core.datastore.columnar.DummyBlockIndexerStorage;
import org.apache.carbondata.core.datastore.compression.Compressor;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoder;
import org.apache.carbondata.core.datastore.page.encoding.dimension.legacy.IndexStorageCodec;
import org.apache.carbondata.core.datastore.page.encoding.dimension.legacy.IndexStorageEncoder;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.format.Encoding;

public class PlainDimensionIndexCodec
extends IndexStorageCodec {
    private boolean isVarcharType;

    public PlainDimensionIndexCodec(boolean isSort, boolean isInvertedIndex, boolean isVarcharType) {
        super(isSort, isInvertedIndex);
        this.isVarcharType = isVarcharType;
    }

    @Override
    public String getName() {
        return "PlainDimensionIndexCodec";
    }

    @Override
    public ColumnPageEncoder createEncoder(Map<String, String> parameter) {
        return new IndexStorageEncoder(){

            @Override
            protected void encodeIndexStorage(ColumnPage input) {
                BlockIndexerStorage indexStorage;
                boolean isDictionary = input.isLocalDictGeneratedPage();
                Compressor compressor = CompressorFactory.getInstance().getCompressor(input.getColumnCompressorName());
                if (PlainDimensionIndexCodec.this.isInvertedIndex || isDictionary) {
                    byte[][] byteArray = input.getByteArrayPage();
                    indexStorage = PlainDimensionIndexCodec.this.isInvertedIndex ? new ByteArrayBlockIndexerStorage(byteArray, isDictionary, !isDictionary, PlainDimensionIndexCodec.this.isSort) : new ByteArrayBlockIndexerStorageWithoutRowId(byteArray, true);
                    byte[] compressInput = ByteUtil.flatten((byte[][])indexStorage.getDataPage());
                    this.compressedDataPage = compressor.compressByte(compressInput);
                } else {
                    ByteBuffer data = input.getByteBuffer();
                    indexStorage = new DummyBlockIndexerStorage();
                    this.compressedDataPage = compressor.compressByte(data);
                }
                this.indexStorage = indexStorage;
            }

            @Override
            protected List<Encoding> getEncodingList() {
                ArrayList<Encoding> encodings = new ArrayList<Encoding>();
                if (PlainDimensionIndexCodec.this.isVarcharType) {
                    encodings.add(Encoding.DIRECT_COMPRESS_VARCHAR);
                } else if (this.indexStorage.getRowIdPageLengthInBytes() > 0) {
                    encodings.add(Encoding.INVERTED_INDEX);
                }
                if (this.indexStorage.getDataRlePageLengthInBytes() > 0) {
                    encodings.add(Encoding.RLE);
                }
                return encodings;
            }
        };
    }
}

