/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.encoding.rle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.datastore.ReusableDataBuffer;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageCodec;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageDecoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoder;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.datastore.page.encoding.rle.RLEEncoderMeta;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.result.vector.ColumnVectorInfo;
import org.apache.carbondata.format.Encoding;

public class RLECodec
implements ColumnPageCodec {
    @Override
    public String getName() {
        return "RLECodec";
    }

    @Override
    public ColumnPageEncoder createEncoder(Map<String, String> parameter) {
        return new RLEEncoder();
    }

    @Override
    public ColumnPageDecoder createDecoder(ColumnPageEncoderMeta meta) {
        assert (meta instanceof RLEEncoderMeta);
        RLEEncoderMeta codecMeta = (RLEEncoderMeta)meta;
        return new RLEDecoder(meta.getColumnSpec(), codecMeta.getPageSize(), meta.getCompressorName());
    }

    private void validateDataType(DataType dataType) {
        if (dataType != DataTypes.BOOLEAN && dataType != DataTypes.BYTE && dataType != DataTypes.SHORT && dataType != DataTypes.INT && dataType != DataTypes.LONG) {
            throw new UnsupportedOperationException(dataType + " is not supported for RLE");
        }
    }

    private class RLEDecoder
    implements ColumnPageDecoder {
        private TableSpec.ColumnSpec columnSpec;
        private int pageSize;
        private String compressorName;

        private RLEDecoder(TableSpec.ColumnSpec columnSpec, int pageSize, String compressorName) {
            RLECodec.this.validateDataType(columnSpec.getSchemaDataType());
            this.columnSpec = columnSpec;
            this.pageSize = pageSize;
            this.compressorName = compressorName;
        }

        @Override
        public ColumnPage decode(byte[] input, int offset, int length) throws IOException {
            DataType dataType = this.columnSpec.getSchemaDataType();
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(input, offset, length));
            ColumnPage resultPage = ColumnPage.newPage(new ColumnPageEncoderMeta(this.columnSpec, dataType, this.compressorName), this.pageSize);
            if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.BYTE) {
                this.decodeBytePage(in, resultPage);
            } else if (dataType == DataTypes.SHORT) {
                this.decodeShortPage(in, resultPage);
            } else if (dataType == DataTypes.INT) {
                this.decodeIntPage(in, resultPage);
            } else if (dataType == DataTypes.LONG) {
                this.decodeLongPage(in, resultPage);
            } else {
                throw new RuntimeException("unsupported datatype:" + dataType);
            }
            return resultPage;
        }

        @Override
        public void decodeAndFillVector(byte[] input, int offset, int length, ColumnVectorInfo vectorInfo, BitSet nullBits, boolean isLVEncoded, int pageSize, ReusableDataBuffer reusableDataBuffer) {
            throw new UnsupportedOperationException("Not supposed to be called here");
        }

        @Override
        public ColumnPage decode(byte[] input, int offset, int length, boolean isLVEncoded) throws IOException {
            return this.decode(input, offset, length);
        }

        private void decodeBytePage(DataInputStream in, ColumnPage decodedPage) throws IOException {
            int rowId = 0;
            do {
                short runLength = in.readShort();
                int count = runLength & Short.MAX_VALUE;
                if (runLength < 0) {
                    for (int i = 0; i < count; ++i) {
                        decodedPage.putByte(rowId++, in.readByte());
                    }
                } else {
                    byte value = in.readByte();
                    for (int i = 0; i < count; ++i) {
                        decodedPage.putByte(rowId++, value);
                    }
                }
            } while (in.available() > 0);
        }

        private void decodeShortPage(DataInputStream in, ColumnPage decodedPage) throws IOException {
            int rowId = 0;
            do {
                short runLength = in.readShort();
                int count = runLength & Short.MAX_VALUE;
                if (runLength < 0) {
                    for (int i = 0; i < count; ++i) {
                        decodedPage.putShort(rowId++, in.readShort());
                    }
                } else {
                    short value = in.readShort();
                    for (int i = 0; i < count; ++i) {
                        decodedPage.putShort(rowId++, value);
                    }
                }
            } while (in.available() > 0);
        }

        private void decodeIntPage(DataInputStream in, ColumnPage decodedPage) throws IOException {
            int rowId = 0;
            do {
                short runLength = in.readShort();
                int count = runLength & Short.MAX_VALUE;
                if (runLength < 0) {
                    for (int i = 0; i < count; ++i) {
                        decodedPage.putInt(rowId++, in.readInt());
                    }
                } else {
                    int value = in.readInt();
                    for (int i = 0; i < count; ++i) {
                        decodedPage.putInt(rowId++, value);
                    }
                }
            } while (in.available() > 0);
        }

        private void decodeLongPage(DataInputStream in, ColumnPage decodedPage) throws IOException {
            int rowId = 0;
            do {
                short runLength = in.readShort();
                int count = runLength & Short.MAX_VALUE;
                if (runLength < 0) {
                    for (int i = 0; i < count; ++i) {
                        decodedPage.putLong(rowId++, in.readLong());
                    }
                } else {
                    long value = in.readLong();
                    for (int i = 0; i < count; ++i) {
                        decodedPage.putLong(rowId++, value);
                    }
                }
            } while (in.available() > 0);
        }
    }

    private class RLEEncoder
    extends ColumnPageEncoder {
        private RUN_STATE runState = RUN_STATE.INIT;
        private short valueCount = 0;
        private Object lastValue;
        private List<Object> nonRepeatValues = new ArrayList<Object>();
        private DataType dataType;
        private ByteArrayOutputStream bao = new ByteArrayOutputStream();
        private DataOutputStream stream = new DataOutputStream(this.bao);

        private RLEEncoder() {
        }

        @Override
        protected ByteBuffer encodeData(ColumnPage input) throws IOException {
            RLECodec.this.validateDataType(input.getDataType());
            this.dataType = input.getDataType();
            if (this.dataType == DataTypes.BYTE) {
                byte[] bytePage = input.getBytePage();
                for (int i = 0; i < bytePage.length; ++i) {
                    this.putValue(bytePage[i]);
                }
            } else if (this.dataType == DataTypes.SHORT) {
                short[] shortPage = input.getShortPage();
                for (int i = 0; i < shortPage.length; ++i) {
                    this.putValue(shortPage[i]);
                }
            } else if (this.dataType == DataTypes.INT) {
                int[] intPage = input.getIntPage();
                for (int i = 0; i < intPage.length; ++i) {
                    this.putValue(intPage[i]);
                }
            } else if (this.dataType == DataTypes.LONG) {
                long[] longPage = input.getLongPage();
                for (int i = 0; i < longPage.length; ++i) {
                    this.putValue(longPage[i]);
                }
            } else {
                throw new UnsupportedOperationException(input.getDataType() + " does not support RLE encoding");
            }
            return ByteBuffer.wrap(this.collectResult());
        }

        @Override
        protected List<Encoding> getEncodingList() {
            ArrayList<Encoding> encodings = new ArrayList<Encoding>();
            encodings.add(Encoding.RLE_INTEGRAL);
            return encodings;
        }

        @Override
        protected ColumnPageEncoderMeta getEncoderMeta(ColumnPage inputPage) {
            return new RLEEncoderMeta(inputPage.getColumnSpec(), inputPage.getDataType(), inputPage.getPageSize(), inputPage.getStatistics(), inputPage.getColumnCompressorName());
        }

        private void putValue(Object value) throws IOException {
            if (this.runState == RUN_STATE.INIT) {
                this.startNewRun(value);
            } else if (this.lastValue.equals(value)) {
                this.putRepeatValue(value);
            } else {
                this.putNonRepeatValue(value);
            }
        }

        private byte[] collectResult() throws IOException {
            switch (this.runState) {
                case REPEATED_RUN: {
                    this.writeRunLength(this.valueCount);
                    this.writeRunValue(this.lastValue);
                    break;
                }
                case NONREPEATED_RUN: {
                    this.writeRunLength(this.valueCount | 0x8000);
                    for (int i = 0; i < this.valueCount; ++i) {
                        this.writeRunValue(this.nonRepeatValues.get(i));
                    }
                    break;
                }
                default: {
                    assert (this.runState == RUN_STATE.START);
                    this.writeRunLength(1);
                    this.writeRunValue(this.lastValue);
                }
            }
            return this.bao.toByteArray();
        }

        private void writeRunLength(int length) throws IOException {
            this.stream.writeShort(length);
        }

        private void writeRunValue(Object value) throws IOException {
            if (this.dataType == DataTypes.BYTE) {
                this.stream.writeByte(((Byte)value).byteValue());
            } else if (this.dataType == DataTypes.SHORT) {
                this.stream.writeShort(((Short)value).shortValue());
            } else if (this.dataType == DataTypes.INT) {
                this.stream.writeInt((Integer)value);
            } else if (this.dataType == DataTypes.LONG) {
                this.stream.writeLong((Long)value);
            } else {
                throw new RuntimeException("internal error");
            }
        }

        private void startNewRun(Object value) {
            this.runState = RUN_STATE.START;
            this.valueCount = 1;
            this.lastValue = value;
            this.nonRepeatValues.clear();
            this.nonRepeatValues.add(value);
        }

        private void encodeNonRepeatedRun() throws IOException {
            this.writeRunLength(this.valueCount | 0x8000);
            for (int i = 0; i < this.valueCount; ++i) {
                this.writeRunValue(this.nonRepeatValues.get(i));
            }
        }

        private void encodeRepeatedRun() throws IOException {
            this.writeRunLength(this.valueCount);
            this.writeRunValue(this.lastValue);
        }

        private void putRepeatValue(Object value) throws IOException {
            switch (this.runState) {
                case REPEATED_RUN: {
                    this.valueCount = (short)(this.valueCount + 1);
                    break;
                }
                case NONREPEATED_RUN: {
                    this.encodeNonRepeatedRun();
                    this.startNewRun(value);
                    break;
                }
                default: {
                    assert (this.runState == RUN_STATE.START);
                    this.runState = RUN_STATE.REPEATED_RUN;
                    this.valueCount = (short)(this.valueCount + 1);
                }
            }
        }

        private void putNonRepeatValue(Object value) throws IOException {
            switch (this.runState) {
                case NONREPEATED_RUN: {
                    this.nonRepeatValues.add(value);
                    this.lastValue = value;
                    this.valueCount = (short)(this.valueCount + 1);
                    break;
                }
                case REPEATED_RUN: {
                    this.encodeRepeatedRun();
                    this.startNewRun(value);
                    break;
                }
                default: {
                    assert (this.runState == RUN_STATE.START);
                    this.runState = RUN_STATE.NONREPEATED_RUN;
                    this.nonRepeatValues.add(value);
                    this.lastValue = value;
                    this.valueCount = (short)(this.valueCount + 1);
                }
            }
        }
    }

    static enum RUN_STATE {
        INIT,
        START,
        REPEATED_RUN,
        NONREPEATED_RUN;

    }
}

