/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.statistics;

import java.math.BigDecimal;
import org.apache.carbondata.core.datastore.page.statistics.ColumnPageStatsCollector;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.util.ByteUtil;

public class KeyPageStatsCollector
implements ColumnPageStatsCollector {
    private DataType dataType;
    private byte[] min;
    private byte[] max;

    public static KeyPageStatsCollector newInstance(DataType dataType) {
        return new KeyPageStatsCollector(dataType);
    }

    private KeyPageStatsCollector(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public void updateNull(int rowId) {
    }

    @Override
    public void update(byte value) {
    }

    @Override
    public void update(short value) {
    }

    @Override
    public void update(int value) {
    }

    @Override
    public void update(long value) {
    }

    @Override
    public void update(double value) {
    }

    @Override
    public void update(float value) {
    }

    @Override
    public void update(BigDecimal value) {
    }

    @Override
    public void update(byte[] value) {
        if (null == this.min) {
            this.min = value;
        }
        if (null == this.max) {
            this.max = value;
        }
        if (ByteUtil.UnsafeComparer.INSTANCE.compareTo(this.min, value) > 0) {
            this.min = value;
        }
        if (ByteUtil.UnsafeComparer.INSTANCE.compareTo(this.max, value) < 0) {
            this.max = value;
        }
    }

    @Override
    public SimpleStatsResult getPageStats() {
        return new SimpleStatsResult(){

            @Override
            public Object getMin() {
                return KeyPageStatsCollector.this.min;
            }

            @Override
            public Object getMax() {
                return KeyPageStatsCollector.this.max;
            }

            @Override
            public int getDecimalCount() {
                return 0;
            }

            @Override
            public DataType getDataType() {
                return KeyPageStatsCollector.this.dataType;
            }

            @Override
            public boolean writeMinMax() {
                return true;
            }
        };
    }
}

