/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.statistics;

import java.math.BigDecimal;
import org.apache.carbondata.core.datastore.page.encoding.ColumnPageEncoderMeta;
import org.apache.carbondata.core.datastore.page.encoding.bool.BooleanConvert;
import org.apache.carbondata.core.datastore.page.statistics.ColumnPageStatsCollector;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.metadata.ValueEncoderMeta;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;

public class PrimitivePageStatsCollector
implements ColumnPageStatsCollector,
SimpleStatsResult {
    private static final String ZERO_STRING = "0";
    private DataType dataType;
    private byte minByte;
    private byte maxByte;
    private short minShort;
    private short maxShort;
    private int minInt;
    private int maxInt;
    private long minLong;
    private long maxLong;
    private double minDouble;
    private double maxDouble;
    private float minFloat;
    private float maxFloat;
    private BigDecimal minDecimal;
    private BigDecimal maxDecimal;
    private int decimal;
    private int decimalCountForComplexPrimitive;
    private boolean isFirst = true;
    private BigDecimal zeroDecimal;

    public static PrimitivePageStatsCollector newInstance(DataType dataType) {
        return new PrimitivePageStatsCollector(dataType);
    }

    public static PrimitivePageStatsCollector newInstance(ColumnPageEncoderMeta meta) {
        PrimitivePageStatsCollector instance = new PrimitivePageStatsCollector(meta.getSchemaDataType());
        DataType dataType = meta.getSchemaDataType();
        if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.BYTE) {
            instance.minByte = (Byte)meta.getMinValue();
            instance.maxByte = (Byte)meta.getMaxValue();
        } else if (dataType == DataTypes.SHORT) {
            instance.minShort = (Short)meta.getMinValue();
            instance.maxShort = (Short)meta.getMaxValue();
        } else if (dataType == DataTypes.INT) {
            instance.minInt = (Integer)meta.getMinValue();
            instance.maxInt = (Integer)meta.getMaxValue();
        } else if (dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
            instance.minLong = (Long)meta.getMinValue();
            instance.maxLong = (Long)meta.getMaxValue();
        } else if (dataType == DataTypes.DOUBLE) {
            instance.minDouble = (Double)meta.getMinValue();
            instance.maxDouble = (Double)meta.getMaxValue();
            instance.decimal = meta.getDecimal();
        } else if (dataType == DataTypes.FLOAT) {
            instance.minFloat = ((Float)meta.getMinValue()).floatValue();
            instance.maxFloat = ((Float)meta.getMaxValue()).floatValue();
            instance.decimal = meta.getDecimal();
        } else if (DataTypes.isDecimal(dataType)) {
            instance.minDecimal = (BigDecimal)meta.getMinValue();
            instance.maxDecimal = (BigDecimal)meta.getMaxValue();
            instance.decimal = meta.getDecimal();
        } else {
            throw new UnsupportedOperationException("unsupported data type for stats collection: " + meta.getSchemaDataType());
        }
        return instance;
    }

    public static PrimitivePageStatsCollector newInstance(ValueEncoderMeta meta) {
        PrimitivePageStatsCollector instance = new PrimitivePageStatsCollector(DataType.getDataType(meta.getType()));
        DataType dataType = DataType.getDataType(meta.getType());
        if (dataType == DataTypes.BOOLEAN || dataType == DataTypes.BYTE) {
            instance.minByte = (Byte)meta.getMinValue();
            instance.maxByte = (Byte)meta.getMaxValue();
        } else if (dataType == DataTypes.SHORT) {
            instance.minShort = (Short)meta.getMinValue();
            instance.maxShort = (Short)meta.getMaxValue();
        } else if (dataType == DataTypes.INT) {
            instance.minInt = (Integer)meta.getMinValue();
            instance.maxInt = (Integer)meta.getMaxValue();
        } else if (dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
            instance.minLong = (Long)meta.getMinValue();
            instance.maxLong = (Long)meta.getMaxValue();
        } else if (dataType == DataTypes.DOUBLE) {
            instance.minDouble = (Double)meta.getMinValue();
            instance.maxDouble = (Double)meta.getMaxValue();
            instance.decimal = meta.getDecimal();
        } else if (dataType == DataTypes.FLOAT) {
            instance.minFloat = ((Float)meta.getMinValue()).floatValue();
            instance.maxFloat = ((Float)meta.getMaxValue()).floatValue();
            instance.decimal = meta.getDecimal();
        } else if (DataTypes.isDecimal(dataType)) {
            instance.minDecimal = (BigDecimal)meta.getMinValue();
            instance.maxDecimal = (BigDecimal)meta.getMaxValue();
            instance.decimal = meta.getDecimal();
        } else {
            throw new UnsupportedOperationException("unsupported data type for Stats collection: " + meta.getType());
        }
        return instance;
    }

    private PrimitivePageStatsCollector(DataType dataType) {
        this.dataType = dataType;
        if (dataType == DataTypes.BOOLEAN) {
            this.minByte = 1;
            this.maxByte = 0;
        } else if (dataType == DataTypes.BYTE) {
            this.minByte = (byte)127;
            this.maxByte = (byte)-128;
        } else if (dataType == DataTypes.SHORT) {
            this.minShort = Short.MAX_VALUE;
            this.maxShort = Short.MIN_VALUE;
        } else if (dataType == DataTypes.INT) {
            this.minInt = Integer.MAX_VALUE;
            this.maxInt = Integer.MIN_VALUE;
        } else if (dataType == DataTypes.LONG || dataType == DataTypes.TIMESTAMP) {
            this.minLong = Long.MAX_VALUE;
            this.maxLong = Long.MIN_VALUE;
        } else if (dataType == DataTypes.DOUBLE) {
            this.minDouble = Double.POSITIVE_INFINITY;
            this.maxDouble = Double.NEGATIVE_INFINITY;
            this.decimal = 0;
        } else if (dataType == DataTypes.FLOAT) {
            this.minFloat = Float.MAX_VALUE;
            this.maxFloat = Float.MIN_VALUE;
            this.decimal = 0;
        } else if (DataTypes.isDecimal(dataType)) {
            this.zeroDecimal = BigDecimal.ZERO;
            this.decimal = 0;
        } else {
            throw new UnsupportedOperationException("unsupported data type for Stats collection: " + dataType);
        }
    }

    @Override
    public void updateNull(int rowId) {
        long value = 0L;
        if (this.dataType == DataTypes.BOOLEAN || this.dataType == DataTypes.BYTE) {
            this.update((byte)value);
        } else if (this.dataType == DataTypes.SHORT) {
            this.update((short)value);
        } else if (this.dataType == DataTypes.INT) {
            this.update((int)value);
        } else if (this.dataType == DataTypes.LONG || this.dataType == DataTypes.TIMESTAMP) {
            this.update(value);
        } else if (this.dataType == DataTypes.DOUBLE) {
            this.update(0.0);
        } else if (this.dataType == DataTypes.FLOAT) {
            this.update(0.0f);
        } else if (DataTypes.isDecimal(this.dataType)) {
            if (this.isFirst) {
                this.maxDecimal = this.zeroDecimal;
                this.minDecimal = this.zeroDecimal;
                this.isFirst = false;
            } else {
                this.maxDecimal = this.maxDecimal.compareTo(this.zeroDecimal) > 0 ? this.maxDecimal : this.zeroDecimal;
                this.minDecimal = this.minDecimal.compareTo(this.zeroDecimal) < 0 ? this.minDecimal : this.zeroDecimal;
            }
        } else {
            throw new UnsupportedOperationException("unsupported data type for Stats collection: " + this.dataType);
        }
    }

    @Override
    public void update(byte value) {
        if (this.minByte > value) {
            this.minByte = value;
        }
        if (this.maxByte < value) {
            this.maxByte = value;
        }
    }

    @Override
    public void update(short value) {
        if (this.minShort > value) {
            this.minShort = value;
        }
        if (this.maxShort < value) {
            this.maxShort = value;
        }
    }

    @Override
    public void update(int value) {
        if (this.minInt > value) {
            this.minInt = value;
        }
        if (this.maxInt < value) {
            this.maxInt = value;
        }
    }

    @Override
    public void update(long value) {
        if (this.minLong > value) {
            this.minLong = value;
        }
        if (this.maxLong < value) {
            this.maxLong = value;
        }
    }

    private int getDecimalCount(double value) {
        int decimalPlaces;
        block3: {
            decimalPlaces = 0;
            try {
                String str;
                BigDecimal decimalValue = BigDecimal.valueOf(value);
                decimalPlaces = decimalValue.scale();
                if (decimalPlaces == 1 && (str = decimalValue.toString()).charAt(str.length() - 1) == '0') {
                    decimalPlaces = 0;
                }
            }
            catch (NumberFormatException e) {
                if (Double.isInfinite(value)) break block3;
                throw e;
            }
        }
        return decimalPlaces;
    }

    private int getDecimalCount(float value) {
        return this.getDecimalCount((double)value);
    }

    @Override
    public void update(double value) {
        if (this.minDouble > value) {
            this.minDouble = value;
        }
        if (this.maxDouble < value) {
            this.maxDouble = value;
        }
        if (this.decimal >= 0) {
            int decimalCount;
            this.decimalCountForComplexPrimitive = decimalCount = this.getDecimalCount(value);
            if (decimalCount > 5) {
                this.decimal = -1;
            } else if (decimalCount > this.decimal) {
                this.decimal = decimalCount;
            }
        }
    }

    @Override
    public void update(float value) {
        if (this.minFloat > value) {
            this.minFloat = value;
        }
        if (this.maxFloat < value) {
            this.maxFloat = value;
        }
        if (this.decimal >= 0) {
            int decimalCount;
            this.decimalCountForComplexPrimitive = decimalCount = this.getDecimalCount(value);
            if (decimalCount > 5) {
                this.decimal = -1;
            } else if (decimalCount > this.decimal) {
                this.decimal = decimalCount;
            }
        }
    }

    public int getDecimalForComplexPrimitive() {
        this.decimal = this.decimalCountForComplexPrimitive;
        return this.decimalCountForComplexPrimitive;
    }

    @Override
    public void update(BigDecimal decimalValue) {
        if (this.isFirst) {
            this.maxDecimal = decimalValue;
            this.minDecimal = decimalValue;
            this.isFirst = false;
        } else {
            this.maxDecimal = decimalValue.compareTo(this.maxDecimal) > 0 ? decimalValue : this.maxDecimal;
            this.minDecimal = decimalValue.compareTo(this.minDecimal) < 0 ? decimalValue : this.minDecimal;
        }
    }

    @Override
    public void update(byte[] value) {
    }

    @Override
    public SimpleStatsResult getPageStats() {
        return this;
    }

    public String toString() {
        if (this.dataType == DataTypes.BOOLEAN) {
            return String.format("min: %s, max: %s ", BooleanConvert.byte2Boolean(this.minByte), BooleanConvert.byte2Boolean(this.minByte));
        }
        if (this.dataType == DataTypes.BYTE) {
            return String.format("min: %s, max: %s, decimal: %s ", this.minByte, this.maxByte, this.decimal);
        }
        if (this.dataType == DataTypes.SHORT) {
            return String.format("min: %s, max: %s, decimal: %s ", this.minShort, this.maxShort, this.decimal);
        }
        if (this.dataType == DataTypes.INT) {
            return String.format("min: %s, max: %s, decimal: %s ", this.minInt, this.maxInt, this.decimal);
        }
        if (this.dataType == DataTypes.LONG) {
            return String.format("min: %s, max: %s, decimal: %s ", this.minLong, this.maxLong, this.decimal);
        }
        if (this.dataType == DataTypes.DOUBLE) {
            return String.format("min: %s, max: %s, decimal: %s ", this.minDouble, this.maxDouble, this.decimal);
        }
        if (this.dataType == DataTypes.FLOAT) {
            return String.format("min: %s, max: %s, decimal: %s ", Float.valueOf(this.minFloat), Float.valueOf(this.maxFloat), this.decimal);
        }
        return super.toString();
    }

    @Override
    public Object getMin() {
        if (this.dataType == DataTypes.BOOLEAN || this.dataType == DataTypes.BYTE) {
            return this.minByte;
        }
        if (this.dataType == DataTypes.SHORT) {
            return this.minShort;
        }
        if (this.dataType == DataTypes.INT) {
            return this.minInt;
        }
        if (this.dataType == DataTypes.LONG || this.dataType == DataTypes.TIMESTAMP) {
            return this.minLong;
        }
        if (this.dataType == DataTypes.DOUBLE) {
            return this.minDouble;
        }
        if (this.dataType == DataTypes.FLOAT) {
            return Float.valueOf(this.minFloat);
        }
        if (DataTypes.isDecimal(this.dataType)) {
            return this.minDecimal;
        }
        return null;
    }

    @Override
    public Object getMax() {
        if (this.dataType == DataTypes.BOOLEAN || this.dataType == DataTypes.BYTE) {
            return this.maxByte;
        }
        if (this.dataType == DataTypes.SHORT) {
            return this.maxShort;
        }
        if (this.dataType == DataTypes.INT) {
            return this.maxInt;
        }
        if (this.dataType == DataTypes.LONG || this.dataType == DataTypes.TIMESTAMP) {
            return this.maxLong;
        }
        if (this.dataType == DataTypes.DOUBLE) {
            return this.maxDouble;
        }
        if (this.dataType == DataTypes.FLOAT) {
            return Float.valueOf(this.maxFloat);
        }
        if (DataTypes.isDecimal(this.dataType)) {
            return this.maxDecimal;
        }
        return null;
    }

    @Override
    public int getDecimalCount() {
        return this.decimal;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public boolean writeMinMax() {
        return true;
    }
}

