/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.statistics;

import java.math.BigDecimal;
import org.apache.carbondata.core.datastore.page.statistics.ColumnPageStatsCollector;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonProperties;

public class StringStatsCollector
implements ColumnPageStatsCollector {
    protected static final int allowedMinMaxByteLimit = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.minmax.allowed.byte.count"));
    private byte[] min;
    private byte[] max;
    private boolean ignoreWritingMinMax;

    public static StringStatsCollector newInstance() {
        return new StringStatsCollector();
    }

    @Override
    public void updateNull(int rowId) {
    }

    @Override
    public void update(byte value) {
    }

    @Override
    public void update(short value) {
    }

    @Override
    public void update(int value) {
    }

    @Override
    public void update(long value) {
    }

    @Override
    public void update(double value) {
    }

    @Override
    public void update(float value) {
    }

    @Override
    public void update(BigDecimal value) {
    }

    @Override
    public void update(byte[] value) {
        if (this.isIgnoreMinMaxFlagSet(value)) {
            return;
        }
        if (this.min == null) {
            this.min = value;
        }
        if (null == this.max) {
            this.max = value;
        }
        if (ByteUtil.UnsafeComparer.INSTANCE.compareTo(this.min, value) > 0) {
            this.min = value;
        }
        if (ByteUtil.UnsafeComparer.INSTANCE.compareTo(this.max, value) < 0) {
            this.max = value;
        }
    }

    private boolean isIgnoreMinMaxFlagSet(byte[] value) {
        if (!this.ignoreWritingMinMax && null != value && value.length > allowedMinMaxByteLimit) {
            this.ignoreWritingMinMax = true;
        }
        return this.ignoreWritingMinMax;
    }

    @Override
    public SimpleStatsResult getPageStats() {
        return new SimpleStatsResult(){

            @Override
            public Object getMin() {
                if (null == StringStatsCollector.this.min || StringStatsCollector.this.ignoreWritingMinMax) {
                    StringStatsCollector.access$002(StringStatsCollector.this, new byte[0]);
                }
                return StringStatsCollector.this.min;
            }

            @Override
            public Object getMax() {
                if (null == StringStatsCollector.this.max || StringStatsCollector.this.ignoreWritingMinMax) {
                    StringStatsCollector.access$202(StringStatsCollector.this, new byte[0]);
                }
                return StringStatsCollector.this.max;
            }

            @Override
            public int getDecimalCount() {
                return 0;
            }

            @Override
            public DataType getDataType() {
                return DataTypes.STRING;
            }

            @Override
            public boolean writeMinMax() {
                return !StringStatsCollector.this.ignoreWritingMinMax;
            }
        };
    }

    static /* synthetic */ byte[] access$002(StringStatsCollector x0, byte[] x1) {
        x0.min = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$202(StringStatsCollector x0, byte[] x1) {
        x0.max = x1;
        return x1;
    }
}

