/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.page.statistics;

import org.apache.carbondata.core.datastore.page.encoding.EncodedColumnPage;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;

public class TablePageStatistics {
    private byte[][] dimensionMinValue;
    private byte[][] dimensionMaxValue;
    private byte[][] measureMinValue;
    private byte[][] measureMaxValue;
    private boolean[] writeMinMaxForDimensions;

    public TablePageStatistics(EncodedColumnPage[] dimensions, EncodedColumnPage[] measures) {
        int numDimensionsExpanded = dimensions.length;
        int numMeasures = measures.length;
        this.dimensionMinValue = new byte[numDimensionsExpanded][];
        this.dimensionMaxValue = new byte[numDimensionsExpanded][];
        this.measureMinValue = new byte[numMeasures][];
        this.measureMaxValue = new byte[numMeasures][];
        this.writeMinMaxForDimensions = new boolean[numDimensionsExpanded];
        this.updateDimensionMinMax(dimensions);
        this.updateMeasureMinMax(measures);
    }

    private void updateDimensionMinMax(EncodedColumnPage[] dimensions) {
        for (int i = 0; i < dimensions.length; ++i) {
            SimpleStatsResult stats = dimensions[i].getStats();
            Object min = stats.getMin();
            Object max = stats.getMax();
            if (CarbonUtil.isEncodedWithMeta(dimensions[i].getPageMetadata().getEncoders())) {
                this.dimensionMaxValue[i] = DataTypeUtil.getMinMaxBytesBasedOnDataTypeForNoDictionaryColumn(max, stats.getDataType());
                this.dimensionMinValue[i] = DataTypeUtil.getMinMaxBytesBasedOnDataTypeForNoDictionaryColumn(min, stats.getDataType());
            } else {
                this.dimensionMaxValue[i] = CarbonUtil.getValueAsBytes(stats.getDataType(), max);
                this.dimensionMinValue[i] = CarbonUtil.getValueAsBytes(stats.getDataType(), min);
            }
            this.writeMinMaxForDimensions[i] = stats.writeMinMax();
        }
    }

    private void updateMeasureMinMax(EncodedColumnPage[] measures) {
        for (int i = 0; i < measures.length; ++i) {
            SimpleStatsResult stats = measures[i].getStats();
            this.measureMaxValue[i] = CarbonUtil.getValueAsBytes(stats.getDataType(), stats.getMax());
            this.measureMinValue[i] = CarbonUtil.getValueAsBytes(stats.getDataType(), stats.getMin());
        }
    }

    public byte[][] getDimensionMinValue() {
        return this.dimensionMinValue;
    }

    public byte[][] getDimensionMaxValue() {
        return this.dimensionMaxValue;
    }

    public byte[][] getMeasureMinValue() {
        return this.measureMinValue;
    }

    public byte[][] getMeasureMaxValue() {
        return this.measureMaxValue;
    }

    public boolean[] getWriteMinMaxForDimensions() {
        return this.writeMinMaxForDimensions;
    }
}

