/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.datastore.row;

import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.scan.wrappers.ByteArrayWrapper;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.DataTypeUtil;

public class WriteStepRowUtil {
    public static final int DICTIONARY_DIMENSION = 0;
    public static final int NO_DICTIONARY_AND_COMPLEX = 1;
    public static final int MEASURE = 2;

    public static CarbonRow fromColumnCategory(int[] dictDimensions, Object[] noDictAndComplex, Object[] measures) {
        Object[] row = new Object[]{dictDimensions, noDictAndComplex, measures};
        return new CarbonRow(row);
    }

    public static CarbonRow fromMergerRow(Object[] row, SegmentProperties segmentProperties, CarbonColumn[] noDicAndComplexColumns) {
        Object[] converted = new Object[3];
        byte[] mdk = ((ByteArrayWrapper)row[0]).getDictionaryKey();
        int numDict = mdk.length / ByteUtil.dateBytesSize();
        int[] dictDimensions = new int[numDict];
        for (int i = 0; i < numDict; ++i) {
            dictDimensions[i] = ByteUtil.convertBytesToInt(mdk, i * ByteUtil.dateBytesSize());
        }
        converted[0] = dictDimensions;
        Object[] noDictAndComplexKeys = new Object[segmentProperties.getNumberOfNoDictionaryDimension() + segmentProperties.getComplexDimensions().size()];
        byte[][] noDictionaryKeys = ((ByteArrayWrapper)row[0]).getNoDictionaryKeys();
        for (int i = 0; i < noDictionaryKeys.length; ++i) {
            if (DataTypeUtil.isPrimitiveColumn(noDicAndComplexColumns[i].getDataType())) {
                noDictAndComplexKeys[i] = DataTypeUtil.getDataBasedOnDataTypeForNoDictionaryColumn(noDictionaryKeys[i], noDicAndComplexColumns[i].getDataType());
                if (null == noDictAndComplexKeys[i] || noDicAndComplexColumns[i].getDataType() != DataTypes.TIMESTAMP) continue;
                noDictAndComplexKeys[i] = (Long)noDictAndComplexKeys[i] / 1000L;
                continue;
            }
            noDictAndComplexKeys[i] = noDictionaryKeys[i];
        }
        byte[][] complexKeys = ((ByteArrayWrapper)row[0]).getComplexTypesKeys();
        int j = 0;
        for (int i = segmentProperties.getNumberOfNoDictionaryDimension(); i < segmentProperties.getNumberOfNoDictionaryDimension() + segmentProperties.getComplexDimensions().size(); ++i) {
            noDictAndComplexKeys[i] = complexKeys[j++];
        }
        converted[1] = noDictAndComplexKeys;
        int measureCount = row.length - 1;
        Object[] measures = new Object[measureCount];
        System.arraycopy(row, 1, measures, 0, measureCount);
        converted[2] = measures;
        return new CarbonRow(converted);
    }

    public static int[] getDictDimension(CarbonRow row) {
        return (int[])row.getData()[0];
    }

    public static Object[] getNoDictAndComplexDimension(CarbonRow row) {
        return (Object[])row.getData()[1];
    }

    public static Object[] getMeasure(CarbonRow row) {
        return (Object[])row.getData()[2];
    }
}

