/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.fileoperations;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperations;
import org.apache.carbondata.core.fileoperations.FileWriteOperation;
import org.apache.carbondata.core.util.CarbonUtil;

class AtomicFileOperationS3Impl
implements AtomicFileOperations {
    private String filePath;
    private DataOutputStream dataOutStream;

    AtomicFileOperationS3Impl(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public DataInputStream openForRead() throws IOException {
        return FileFactory.getDataInputStream(this.filePath);
    }

    @Override
    public void close() throws IOException {
        if (null != this.dataOutStream) {
            CarbonUtil.closeStream(this.dataOutStream);
        }
    }

    @Override
    public DataOutputStream openForWrite(FileWriteOperation operation) throws IOException {
        this.filePath = this.filePath.replace("\\", "/");
        this.dataOutStream = FileFactory.getDataOutputStream(this.filePath);
        return this.dataOutStream;
    }

    @Override
    public void setFailed() {
    }
}

