/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.fileoperations;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.fileoperations.AtomicFileOperations;
import org.apache.carbondata.core.fileoperations.FileWriteOperation;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.log4j.Logger;

class AtomicFileOperationsImpl
implements AtomicFileOperations {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)AtomicFileOperationsImpl.class.getName());
    private String filePath;
    private String tempWriteFilePath;
    private DataOutputStream dataOutStream;
    private boolean setFailed;

    AtomicFileOperationsImpl(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public DataInputStream openForRead() throws IOException {
        return FileFactory.getDataInputStream(this.filePath);
    }

    @Override
    public DataOutputStream openForWrite(FileWriteOperation operation) throws IOException {
        this.filePath = this.filePath.replace("\\", "/");
        this.tempWriteFilePath = this.filePath + ".write";
        if (FileFactory.isFileExist(this.tempWriteFilePath)) {
            FileFactory.getCarbonFile(this.tempWriteFilePath).delete();
        }
        FileFactory.createNewFile(this.tempWriteFilePath);
        this.dataOutStream = FileFactory.getDataOutputStream(this.tempWriteFilePath);
        return this.dataOutStream;
    }

    @Override
    public void close() throws IOException {
        if (null != this.dataOutStream) {
            CarbonUtil.closeStream(this.dataOutStream);
            CarbonFile tempFile = FileFactory.getCarbonFile(this.tempWriteFilePath);
            if (!this.setFailed) {
                if (!tempFile.renameForce(this.filePath)) {
                    throw new IOException("temporary file renaming failed, src=" + tempFile.getPath() + ", dest=" + this.filePath);
                }
            } else {
                LOGGER.warn((Object)("The temporary file renaming skipped due to I/O error, deleting file " + this.tempWriteFilePath));
                tempFile.delete();
            }
        }
    }

    @Override
    public void setFailed() {
        this.setFailed = true;
    }
}

