/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.index.IndexLevel;
import org.apache.carbondata.core.index.IndexMeta;
import org.apache.carbondata.core.index.IndexStoreManager;
import org.apache.carbondata.core.index.TableIndex;
import org.apache.carbondata.core.index.dev.expr.AndIndexExprWrapper;
import org.apache.carbondata.core.index.dev.expr.IndexExprWrapper;
import org.apache.carbondata.core.index.dev.expr.IndexExprWrapperImpl;
import org.apache.carbondata.core.index.dev.expr.OrIndexExprWrapper;
import org.apache.carbondata.core.index.status.IndexStatus;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.MatchExpression;
import org.apache.carbondata.core.scan.expression.logical.AndExpression;
import org.apache.carbondata.core.scan.expression.logical.OrExpression;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.scan.filter.resolver.resolverinfo.TrueConditionalResolverImpl;

@InterfaceAudience.Internal
public class IndexChooser {
    private CarbonTable carbonTable;
    private List<TableIndex> cgIndexes;
    private List<TableIndex> fgIndexes;

    public IndexChooser(CarbonTable carbonTable) throws IOException {
        this.carbonTable = carbonTable;
        List<TableIndex> visibleIndexes = carbonTable.getAllVisibleIndexes();
        this.cgIndexes = new ArrayList<TableIndex>(visibleIndexes.size());
        this.fgIndexes = new ArrayList<TableIndex>(visibleIndexes.size());
        for (TableIndex visibleIndex : visibleIndexes) {
            if (visibleIndex.getIndexSchema().getProperties().get("index_status") == null || !visibleIndex.getIndexSchema().getProperties().get("index_status").equalsIgnoreCase(IndexStatus.ENABLED.name())) continue;
            IndexLevel level = visibleIndex.getIndexFactory().getIndexLevel();
            if (level == IndexLevel.CG) {
                this.cgIndexes.add(visibleIndex);
                continue;
            }
            this.fgIndexes.add(visibleIndex);
        }
    }

    public IndexExprWrapper choose(FilterResolverIntf filter) {
        if (filter != null) {
            Expression expression = filter.getFilterExpression();
            ExpressionTuple tuple = this.selectIndex(expression, this.fgIndexes, filter);
            if (tuple.indexExprWrapper == null) {
                tuple = this.selectIndex(expression, this.cgIndexes, filter);
            }
            if (tuple.indexExprWrapper != null) {
                return tuple.indexExprWrapper;
            }
        }
        return new IndexExprWrapperImpl(IndexStoreManager.getInstance().getDefaultIndex(this.carbonTable), filter);
    }

    public IndexExprWrapper chooseFGIndex(FilterResolverIntf resolverIntf) {
        return this.chooseIndex(IndexLevel.FG, resolverIntf);
    }

    public IndexExprWrapper chooseCGIndex(FilterResolverIntf resolverIntf) {
        return this.chooseIndex(IndexLevel.CG, resolverIntf);
    }

    IndexExprWrapper chooseIndex(IndexLevel level, FilterResolverIntf resolverIntf) {
        if (resolverIntf != null) {
            List<TableIndex> indexes;
            Expression expression = resolverIntf.getFilterExpression();
            List<TableIndex> list = indexes = level == IndexLevel.CG ? this.cgIndexes : this.fgIndexes;
            if (indexes.size() > 0) {
                ExpressionTuple tuple = this.selectIndex(expression, indexes, resolverIntf);
                if (tuple.indexExprWrapper != null) {
                    return tuple.indexExprWrapper;
                }
            }
        }
        return null;
    }

    public static IndexExprWrapper getDefaultIndex(CarbonTable carbonTable, FilterResolverIntf resolverIntf) {
        return new IndexExprWrapperImpl(IndexStoreManager.getInstance().getDefaultIndex(carbonTable), resolverIntf);
    }

    private ExpressionTuple selectIndex(Expression expression, List<TableIndex> allIndex, FilterResolverIntf filterResolverIntf) {
        switch (expression.getFilterExpressionType()) {
            case AND: {
                if (!(expression instanceof AndExpression)) break;
                AndExpression andExpression = (AndExpression)expression;
                ExpressionTuple left = this.selectIndex(andExpression.getLeft(), allIndex, filterResolverIntf.getLeft());
                ExpressionTuple right = this.selectIndex(andExpression.getRight(), allIndex, filterResolverIntf.getRight());
                HashSet<ExpressionType> filterExpressionTypes = new HashSet<ExpressionType>();
                if (left.indexExprWrapper != null && right.indexExprWrapper != null) {
                    filterExpressionTypes.addAll(left.filterExpressionTypes);
                    filterExpressionTypes.addAll(right.filterExpressionTypes);
                    ArrayList<ColumnExpression> columnExpressions = new ArrayList<ColumnExpression>();
                    columnExpressions.addAll(left.columnExpressions);
                    columnExpressions.addAll(right.columnExpressions);
                    TableIndex index = this.chooseIndex(allIndex, columnExpressions, filterExpressionTypes);
                    TrueConditionalResolverImpl resolver = new TrueConditionalResolverImpl(new AndExpression(left.expression, right.expression), false, true);
                    if (index != null) {
                        ExpressionTuple tuple = new ExpressionTuple();
                        tuple.columnExpressions = columnExpressions;
                        tuple.indexExprWrapper = new IndexExprWrapperImpl(index, resolver);
                        tuple.expression = resolver.getFilterExpression();
                        return tuple;
                    }
                    ExpressionTuple tuple = new ExpressionTuple();
                    tuple.columnExpressions = columnExpressions;
                    tuple.indexExprWrapper = new AndIndexExprWrapper(left.indexExprWrapper, right.indexExprWrapper, resolver);
                    tuple.expression = resolver.getFilterExpression();
                    return tuple;
                }
                if (left.indexExprWrapper != null) {
                    return left;
                }
                if (right.indexExprWrapper != null) {
                    return right;
                }
                return left;
            }
            case OR: {
                if (!(expression instanceof OrExpression)) break;
                OrExpression orExpression = (OrExpression)expression;
                ExpressionTuple left = this.selectIndex(orExpression.getLeft(), allIndex, filterResolverIntf.getLeft());
                ExpressionTuple right = this.selectIndex(orExpression.getRight(), allIndex, filterResolverIntf.getRight());
                if (left.indexExprWrapper != null && right.indexExprWrapper != null) {
                    TrueConditionalResolverImpl resolver = new TrueConditionalResolverImpl(new OrExpression(left.expression, right.expression), false, true);
                    ArrayList<ColumnExpression> columnExpressions = new ArrayList<ColumnExpression>();
                    columnExpressions.addAll(left.columnExpressions);
                    columnExpressions.addAll(right.columnExpressions);
                    ExpressionTuple tuple = new ExpressionTuple();
                    tuple.columnExpressions = columnExpressions;
                    tuple.indexExprWrapper = new OrIndexExprWrapper(left.indexExprWrapper, right.indexExprWrapper, resolver);
                    tuple.expression = resolver.getFilterExpression();
                    return tuple;
                }
                left.indexExprWrapper = null;
                return left;
            }
            default: {
                ExpressionTuple tuple = new ExpressionTuple();
                this.extractColumnExpression(expression, tuple.columnExpressions);
                HashSet<ExpressionType> filterExpressionTypes = new HashSet<ExpressionType>();
                filterExpressionTypes.add(expression.getFilterExpressionType());
                TrueConditionalResolverImpl resolver = new TrueConditionalResolverImpl(filterResolverIntf.getFilterExpression(), false, true);
                TableIndex index = this.chooseIndex(allIndex, tuple.columnExpressions, filterExpressionTypes);
                if (index != null) {
                    tuple.indexExprWrapper = new IndexExprWrapperImpl(index, resolver);
                    tuple.filterExpressionTypes.addAll(filterExpressionTypes);
                    tuple.expression = filterResolverIntf.getFilterExpression();
                }
                return tuple;
            }
        }
        return new ExpressionTuple();
    }

    private void extractColumnExpression(Expression expression, List<ColumnExpression> columnExpressions) {
        List<Expression> children;
        if (expression instanceof ColumnExpression) {
            columnExpressions.add((ColumnExpression)expression);
        } else if (expression instanceof MatchExpression) {
            String[] queryItems = expression.getString().split(":", 2);
            if (queryItems.length == 2) {
                columnExpressions.add(new ColumnExpression(queryItems[0], null));
            }
        } else if (expression != null && (children = expression.getChildren()) != null && children.size() > 0) {
            for (Expression exp : children) {
                if (exp == null || exp.getFilterExpressionType() == ExpressionType.UNKNOWN) continue;
                this.extractColumnExpression(exp, columnExpressions);
            }
        }
    }

    private TableIndex chooseIndex(List<TableIndex> allIndex, List<ColumnExpression> columnExpressions, Set<ExpressionType> expressionTypes) {
        ArrayList<IndexTuple> tuples = new ArrayList<IndexTuple>();
        for (TableIndex index : allIndex) {
            if (null == index.getIndexFactory().getMeta() || !this.contains(index.getIndexFactory().getMeta(), columnExpressions, expressionTypes)) continue;
            tuples.add(new IndexTuple(index.getIndexFactory().getMeta().getIndexedColumns().size(), index));
        }
        if (tuples.size() > 0) {
            Collections.sort(tuples);
            return ((IndexTuple)tuples.get((int)0)).index;
        }
        return null;
    }

    private boolean contains(IndexMeta mapMeta, List<ColumnExpression> columnExpressions, Set<ExpressionType> expressionTypes) {
        if (mapMeta.getIndexedColumns().size() == 0 || columnExpressions.size() == 0) {
            return false;
        }
        boolean contains = true;
        for (ColumnExpression expression : columnExpressions) {
            if (mapMeta.getIndexedColumnNames().contains(expression.getColumnName()) && mapMeta.getOptimizedOperation().containsAll(expressionTypes)) continue;
            contains = false;
            break;
        }
        return contains;
    }

    private static class IndexTuple
    implements Comparable<IndexTuple> {
        int order;
        TableIndex index;

        public IndexTuple(int order, TableIndex index) {
            this.order = order;
            this.index = index;
        }

        @Override
        public int compareTo(IndexTuple o) {
            return this.order - o.order;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexTuple that = (IndexTuple)o;
            if (this.order != that.order) {
                return false;
            }
            return this.index != null ? this.index.equals(that.index) : that.index == null;
        }

        public int hashCode() {
            int result = this.order;
            result = 31 * result + (this.index != null ? this.index.hashCode() : 0);
            return result;
        }
    }

    private static class ExpressionTuple {
        IndexExprWrapper indexExprWrapper;
        List<ColumnExpression> columnExpressions = new ArrayList<ColumnExpression>();
        Set<ExpressionType> filterExpressionTypes = new HashSet<ExpressionType>();
        Expression expression;

        private ExpressionTuple() {
        }
    }
}

