/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.index;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.scan.executor.util.RestructureUtil;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.conditional.InExpression;
import org.apache.carbondata.core.scan.expression.logical.AndExpression;
import org.apache.carbondata.core.scan.filter.FilterExpressionProcessor;
import org.apache.carbondata.core.scan.filter.optimizer.RangeFilterOptmizer;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.util.ObjectSerializationUtil;

public class IndexFilter
implements Serializable {
    private static final long serialVersionUID = 6276855832288220240L;
    private transient CarbonTable table;
    private Expression expression;
    private Expression externalSegmentFilter;
    private FilterResolverIntf externalSegmentResolver;
    private FilterResolverIntf resolver;
    private String serializedExpression;
    private SegmentProperties properties;

    public IndexFilter(CarbonTable table, Expression expression) {
        this(table, expression, false);
    }

    public IndexFilter(CarbonTable table, Expression expression, boolean lazyResolve) {
        this.expression = expression;
        this.table = table;
        this.resolve(lazyResolve);
        if (expression != null) {
            this.checkIfFilterColumnExistsInTable();
            this.initializeExternalSegmentFilter();
            try {
                this.serializedExpression = ObjectSerializationUtil.convertObjectToString(expression);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while serializing the exception", e);
            }
        }
    }

    public IndexFilter(FilterResolverIntf resolver) {
        this.resolver = resolver;
    }

    public IndexFilter(SegmentProperties properties, CarbonTable table, Expression expression) {
        this(table, expression);
        this.properties = properties;
        this.resolve(false);
    }

    Expression getNewCopyOfExpression() {
        if (this.expression != null) {
            try {
                return (Expression)ObjectSerializationUtil.convertStringToObject(this.serializedExpression);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while deserializing the exception", e);
            }
        }
        return null;
    }

    public void setTable(CarbonTable table) {
        this.table = table;
    }

    private void initializeExternalSegmentFilter() {
        if (this.expression instanceof AndExpression && ((AndExpression)this.expression).getRight() instanceof InExpression && this.expression.getChildren().get(1).getChildren().get(0) instanceof ColumnExpression && ((ColumnExpression)this.expression.getChildren().get(1).getChildren().get(0)).getColumnName().equalsIgnoreCase("positionId")) {
            this.externalSegmentFilter = ((AndExpression)this.expression).getLeft();
            if (this.externalSegmentFilter != null) {
                this.processFilterExpression(null, null);
                this.externalSegmentResolver = this.resolver != null ? this.resolver.getLeft() : this.resolveFilter().getLeft();
            }
        }
    }

    private Set<String> extractColumnExpressions(Expression expression) {
        HashSet<String> columnExpressionList = new HashSet<String>();
        for (Expression expressions : expression.getChildren()) {
            if (expressions != null && expressions.getChildren() != null && expressions.getChildren().size() > 0) {
                columnExpressionList.addAll(this.extractColumnExpressions(expressions));
                continue;
            }
            if (!(expressions instanceof ColumnExpression)) continue;
            columnExpressionList.add(((ColumnExpression)expressions).getColumnName());
        }
        return columnExpressionList;
    }

    private void checkIfFilterColumnExistsInTable() {
        Set<String> columnExpressionList = this.extractColumnExpressions(this.expression);
        for (String colExpression : columnExpressionList) {
            if (colExpression.equalsIgnoreCase("positionid")) continue;
            boolean exists = false;
            for (CarbonMeasure carbonMeasure : this.table.getAllMeasures()) {
                if (carbonMeasure.isInvisible() || !carbonMeasure.getColName().equalsIgnoreCase(colExpression)) continue;
                exists = true;
            }
            for (CarbonDimension carbonDimension : this.table.getAllDimensions()) {
                if (carbonDimension.isInvisible() || !carbonDimension.getColName().equalsIgnoreCase(colExpression)) continue;
                exists = true;
            }
            if (exists) continue;
            throw new RuntimeException("Column " + colExpression + " not found in table " + this.table.getTableUniqueName());
        }
    }

    public void resolve(boolean lazyResolve) {
        if (this.expression != null) {
            this.processFilterExpression();
            if (!lazyResolve) {
                this.resolver = this.resolveFilter();
            }
        }
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
        this.initializeExternalSegmentFilter();
    }

    public FilterResolverIntf getResolver() {
        if (this.resolver == null) {
            this.resolver = this.resolveFilter();
        }
        return this.resolver;
    }

    public boolean isEmpty() {
        return this.resolver == null;
    }

    public boolean isResolvedOnSegment(SegmentProperties segmentProperties) {
        if (this.expression == null || this.table == null) {
            return true;
        }
        if (!this.table.isTransactionalTable()) {
            return false;
        }
        return !this.table.hasColumnDrift() || !RestructureUtil.hasColumnDriftOnSegment(this.table, segmentProperties);
    }

    Expression getExternalSegmentFilter() {
        if (this.externalSegmentFilter == null) {
            return this.expression;
        }
        return this.externalSegmentFilter;
    }

    public FilterResolverIntf getExternalSegmentResolver() {
        if (this.externalSegmentResolver == null) {
            return this.resolver;
        }
        return this.externalSegmentResolver;
    }

    public void processFilterExpression() {
        this.processFilterExpression(null, null);
    }

    public void processFilterExpression(boolean[] isFilterDimensions, boolean[] isFilterMeasures) {
        this.processFilterExpressionWithoutRange(isFilterDimensions, isFilterMeasures);
        if (null != this.expression) {
            RangeFilterOptmizer rangeFilterOptimizer = new RangeFilterOptmizer(this.expression);
            rangeFilterOptimizer.optimizeFilter();
        }
    }

    public void processFilterExpressionWithoutRange(boolean[] isFilterDimensions, boolean[] isFilterMeasures) {
        QueryModel.FilterProcessVO processVO = this.properties != null ? new QueryModel.FilterProcessVO(this.properties.getDimensions(), this.properties.getMeasures(), new ArrayList<CarbonDimension>()) : new QueryModel.FilterProcessVO(this.table.getVisibleDimensions(), this.table.getVisibleMeasures(), this.table.getImplicitDimensions());
        QueryModel.processFilterExpression(processVO, this.expression, isFilterDimensions, isFilterMeasures, this.table);
    }

    private FilterResolverIntf resolveFilter() {
        try {
            AbsoluteTableIdentifier absoluteTableIdentifier = this.table != null ? this.table.getAbsoluteTableIdentifier() : null;
            FilterExpressionProcessor filterExpressionProcessor = new FilterExpressionProcessor();
            return filterExpressionProcessor.getFilterResolver(this.expression, absoluteTableIdentifier);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while resolving filter expression", e);
        }
    }
}

