/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.IndexChooser;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.index.IndexLevel;
import org.apache.carbondata.core.index.IndexStoreManager;
import org.apache.carbondata.core.index.IndexUtil;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.TableIndex;
import org.apache.carbondata.core.index.dev.expr.IndexInputSplitWrapper;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.readcommitter.LatestFilesReadCommittedScope;
import org.apache.carbondata.core.readcommitter.ReadCommittedScope;
import org.apache.carbondata.core.readcommitter.TableStatusReadCommittedScope;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.ObjectSerializationUtil;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.log4j.Logger;

public class IndexInputFormat
extends FileInputFormat<Void, ExtendedBlocklet>
implements Serializable,
Writable {
    private static final transient Logger LOGGER = LogServiceFactory.getLogService((String)IndexInputFormat.class.getName());
    private static final long serialVersionUID = 9189779090091151248L;
    private CarbonTable table;
    private FilterResolverIntf filterResolverIntf;
    private List<Segment> validSegments;
    private List<String> invalidSegments;
    private List<PartitionSpec> partitions;
    private boolean isJobToClearIndexes = false;
    private IndexLevel indexLevel;
    private boolean isFallbackJob = false;
    private String indexToClear = "";
    private ReadCommittedScope readCommittedScope;
    private String taskGroupId = "";
    private String taskGroupDesc = "";
    private String queryId = UUID.randomUUID().toString();
    private transient IndexChooser indexChooser;
    private boolean isWriteToFile = true;
    private boolean isCountStarJob = false;
    private boolean isAsyncCall;

    IndexInputFormat() {
    }

    IndexInputFormat(CarbonTable table, List<Segment> validSegments, List<String> invalidSegments, boolean isJobToClearIndexes, String indexToClear) {
        this(table, null, validSegments, invalidSegments, null, isJobToClearIndexes, null, false, false);
        this.indexToClear = indexToClear;
    }

    public IndexInputFormat(CarbonTable table, FilterResolverIntf filterResolverIntf, List<Segment> validSegments, List<String> invalidSegments, List<PartitionSpec> partitions, boolean isJobToClearIndexes, IndexLevel indexLevel, boolean isFallbackJob, boolean isAsyncCall) {
        this.table = table;
        this.filterResolverIntf = filterResolverIntf;
        this.validSegments = validSegments;
        if (!validSegments.isEmpty()) {
            this.readCommittedScope = validSegments.get(0).getReadCommittedScope();
        }
        this.invalidSegments = invalidSegments;
        this.partitions = partitions;
        this.isJobToClearIndexes = isJobToClearIndexes;
        this.indexLevel = indexLevel;
        this.isFallbackJob = isFallbackJob;
        this.isAsyncCall = isAsyncCall;
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        List<IndexInputSplitWrapper> distributables = IndexChooser.getDefaultIndex(this.table, this.filterResolverIntf).toDistributable(this.validSegments);
        ArrayList<InputSplit> inputSplits = new ArrayList<InputSplit>(distributables.size());
        inputSplits.addAll(distributables);
        return inputSplits;
    }

    public RecordReader<Void, ExtendedBlocklet> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
        return new RecordReader<Void, ExtendedBlocklet>(){
            private Iterator<ExtendedBlocklet> blockletIterator;
            private ExtendedBlocklet currBlocklet;

            public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException {
                IndexInputSplitWrapper distributable = (IndexInputSplitWrapper)inputSplit;
                distributable.getDistributable().getSegment().setReadCommittedScope(IndexInputFormat.this.readCommittedScope);
                ArrayList<Segment> segmentsToLoad = new ArrayList<Segment>();
                segmentsToLoad.add(distributable.getDistributable().getSegment());
                List<ExtendedBlocklet> blocklets = new ArrayList<ExtendedBlocklet>();
                if (IndexInputFormat.this.indexLevel == null) {
                    TableIndex defaultIndex = IndexStoreManager.getInstance().getIndex(IndexInputFormat.this.table, distributable.getDistributable().getIndexSchema());
                    blocklets = defaultIndex.prune(segmentsToLoad, new IndexFilter(IndexInputFormat.this.filterResolverIntf), IndexInputFormat.this.partitions);
                    blocklets = IndexUtil.pruneIndexes(IndexInputFormat.this.table, IndexInputFormat.this.filterResolverIntf, segmentsToLoad, IndexInputFormat.this.partitions, blocklets, IndexInputFormat.this.indexChooser);
                } else {
                    blocklets = IndexUtil.pruneIndexes(IndexInputFormat.this.table, IndexInputFormat.this.filterResolverIntf, segmentsToLoad, IndexInputFormat.this.partitions, blocklets, IndexInputFormat.this.indexLevel, IndexInputFormat.this.indexChooser);
                }
                this.blockletIterator = blocklets.iterator();
            }

            public boolean nextKeyValue() {
                boolean hasNext = this.blockletIterator.hasNext();
                if (hasNext) {
                    this.currBlocklet = this.blockletIterator.next();
                } else {
                    this.close();
                }
                return hasNext;
            }

            public Void getCurrentKey() {
                return null;
            }

            public ExtendedBlocklet getCurrentValue() {
                return this.currBlocklet;
            }

            public float getProgress() {
                return 0.0f;
            }

            public void close() {
                if (IndexInputFormat.this.isFallbackJob) {
                    IndexStoreManager.getInstance().clearIndexCache(IndexInputFormat.this.table.getAbsoluteTableIdentifier(), false);
                }
            }
        };
    }

    public CarbonTable getCarbonTable() {
        return this.table;
    }

    public void write(DataOutput out) throws IOException {
        this.table.write(out);
        out.writeInt(this.invalidSegments.size());
        for (String invalidSegment : this.invalidSegments) {
            out.writeUTF(invalidSegment);
        }
        out.writeBoolean(this.isJobToClearIndexes);
        out.writeBoolean(this.isFallbackJob);
        if (this.indexLevel == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.indexLevel.name());
        }
        out.writeInt(this.validSegments.size());
        for (Segment segment : this.validSegments) {
            segment.write(out);
        }
        if (this.partitions == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.partitions.size());
            for (PartitionSpec partitionSpec : this.partitions) {
                partitionSpec.write(out);
            }
        }
        if (this.filterResolverIntf != null) {
            out.writeBoolean(true);
            byte[] filterResolverBytes = ObjectSerializationUtil.convertObjectToString(this.filterResolverIntf).getBytes(Charset.defaultCharset());
            out.writeInt(filterResolverBytes.length);
            out.write(filterResolverBytes);
        } else {
            out.writeBoolean(false);
        }
        out.writeUTF(this.indexToClear);
        out.writeUTF(this.taskGroupId);
        out.writeUTF(this.taskGroupDesc);
        out.writeUTF(this.queryId);
        out.writeBoolean(this.isWriteToFile);
        out.writeBoolean(this.isCountStarJob);
        out.writeBoolean(this.isAsyncCall);
    }

    public void readFields(DataInput in) throws IOException {
        this.table = new CarbonTable();
        this.table.readFields(in);
        int invalidSegmentSize = in.readInt();
        this.invalidSegments = new ArrayList<String>(invalidSegmentSize);
        for (int i = 0; i < invalidSegmentSize; ++i) {
            this.invalidSegments.add(in.readUTF());
        }
        this.isJobToClearIndexes = in.readBoolean();
        this.isFallbackJob = in.readBoolean();
        if (in.readBoolean()) {
            this.indexLevel = IndexLevel.valueOf(in.readUTF());
        }
        int validSegmentSize = in.readInt();
        this.validSegments = new ArrayList<Segment>(validSegmentSize);
        this.initReadCommittedScope();
        for (int i = 0; i < validSegmentSize; ++i) {
            Segment segment = new Segment();
            segment.setReadCommittedScope(this.readCommittedScope);
            segment.readFields(in);
            this.validSegments.add(segment);
        }
        if (in.readBoolean()) {
            int numPartitions = in.readInt();
            this.partitions = new ArrayList<PartitionSpec>(numPartitions);
            for (int i = 0; i < numPartitions; ++i) {
                PartitionSpec partitionSpec = new PartitionSpec();
                partitionSpec.readFields(in);
                this.partitions.add(partitionSpec);
            }
        }
        if (in.readBoolean()) {
            byte[] filterResolverBytes = new byte[in.readInt()];
            in.readFully(filterResolverBytes, 0, filterResolverBytes.length);
            this.filterResolverIntf = (FilterResolverIntf)ObjectSerializationUtil.convertStringToObject(new String(filterResolverBytes, Charset.defaultCharset()));
        }
        this.indexToClear = in.readUTF();
        this.taskGroupId = in.readUTF();
        this.taskGroupDesc = in.readUTF();
        this.queryId = in.readUTF();
        this.isWriteToFile = in.readBoolean();
        this.isCountStarJob = in.readBoolean();
        this.isAsyncCall = in.readBoolean();
    }

    private void initReadCommittedScope() throws IOException {
        if (this.readCommittedScope == null) {
            this.readCommittedScope = this.table.isTransactionalTable() ? new TableStatusReadCommittedScope(this.table.getAbsoluteTableIdentifier(), FileFactory.getConfiguration()) : new LatestFilesReadCommittedScope(this.table.getTablePath(), FileFactory.getConfiguration());
        }
    }

    public boolean isFallbackJob() {
        return this.isFallbackJob;
    }

    public boolean ifAsyncCall() {
        return this.isAsyncCall;
    }

    public boolean isJobToClearIndexes() {
        return this.isJobToClearIndexes;
    }

    public String getTaskGroupId() {
        return this.taskGroupId;
    }

    public void setTaskGroupId(String taskGroupId) {
        this.taskGroupId = taskGroupId;
    }

    public String getTaskGroupDesc() {
        return this.taskGroupDesc;
    }

    public void setTaskGroupDesc(String taskGroupDesc) {
        int maxJobLenth;
        try {
            String maxJobLenthString = CarbonProperties.getInstance().getProperty("carbon.index.server.max.jobname.length", "50");
            maxJobLenth = Integer.parseInt(maxJobLenthString);
        }
        catch (Exception e) {
            String maxJobLenthString = CarbonProperties.getInstance().getProperty("50");
            maxJobLenth = Integer.parseInt(maxJobLenthString);
        }
        this.taskGroupDesc = taskGroupDesc.length() > maxJobLenth ? taskGroupDesc.substring(0, maxJobLenth) : taskGroupDesc;
    }

    public FilterResolverIntf getFilterResolverIntf() {
        return this.filterResolverIntf;
    }

    public void setFilterResolverIntf(FilterResolverIntf filterResolverIntf) {
        this.filterResolverIntf = filterResolverIntf;
    }

    public List<String> getInvalidSegments() {
        return this.invalidSegments;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getIndexToClear() {
        return this.indexToClear;
    }

    public void setIsWriteToFile(boolean isWriteToFile) {
        this.isWriteToFile = isWriteToFile;
    }

    public boolean isWriteToFile() {
        return this.isWriteToFile;
    }

    public void setFallbackJob() {
        this.isFallbackJob = true;
    }

    public List<String> getValidSegmentIds() {
        ArrayList<String> validSegments = new ArrayList<String>();
        for (Segment segment : this.validSegments) {
            validSegments.add(segment.getSegmentNo());
        }
        return validSegments;
    }

    public List<Segment> getValidSegments() {
        return this.validSegments;
    }

    public void createIndexChooser() throws IOException {
        if (null != this.filterResolverIntf) {
            this.indexChooser = new IndexChooser(this.table);
        }
    }

    public void setCountStarJob() {
        this.isCountStarJob = true;
    }

    public boolean isCountStarJob() {
        return this.isCountStarJob;
    }

    public List<PartitionSpec> getPartitions() {
        return this.partitions;
    }

    public ReadCommittedScope getReadCommittedScope() {
        return this.readCommittedScope;
    }
}

