/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.index;

import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.scan.filter.intf.ExpressionType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.StringUtils;

@InterfaceAudience.Developer(value={"Index"})
@InterfaceStability.Evolving
public class IndexMeta {
    private String indexName;
    private List<CarbonColumn> indexedColumns;
    private List<ExpressionType> optimizedOperation;

    public IndexMeta(List<CarbonColumn> indexedColumns, List<ExpressionType> optimizedOperation) {
        this.indexedColumns = indexedColumns;
        this.optimizedOperation = optimizedOperation;
    }

    public IndexMeta(String indexName, List<CarbonColumn> indexedColumns, List<ExpressionType> optimizedOperation) {
        this(indexedColumns, optimizedOperation);
        this.indexName = indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<CarbonColumn> getIndexedColumns() {
        return this.indexedColumns;
    }

    public List<String> getIndexedColumnNames() {
        return (List)CollectionUtils.collect(this.indexedColumns, (Transformer)new Transformer(){

            public Object transform(Object input) {
                return ((CarbonColumn)input).getColName();
            }
        });
    }

    public List<ExpressionType> getOptimizedOperation() {
        return this.optimizedOperation;
    }

    public String toString() {
        return "IndexMeta{" + "indexName='" + this.indexName + '\'' + ", indexedColumns=[" + StringUtils.join(this.getIndexedColumnNames(), (String)", ") + "]'" + ", optimizedOperation=" + this.optimizedOperation + '}';
    }
}

