/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.index;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.common.exceptions.MetadataProcessException;
import org.apache.carbondata.common.exceptions.sql.MalformedIndexCommandException;
import org.apache.carbondata.core.index.dev.Index;
import org.apache.carbondata.core.index.dev.IndexFactory;
import org.apache.carbondata.core.metadata.index.IndexType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.IndexSchema;

@InterfaceAudience.Developer(value={"Index"})
@InterfaceStability.Evolving
public class IndexRegistry {
    private static Map<String, String> shortNameToClassName = new ConcurrentHashMap<String, String>();

    private static void registerIndex(String indexClassName, String shortName) {
        Objects.requireNonNull(indexClassName);
        Objects.requireNonNull(shortName);
        shortNameToClassName.put(shortName, indexClassName);
    }

    private static String getIndexClassName(String shortName) {
        Objects.requireNonNull(shortName);
        return shortNameToClassName.get(shortName);
    }

    public static IndexFactory<? extends Index> getIndexFactoryByShortName(CarbonTable table, IndexSchema indexSchema) throws MalformedIndexCommandException {
        IndexFactory indexFactory;
        String providerName = indexSchema.getProviderName();
        try {
            IndexRegistry.registerIndex(IndexType.get(providerName).getClassName(), IndexType.get(providerName).getIndexProviderName());
        }
        catch (UnsupportedOperationException ex) {
            throw new MalformedIndexCommandException("Index '" + providerName + "' not found", (Throwable)ex);
        }
        String className = IndexRegistry.getIndexClassName(providerName.toLowerCase());
        if (className != null) {
            try {
                indexFactory = (IndexFactory)Class.forName(className).getConstructors()[0].newInstance(table, indexSchema);
            }
            catch (ClassNotFoundException ex) {
                throw new MalformedIndexCommandException("Index '" + providerName + "' not found", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw new MalformedIndexCommandException(ex.getTargetException().getMessage());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException ex) {
                throw new MetadataProcessException("failed to create Index '" + providerName + "': " + ex.getMessage(), (Throwable)ex);
            }
        } else {
            throw new MalformedIndexCommandException("Index '" + providerName + "' not found");
        }
        return indexFactory;
    }
}

