/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.exceptions.MetadataProcessException;
import org.apache.carbondata.common.exceptions.sql.MalformedIndexCommandException;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.SegmentPropertiesAndSchemaHolder;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.IndexLevel;
import org.apache.carbondata.core.index.IndexRegistry;
import org.apache.carbondata.core.index.IndexUtil;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.TableIndex;
import org.apache.carbondata.core.index.dev.IndexFactory;
import org.apache.carbondata.core.indexstore.BlockletDetailsFetcher;
import org.apache.carbondata.core.indexstore.SegmentPropertiesFetcher;
import org.apache.carbondata.core.indexstore.blockletindex.BlockletIndexFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.index.IndexType;
import org.apache.carbondata.core.metadata.schema.indextable.IndexMetadata;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.IndexSchema;
import org.apache.carbondata.core.mutate.UpdateVO;
import org.apache.carbondata.core.statusmanager.SegmentRefreshInfo;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

@InterfaceAudience.Internal
public final class IndexStoreManager {
    private static IndexStoreManager instance = new IndexStoreManager();
    private Map<String, List<TableIndex>> allIndexes = new ConcurrentHashMap<String, List<TableIndex>>();
    private Map<String, String> tablePathMap = new ConcurrentHashMap<String, String>();
    private Map<String, TableSegmentRefresher> segmentRefreshMap = new ConcurrentHashMap<String, TableSegmentRefresher>();
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)IndexStoreManager.class.getName());

    public Map<String, List<TableIndex>> getTableIndexForAllTables() {
        return this.allIndexes;
    }

    private IndexStoreManager() {
    }

    public List<TableIndex> getAllCGAndFGIndexes(CarbonTable carbonTable) throws IOException {
        IndexMetadata indexMetadata = carbonTable.getIndexMetadata();
        ArrayList<TableIndex> indexes = new ArrayList<TableIndex>();
        if (null != indexMetadata) {
            for (Map.Entry<String, Map<String, Map<String, String>>> providerEntry : indexMetadata.getIndexesMap().entrySet()) {
                for (Map.Entry<String, Map<String, String>> indexEntry : providerEntry.getValue().entrySet()) {
                    if (indexEntry.getValue().get("index_provider").equalsIgnoreCase(IndexType.SI.getIndexProviderName())) continue;
                    IndexSchema indexSchema = new IndexSchema(indexEntry.getKey(), indexEntry.getValue().get("index_provider"));
                    indexSchema.setProperties(indexEntry.getValue());
                    indexes.add(this.getIndex(carbonTable, indexSchema));
                }
            }
        }
        return indexes;
    }

    public TableIndex getDefaultIndex(CarbonTable table) {
        return this.getIndex(table, BlockletIndexFactory.INDEX_SCHEMA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableIndex getIndex(CarbonTable table, IndexSchema indexSchema) {
        String keyUsingTablePath;
        String tableId = table.getAbsoluteTableIdentifier().getCarbonTableIdentifier().getTableId();
        List<TableIndex> tableIndices = this.allIndexes.get(table.getTableId());
        if (tableIndices == null && !table.isTransactionalTable() && (keyUsingTablePath = this.getKeyUsingTablePath(table.getTablePath())) != null) {
            tableId = keyUsingTablePath;
            tableIndices = this.allIndexes.get(tableId);
        }
        if (this.allIndexes.size() > 0 && !CollectionUtils.isEmpty((Collection)this.allIndexes.get(tableId)) && !this.allIndexes.get(tableId).get(0).getTable().getTableInfo().getFactTable().getListOfColumns().equals(table.getTableInfo().getFactTable().getListOfColumns())) {
            this.clearIndex(tableId);
            tableIndices = null;
        }
        TableIndex index = null;
        if (tableIndices != null) {
            index = this.getTableIndex(indexSchema.getIndexName(), tableIndices);
        }
        if (index == null) {
            String string = tableId.intern();
            synchronized (string) {
                tableIndices = this.allIndexes.get(tableId);
                if (tableIndices != null) {
                    index = this.getTableIndex(indexSchema.getIndexName(), tableIndices);
                }
                if (index == null) {
                    try {
                        index = this.createAndRegisterIndex(table, indexSchema);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        if (index == null) {
            throw new RuntimeException("Index does not exist");
        }
        index.getIndexFactory().setCarbonTable(table);
        return index;
    }

    private String getKeyUsingTablePath(String tablePath) {
        if (tablePath != null) {
            for (Map.Entry<String, String> entry : this.tablePathMap.entrySet()) {
                if (!new Path(entry.getValue()).equals((Object)new Path(tablePath))) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public IndexFactory getIndexFactoryClass(CarbonTable table, IndexSchema indexSchema) throws MalformedIndexCommandException {
        try {
            return (IndexFactory)Class.forName(indexSchema.getProviderName()).getConstructors()[0].newInstance(table, indexSchema);
        }
        catch (ClassNotFoundException e) {
            return IndexRegistry.getIndexFactoryByShortName(table, indexSchema);
        }
        catch (Throwable e) {
            throw new MetadataProcessException("failed to get Index factory for'" + indexSchema.getProviderName() + "'", e);
        }
    }

    private TableIndex createAndRegisterIndex(CarbonTable table, IndexSchema indexSchema) throws MalformedIndexCommandException {
        IndexFactory indexFactory = this.getIndexFactoryClass(table, indexSchema);
        return this.registerIndex(table, indexSchema, indexFactory);
    }

    public TableIndex registerIndex(CarbonTable table, IndexSchema indexSchema, IndexFactory indexFactory) {
        String keyUsingTablePath;
        String tableUniqueName = table.getCarbonTableIdentifier().getTableUniqueName();
        this.getTableSegmentRefresher(table);
        List<TableIndex> tableIndices = this.allIndexes.get(table.getTableId());
        if (tableIndices == null && (keyUsingTablePath = this.getKeyUsingTablePath(table.getTablePath())) != null) {
            tableUniqueName = keyUsingTablePath;
            tableIndices = this.allIndexes.get(table.getTableId());
        }
        if (tableIndices == null) {
            tableIndices = new ArrayList<TableIndex>();
        }
        SegmentPropertiesFetcher segmentPropertiesFetcher = null;
        BlockletDetailsFetcher blockletDetailsFetcher = indexFactory instanceof BlockletDetailsFetcher ? (BlockletDetailsFetcher)((Object)indexFactory) : this.getBlockletDetailsFetcher(table);
        segmentPropertiesFetcher = (SegmentPropertiesFetcher)((Object)blockletDetailsFetcher);
        TableIndex index = new TableIndex(table, indexSchema, indexFactory, blockletDetailsFetcher, segmentPropertiesFetcher);
        tableIndices.add(index);
        this.allIndexes.put(table.getTableId(), tableIndices);
        this.tablePathMap.put(table.getTableId(), table.getTablePath());
        return index;
    }

    private TableIndex getTableIndex(String indexName, List<TableIndex> tableIndices) {
        TableIndex index = null;
        for (TableIndex tableIndex : tableIndices) {
            if (!tableIndex.getIndexSchema().getIndexName().equals(indexName)) continue;
            index = tableIndex;
            break;
        }
        return index;
    }

    public void clearInvalidSegments(CarbonTable carbonTable, List<String> segments) throws IOException {
        this.getDefaultIndex(carbonTable).clear(segments);
        List<TableIndex> indexes = this.getAllCGAndFGIndexes(carbonTable);
        for (TableIndex index : indexes) {
            index.clear(segments);
        }
    }

    public List<String> getSegmentsToBeRefreshed(CarbonTable carbonTable, List<Segment> filteredSegmentToAccess) {
        ArrayList<String> toBeCleanedSegments = new ArrayList<String>();
        for (Segment filteredSegment : filteredSegmentToAccess) {
            boolean refreshNeeded = this.getTableSegmentRefresher(carbonTable).isRefreshNeeded(filteredSegment, SegmentUpdateStatusManager.getInvalidTimestampRange(filteredSegment.getLoadMetadataDetails()));
            if (!refreshNeeded) continue;
            toBeCleanedSegments.add(filteredSegment.getSegmentNo());
        }
        return toBeCleanedSegments;
    }

    public void refreshSegmentCacheIfRequired(CarbonTable carbonTable, SegmentUpdateStatusManager updateStatusManager, List<Segment> filteredSegmentToAccess) throws IOException {
        List<String> toBeCleanedSegments = this.getSegmentsToBeRefreshed(carbonTable, filteredSegmentToAccess);
        if (toBeCleanedSegments.size() > 0) {
            this.clearInvalidSegments(carbonTable, toBeCleanedSegments);
        }
    }

    public void clearIndex(AbsoluteTableIdentifier identifier) {
        CarbonTable carbonTable = this.getCarbonTable(identifier);
        boolean launchJob = false;
        try {
            launchJob = this.hasCGIndex(carbonTable) || CarbonProperties.getInstance().isDistributedPruningEnabled(identifier.getDatabaseName(), identifier.getTableName());
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Unable to launch job to clear indexes.", (Throwable)e);
        }
        this.clearIndexCache(identifier, launchJob);
    }

    public void clearIndexCache(AbsoluteTableIdentifier identifier, boolean clearInAllWorkers) {
        String keyUsingTablePath;
        String tableId = identifier.getCarbonTableIdentifier().getTableId();
        if (clearInAllWorkers) {
            CarbonTable carbonTable = this.getCarbonTable(identifier);
            if (null != carbonTable) {
                String jobClassName = CarbonProperties.getInstance().isDistributedPruningEnabled(identifier.getDatabaseName(), identifier.getTableName()) ? "org.apache.carbondata.indexserver.DistributedIndexJob" : "org.apache.carbondata.indexserver.EmbeddedIndexJob";
                try {
                    IndexUtil.executeClearIndexJob(carbonTable, jobClassName);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"clear index job failed", (Throwable)e);
                }
            }
        } else {
            CarbonMetadata.getInstance().removeTable(identifier.getDatabaseName(), identifier.getTableName());
        }
        List<TableIndex> tableIndices = this.allIndexes.get(identifier.getCarbonTableIdentifier().getTableId());
        if (tableIndices == null && (keyUsingTablePath = this.getKeyUsingTablePath(identifier.getTablePath())) != null) {
            tableId = keyUsingTablePath;
        }
        this.segmentRefreshMap.remove(tableId);
        this.clearIndex(tableId);
        this.allIndexes.remove(tableId);
        this.tablePathMap.remove(tableId);
    }

    public CarbonTable getCarbonTable(AbsoluteTableIdentifier identifier) {
        CarbonTable carbonTable = null;
        carbonTable = CarbonMetadata.getInstance().getCarbonTable(identifier.getDatabaseName(), identifier.getTableName());
        if (carbonTable == null) {
            try {
                carbonTable = CarbonTable.buildFromTablePath(identifier.getTableName(), identifier.getDatabaseName(), identifier.getTablePath(), identifier.getCarbonTableIdentifier().getTableId());
            }
            catch (IOException e) {
                LOGGER.warn((Object)("failed to get carbon table from table Path" + e.getMessage()), (Throwable)e);
            }
        }
        return carbonTable;
    }

    public void clearIndex(String tableId) {
        List<TableIndex> tableIndices = this.allIndexes.get(tableId);
        if (tableIndices != null) {
            for (TableIndex tableIndex : tableIndices) {
                if (tableIndex == null) continue;
                tableIndex.getBlockletDetailsFetcher().clear();
                tableIndex.clear();
            }
        }
        this.allIndexes.remove(tableId);
        this.tablePathMap.remove(tableId);
    }

    public void deleteIndex(CarbonTable carbonTable, String indexName) {
        if (carbonTable == null) {
            return;
        }
        String tableId = carbonTable.getTableId();
        if (CarbonProperties.getInstance().isDistributedPruningEnabled(carbonTable.getDatabaseName(), carbonTable.getTableName())) {
            try {
                IndexUtil.executeClearIndexJob(carbonTable, "org.apache.carbondata.indexserver.DistributedIndexJob", indexName);
            }
            catch (IOException e) {
                LOGGER.error((Object)"clear index job failed", (Throwable)e);
            }
        } else {
            List<TableIndex> tableIndices = this.allIndexes.get(tableId);
            if (tableIndices != null) {
                int i = 0;
                for (TableIndex tableIndex : tableIndices) {
                    if (tableIndex != null && indexName.equalsIgnoreCase(tableIndex.getIndexSchema().getIndexName())) {
                        try {
                            IndexUtil.executeClearIndexJob(carbonTable, "org.apache.carbondata.indexserver.EmbeddedIndexJob", indexName);
                            tableIndex.clear();
                        }
                        catch (IOException e) {
                            LOGGER.error((Object)"clear index job failed", (Throwable)e);
                        }
                        tableIndex.deleteIndexData();
                        tableIndices.remove(i);
                        break;
                    }
                    ++i;
                }
                this.allIndexes.put(tableId, tableIndices);
            }
        }
    }

    private BlockletDetailsFetcher getBlockletDetailsFetcher(CarbonTable table) {
        TableIndex index = this.getIndex(table, BlockletIndexFactory.INDEX_SCHEMA);
        return (BlockletDetailsFetcher)((Object)index.getIndexFactory());
    }

    public static IndexStoreManager getInstance() {
        return instance;
    }

    public TableSegmentRefresher getTableSegmentRefresher(CarbonTable table) {
        String tableId = table.getAbsoluteTableIdentifier().getCarbonTableIdentifier().getTableId();
        if (this.segmentRefreshMap.get(tableId) == null) {
            this.segmentRefreshMap.put(tableId, new TableSegmentRefresher(table));
        }
        return this.segmentRefreshMap.get(tableId);
    }

    public synchronized void clearInvalidIndex(CarbonTable carbonTable, List<String> segmentNos, String indexToClear) throws IOException {
        List<TableIndex> indexes = this.getAllCGAndFGIndexes(carbonTable);
        ArrayList<TableIndex> remainingIndexes = new ArrayList<TableIndex>();
        if (StringUtils.isNotEmpty((String)indexToClear)) {
            for (TableIndex tableIndex : indexes) {
                if (indexToClear.equalsIgnoreCase(tableIndex.getIndexSchema().getIndexName())) {
                    for (String segment : segmentNos) {
                        tableIndex.deleteSegmentIndexData(segment);
                    }
                    tableIndex.clear();
                    continue;
                }
                remainingIndexes.add(tableIndex);
            }
            this.allIndexes.put(carbonTable.getTableId(), remainingIndexes);
        } else {
            this.clearIndex(carbonTable.getTableId());
            SegmentPropertiesAndSchemaHolder.getInstance().invalidate(carbonTable.getAbsoluteTableIdentifier());
        }
    }

    private boolean hasCGIndex(CarbonTable carbonTable) throws IOException {
        if (null == carbonTable) {
            return false;
        }
        for (TableIndex tableIndex : carbonTable.getAllVisibleIndexes()) {
            if (!tableIndex.getIndexFactory().getIndexLevel().equals((Object)IndexLevel.CG)) continue;
            return true;
        }
        return false;
    }

    public static class TableSegmentRefresher {
        private Map<String, SegmentRefreshInfo> segmentRefreshTime = new HashMap<String, SegmentRefreshInfo>();
        private Map<String, Boolean> manualSegmentRefresh = new HashMap<String, Boolean>();

        TableSegmentRefresher(CarbonTable table) {
            List<Segment> validSegments;
            SegmentStatusManager segmentStatusManager = new SegmentStatusManager(table.getAbsoluteTableIdentifier());
            try {
                validSegments = segmentStatusManager.getValidAndInvalidSegments().getValidSegments();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error while getting the valid segments.", (Throwable)e);
                throw new RuntimeException(e);
            }
            for (Segment segment : validSegments) {
                SegmentRefreshInfo segmentRefreshInfo;
                UpdateVO updateVO = SegmentUpdateStatusManager.getInvalidTimestampRange(segment.getLoadMetadataDetails());
                if (updateVO != null && updateVO.getLatestUpdateTimestamp() != null || segment.getSegmentFileName() != null) {
                    long segmentFileTimeStamp = FileFactory.getCarbonFile(CarbonTablePath.getSegmentFilePath(table.getTablePath(), segment.getSegmentFileName())).getLastModifiedTime();
                    segmentRefreshInfo = new SegmentRefreshInfo(updateVO.getLatestUpdateTimestamp(), 0, segmentFileTimeStamp);
                } else {
                    segmentRefreshInfo = new SegmentRefreshInfo(0L, 0, 0L);
                }
                this.segmentRefreshTime.put(segment.getSegmentNo(), segmentRefreshInfo);
            }
        }

        public boolean isRefreshNeeded(Segment seg, UpdateVO updateVo) {
            SegmentRefreshInfo segmentRefreshInfo = seg.getSegmentRefreshInfo(updateVo);
            String segmentId = seg.getSegmentNo();
            if (segmentRefreshInfo.getSegmentUpdatedTimestamp() == null && segmentRefreshInfo.getSegmentFileTimestamp() == 0L) {
                return false;
            }
            if (this.segmentRefreshTime.get(segmentId) == null) {
                if (segmentRefreshInfo.getSegmentUpdatedTimestamp() != null && segmentRefreshInfo.getSegmentUpdatedTimestamp() != 0L) {
                    this.segmentRefreshTime.put(segmentId, segmentRefreshInfo);
                    return true;
                }
                if (segmentRefreshInfo.getSegmentFileTimestamp() != 0L) {
                    this.segmentRefreshTime.put(segmentId, segmentRefreshInfo);
                    return true;
                }
            }
            if (this.manualSegmentRefresh.get(segmentId) != null && this.manualSegmentRefresh.get(segmentId).booleanValue()) {
                this.manualSegmentRefresh.put(segmentId, false);
                return true;
            }
            boolean isRefresh = segmentRefreshInfo.compare(this.segmentRefreshTime.get(segmentId));
            if (isRefresh) {
                this.segmentRefreshTime.remove(segmentId);
            }
            return isRefresh;
        }
    }
}

