/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.index;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.IndexChooser;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.index.IndexInputFormat;
import org.apache.carbondata.core.index.IndexJob;
import org.apache.carbondata.core.index.IndexLevel;
import org.apache.carbondata.core.index.IndexStoreManager;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.TableIndex;
import org.apache.carbondata.core.index.dev.Index;
import org.apache.carbondata.core.index.dev.expr.IndexExprWrapper;
import org.apache.carbondata.core.index.dev.expr.IndexInputSplitWrapper;
import org.apache.carbondata.core.indexstore.BlockletIndexWrapper;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.RelationIdentifier;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.BlockletIndexUtil;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.ObjectSerializationUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.log4j.Logger;

public class IndexUtil {
    private static final String INDEX_DSTR = "mapreduce.input.carboninputformat.indexdstr";
    public static final String EMBEDDED_JOB_NAME = "org.apache.carbondata.indexserver.EmbeddedIndexJob";
    public static final String DISTRIBUTED_JOB_NAME = "org.apache.carbondata.indexserver.DistributedIndexJob";
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)IndexUtil.class.getName());

    public static Object createIndexJob(String className) {
        try {
            return Class.forName(className).getDeclaredConstructors()[0].newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void setIndexJob(Configuration configuration, Object IndexJob2) throws IOException {
        if (IndexJob2 != null) {
            String toString = ObjectSerializationUtil.convertObjectToString(IndexJob2);
            configuration.set(INDEX_DSTR, toString);
        }
    }

    public static IndexJob getIndexJob(Configuration configuration) throws IOException {
        String jobString = configuration.get(INDEX_DSTR);
        if (jobString != null) {
            return (IndexJob)ObjectSerializationUtil.convertStringToObject(jobString);
        }
        return null;
    }

    private static void executeClearIndexJob(IndexJob indexJob, CarbonTable carbonTable, String indexToClear) throws IOException {
        SegmentStatusManager.ValidAndInvalidSegmentsInfo validAndInvalidSegmentsInfo = IndexUtil.getValidAndInvalidSegments(carbonTable, FileFactory.getConfiguration());
        ArrayList<String> invalidSegment = new ArrayList<String>();
        for (Segment segment : validAndInvalidSegmentsInfo.getInvalidSegments()) {
            invalidSegment.add(segment.getSegmentNo());
        }
        IndexInputFormat indexInputFormat = new IndexInputFormat(carbonTable, validAndInvalidSegmentsInfo.getValidSegments(), invalidSegment, true, indexToClear);
        try {
            indexJob.execute(indexInputFormat);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to execute Index clear Job", (Throwable)e);
        }
    }

    public static void executeClearIndexJob(CarbonTable carbonTable, String jobClassName) throws IOException {
        IndexUtil.executeClearIndexJob(carbonTable, jobClassName, "");
    }

    static void executeClearIndexJob(CarbonTable carbonTable, String jobClassName, String indexToClear) throws IOException {
        IndexJob indexJob = (IndexJob)IndexUtil.createIndexJob(jobClassName);
        if (indexJob == null) {
            return;
        }
        IndexUtil.executeClearIndexJob(indexJob, carbonTable, indexToClear);
    }

    public static IndexJob getEmbeddedJob() {
        IndexJob indexJob = (IndexJob)IndexUtil.createIndexJob(EMBEDDED_JOB_NAME);
        if (indexJob == null) {
            throw new ExceptionInInitializerError("Unable to create EmbeddedIndexJob");
        }
        return indexJob;
    }

    public static void pruneSegments(List<Segment> segments, List<ExtendedBlocklet> prunedBlocklets) {
        HashMap<Segment, HashSet<String>> validSegments = new HashMap<Segment, HashSet<String>>();
        for (ExtendedBlocklet extendedBlocklet : prunedBlocklets) {
            String shardName = CarbonTablePath.getShardName(extendedBlocklet.getFilePath());
            HashSet<String> existingShards = (HashSet<String>)validSegments.get(extendedBlocklet.getSegment());
            if (existingShards == null) {
                existingShards = new HashSet<String>();
                validSegments.put(extendedBlocklet.getSegment(), existingShards);
            }
            existingShards.add(shardName);
        }
        for (Map.Entry entry : validSegments.entrySet()) {
            ((Segment)entry.getKey()).setFilteredIndexShardNames((Set)entry.getValue());
        }
        segments.clear();
        segments.addAll(validSegments.keySet());
    }

    public static void loadIndexes(CarbonTable carbonTable, IndexExprWrapper indexExprWrapper, List<Segment> validSegments) throws IOException {
        if (!CarbonProperties.getInstance().isDistributedPruningEnabled(carbonTable.getDatabaseName(), carbonTable.getTableName()) && BlockletIndexUtil.loadIndexesParallel(carbonTable)) {
            String clsName = "org.apache.spark.sql.secondaryindex.Jobs.SparkBlockletIndexLoaderJob";
            IndexJob indexJob = (IndexJob)IndexUtil.createIndexJob(clsName);
            String className = "org.apache.spark.sql.secondaryindex.Jobs.BlockletIndexInputFormat";
            FileInputFormat indexFormat = IndexUtil.createIndexJob(carbonTable, indexExprWrapper, validSegments, className);
            indexJob.execute(carbonTable, (FileInputFormat<Void, BlockletIndexWrapper>)indexFormat);
        }
    }

    private static FileInputFormat createIndexJob(CarbonTable carbonTable, IndexExprWrapper indexExprWrapper, List<Segment> validSegments, String clsName) {
        try {
            Constructor<?> cons = Class.forName(clsName).getDeclaredConstructors()[0];
            return (FileInputFormat)cons.newInstance(carbonTable, indexExprWrapper, validSegments);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static List<ExtendedBlocklet> pruneIndexes(CarbonTable table, FilterResolverIntf filterResolverIntf, List<Segment> segmentsToLoad, List<PartitionSpec> partitions, List<ExtendedBlocklet> blocklets, IndexChooser indexChooser) throws IOException {
        if (null == indexChooser) {
            return blocklets;
        }
        IndexUtil.pruneSegments(segmentsToLoad, blocklets);
        List<ExtendedBlocklet> cgIndexes = IndexUtil.pruneIndexes(table, filterResolverIntf, segmentsToLoad, partitions, blocklets, IndexLevel.CG, indexChooser);
        IndexUtil.pruneSegments(segmentsToLoad, cgIndexes);
        return IndexUtil.pruneIndexes(table, filterResolverIntf, segmentsToLoad, partitions, cgIndexes, IndexLevel.FG, indexChooser);
    }

    static List<ExtendedBlocklet> pruneIndexes(CarbonTable table, FilterResolverIntf filterResolverIntf, List<Segment> segmentsToLoad, List<PartitionSpec> partitions, List<ExtendedBlocklet> blocklets, IndexLevel indexLevel, IndexChooser indexChooser) throws IOException {
        IndexExprWrapper indexExprWrapper = indexChooser.chooseIndex(indexLevel, filterResolverIntf);
        if (indexExprWrapper != null) {
            ArrayList<ExtendedBlocklet> extendedBlocklets = new ArrayList<ExtendedBlocklet>();
            for (IndexInputSplitWrapper wrapper : indexExprWrapper.toDistributable(segmentsToLoad)) {
                TableIndex index = IndexStoreManager.getInstance().getIndex(table, wrapper.getDistributable().getIndexSchema());
                List<Index> indices = index.getTableIndexes(wrapper.getDistributable());
                ArrayList<ExtendedBlocklet> prunnedBlocklet = new ArrayList<ExtendedBlocklet>();
                if (table.isTransactionalTable()) {
                    prunnedBlocklet.addAll(index.prune(indices, wrapper.getDistributable(), indexExprWrapper.getFilterResolverIntf(wrapper.getUniqueId()), partitions));
                } else {
                    prunnedBlocklet.addAll(index.prune(segmentsToLoad, new IndexFilter(filterResolverIntf), partitions));
                }
                for (ExtendedBlocklet blocklet : prunnedBlocklet) {
                    blocklet.getDetailInfo();
                    blocklet.setIndexUniqueId(wrapper.getUniqueId());
                }
                extendedBlocklets.addAll(prunnedBlocklet);
            }
            return indexExprWrapper.pruneBlocklets(extendedBlocklets);
        }
        return blocklets;
    }

    public static List<ExtendedBlocklet> executeIndexJob(CarbonTable carbonTable, FilterResolverIntf resolver, IndexJob indexJob, List<PartitionSpec> partitionsToPrune, List<Segment> validSegments, List<Segment> invalidSegments, IndexLevel level, List<String> segmentsToBeRefreshed) {
        return IndexUtil.executeIndexJob(carbonTable, resolver, indexJob, partitionsToPrune, validSegments, invalidSegments, level, false, segmentsToBeRefreshed, false);
    }

    public static List<ExtendedBlocklet> executeIndexJob(CarbonTable carbonTable, FilterResolverIntf resolver, IndexJob indexJob, List<PartitionSpec> partitionsToPrune, List<Segment> validSegments, List<Segment> invalidSegments, IndexLevel level, Boolean isFallbackJob, List<String> segmentsToBeRefreshed, boolean isCountJob) {
        ArrayList<String> invalidSegmentNo = new ArrayList<String>();
        for (Segment segment : invalidSegments) {
            invalidSegmentNo.add(segment.getSegmentNo());
        }
        invalidSegmentNo.addAll(segmentsToBeRefreshed);
        IndexInputFormat indexInputFormat = new IndexInputFormat(carbonTable, resolver, validSegments, invalidSegmentNo, partitionsToPrune, false, level, isFallbackJob, false);
        if (isCountJob) {
            indexInputFormat.setCountStarJob();
            indexInputFormat.setIsWriteToFile(false);
        }
        return indexJob.execute(indexInputFormat);
    }

    public static SegmentStatusManager.ValidAndInvalidSegmentsInfo getValidAndInvalidSegments(CarbonTable carbonTable, Configuration configuration) throws IOException {
        SegmentStatusManager ssm = new SegmentStatusManager(carbonTable.getAbsoluteTableIdentifier(), configuration);
        return ssm.getValidAndInvalidSegments(carbonTable.isMV());
    }

    public static List<String> getMainTableValidSegmentList(RelationIdentifier relationIdentifier) throws IOException {
        ArrayList<String> segmentList = new ArrayList<String>();
        List<Segment> validSegments = new SegmentStatusManager(AbsoluteTableIdentifier.from(relationIdentifier.getTablePath(), relationIdentifier.getDatabaseName(), relationIdentifier.getTableName())).getValidAndInvalidSegments().getValidSegments();
        for (Segment segment : validSegments) {
            segmentList.add(segment.getSegmentNo());
        }
        return segmentList;
    }

    public static String getMaxSegmentID(List<String> segmentList) {
        double[] segment = new double[segmentList.size()];
        int i = 0;
        for (String id : segmentList) {
            segment[i] = Double.parseDouble(id);
            ++i;
        }
        Arrays.sort(segment);
        String maxId = Double.toString(segment[segmentList.size() - 1]);
        if (maxId.endsWith(".0")) {
            maxId = maxId.substring(0, maxId.indexOf("."));
        }
        return maxId;
    }
}

