/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.carbondata.core.metadata.schema.table.Writable;
import org.apache.carbondata.core.mutate.UpdateVO;
import org.apache.carbondata.core.readcommitter.ReadCommittedScope;
import org.apache.carbondata.core.segmentmeta.SegmentMetaDataInfo;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentRefreshInfo;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.hadoop.conf.Configuration;

public class Segment
implements Serializable,
Writable {
    private static final long serialVersionUID = 7044555408162234064L;
    private String segmentNo;
    private String segmentFileName;
    private Set<String> filteredIndexShardNames = new HashSet<String>();
    private transient ReadCommittedScope readCommittedScope;
    private transient LoadMetadataDetails loadMetadataDetails;
    private String segmentString;
    private long indexSize = 0L;
    private boolean isCacheable = true;
    private transient String segmentPath;
    private transient Map<String, String> options;
    private SegmentMetaDataInfo segmentMetaDataInfo;

    public Segment() {
    }

    public Segment(String segmentNo) {
        this.segmentNo = segmentNo;
    }

    public Segment(String segmentNo, ReadCommittedScope readCommittedScope) {
        this.segmentNo = segmentNo;
        this.readCommittedScope = readCommittedScope;
        this.segmentString = segmentNo;
    }

    public Segment(String segmentNo, String segmentFileName) {
        this.segmentNo = segmentNo;
        this.segmentFileName = segmentFileName;
        this.readCommittedScope = null;
        this.segmentString = segmentFileName != null ? segmentNo + "#" + segmentFileName : segmentNo;
    }

    public Segment(String segmentNo, String segmentFileName, String segmentPath, Map<String, String> options) {
        this(segmentNo, segmentFileName);
        this.segmentPath = segmentPath;
        this.options = options;
    }

    public void setSegmentFileName(String segmentFileName) {
        this.segmentFileName = segmentFileName;
    }

    public Segment(String segmentNo, String segmentFileName, ReadCommittedScope readCommittedScope) {
        this.segmentNo = segmentNo;
        this.segmentFileName = segmentFileName;
        this.readCommittedScope = readCommittedScope;
        this.segmentString = segmentFileName != null ? segmentNo + "#" + segmentFileName : segmentNo;
    }

    public Segment(String segmentNo, String segmentFileName, ReadCommittedScope readCommittedScope, LoadMetadataDetails loadMetadataDetails) {
        this.segmentNo = segmentNo;
        this.segmentFileName = segmentFileName;
        this.readCommittedScope = readCommittedScope;
        this.loadMetadataDetails = loadMetadataDetails;
        if (loadMetadataDetails.getIndexSize() != null) {
            this.indexSize = Long.parseLong(loadMetadataDetails.getIndexSize());
        }
        this.segmentString = segmentFileName != null ? segmentNo + "#" + segmentFileName : segmentNo;
    }

    public Map<String, String> getCommittedIndexFile() throws IOException {
        return this.readCommittedScope.getCommittedIndexFile(this);
    }

    public SegmentRefreshInfo getSegmentRefreshInfo(UpdateVO updateVo) {
        return this.readCommittedScope.getCommittedSegmentRefreshInfo(this, updateVo);
    }

    public String getSegmentNo() {
        return this.segmentNo;
    }

    public String getSegmentFileName() {
        return this.segmentFileName;
    }

    public void setReadCommittedScope(ReadCommittedScope readCommittedScope) {
        this.readCommittedScope = readCommittedScope;
    }

    public ReadCommittedScope getReadCommittedScope() {
        return this.readCommittedScope;
    }

    public static List<Segment> toSegmentList(String[] segmentIds, ReadCommittedScope readCommittedScope) {
        ArrayList<Segment> list = new ArrayList<Segment>(segmentIds.length);
        for (String segmentId : segmentIds) {
            list.add(Segment.toSegment(segmentId, readCommittedScope));
        }
        return list;
    }

    public static List<Segment> toSegmentList(List<String> segmentIds, ReadCommittedScope readCommittedScope) {
        ArrayList<Segment> list = new ArrayList<Segment>(segmentIds.size());
        for (String segmentId : segmentIds) {
            list.add(Segment.toSegment(segmentId, readCommittedScope));
        }
        return list;
    }

    public static Segment toSegment(String segmentId, ReadCommittedScope readCommittedScope) {
        String[] split = segmentId.split("#");
        if (split.length > 1) {
            return new Segment(split[0], split[1], readCommittedScope);
        }
        if (split.length > 0) {
            return new Segment(split[0], null, readCommittedScope);
        }
        return new Segment(segmentId, null, readCommittedScope);
    }

    public static Segment toSegment(String segmentId) {
        return Segment.toSegment(segmentId, null);
    }

    public static Segment getSegment(String segmentNo, String tablePath) {
        LoadMetadataDetails[] loadMetadataDetails = SegmentStatusManager.readLoadMetadata(CarbonTablePath.getMetadataPath(tablePath));
        return Segment.getSegment(segmentNo, loadMetadataDetails);
    }

    public static Segment getSegment(String segmentNo, LoadMetadataDetails[] loadMetadataDetails) {
        for (LoadMetadataDetails details : loadMetadataDetails) {
            if (!details.getLoadName().equals(segmentNo)) continue;
            return new Segment(details.getLoadName(), details.getSegmentFile());
        }
        return null;
    }

    public Configuration getConfiguration() {
        return this.readCommittedScope.getConfiguration();
    }

    public Set<String> getFilteredIndexShardNames() {
        return this.filteredIndexShardNames;
    }

    public void setFilteredIndexShardNames(Set<String> filteredIndexShardNames) {
        this.filteredIndexShardNames = filteredIndexShardNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment segment = (Segment)o;
        return Objects.equals(this.segmentNo, segment.segmentNo);
    }

    public int hashCode() {
        return Objects.hash(this.segmentNo);
    }

    public String toString() {
        return this.segmentString;
    }

    public LoadMetadataDetails getLoadMetadataDetails() {
        return this.loadMetadataDetails;
    }

    public long getIndexSize() {
        return this.indexSize;
    }

    public void setIndexSize(long indexSize) {
        this.indexSize = indexSize;
    }

    public boolean isCacheable() {
        return this.isCacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.isCacheable = cacheable;
    }

    public String getSegmentPath() {
        if (this.segmentPath == null && this.loadMetadataDetails != null) {
            this.segmentPath = this.loadMetadataDetails.getPath();
        }
        return this.segmentPath;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public boolean isCarbonSegment() {
        if (this.loadMetadataDetails != null) {
            return this.loadMetadataDetails.isCarbonFormat();
        }
        return true;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.segmentNo);
        boolean writeSegmentFileName = this.segmentFileName != null;
        out.writeBoolean(writeSegmentFileName);
        if (writeSegmentFileName) {
            out.writeUTF(this.segmentFileName);
        }
        out.writeInt(this.filteredIndexShardNames.size());
        for (String name : this.filteredIndexShardNames) {
            out.writeUTF(name);
        }
        if (this.segmentString == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.segmentString);
        }
        out.writeLong(this.indexSize);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.segmentNo = in.readUTF();
        if (in.readBoolean()) {
            this.segmentFileName = in.readUTF();
        }
        this.filteredIndexShardNames = new HashSet<String>();
        int indexShardNameSize = in.readInt();
        for (int i = 0; i < indexShardNameSize; ++i) {
            this.filteredIndexShardNames.add(in.readUTF());
        }
        if (in.readBoolean()) {
            this.segmentString = in.readUTF();
        }
        this.indexSize = in.readLong();
    }

    public SegmentMetaDataInfo getSegmentMetaDataInfo() {
        return this.segmentMetaDataInfo;
    }

    public void setSegmentMetaDataInfo(SegmentMetaDataInfo segmentMetaDataInfo) {
        this.segmentMetaDataInfo = segmentMetaDataInfo;
    }
}

