/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.index.IndexInputSplit;
import org.apache.carbondata.core.index.IndexLevel;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.SegmentIndexGroup;
import org.apache.carbondata.core.index.dev.BlockletSerializer;
import org.apache.carbondata.core.index.dev.Index;
import org.apache.carbondata.core.index.dev.IndexFactory;
import org.apache.carbondata.core.index.dev.cgindex.CoarseGrainIndex;
import org.apache.carbondata.core.index.dev.expr.IndexInputSplitWrapper;
import org.apache.carbondata.core.index.dev.fgindex.FineGrainBlocklet;
import org.apache.carbondata.core.indexstore.Blocklet;
import org.apache.carbondata.core.indexstore.BlockletDetailsFetcher;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.indexstore.SegmentPropertiesFetcher;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.IndexSchema;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.filter.FilterUtil;
import org.apache.carbondata.core.scan.filter.executer.FilterExecuter;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.events.Event;
import org.apache.carbondata.events.OperationContext;
import org.apache.carbondata.events.OperationEventListener;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

@InterfaceAudience.Internal
public final class TableIndex
extends OperationEventListener {
    private CarbonTable table;
    private AbsoluteTableIdentifier identifier;
    private IndexSchema indexSchema;
    private IndexFactory indexFactory;
    private BlockletDetailsFetcher blockletDetailsFetcher;
    private SegmentPropertiesFetcher segmentPropertiesFetcher;
    private static final Logger LOG = LogServiceFactory.getLogService((String)TableIndex.class.getName());

    TableIndex(CarbonTable table, IndexSchema indexSchema, IndexFactory indexFactory, BlockletDetailsFetcher blockletDetailsFetcher, SegmentPropertiesFetcher segmentPropertiesFetcher) {
        this.identifier = table.getAbsoluteTableIdentifier();
        this.table = table;
        this.indexSchema = indexSchema;
        this.indexFactory = indexFactory;
        this.blockletDetailsFetcher = blockletDetailsFetcher;
        this.segmentPropertiesFetcher = segmentPropertiesFetcher;
    }

    public BlockletDetailsFetcher getBlockletDetailsFetcher() {
        return this.blockletDetailsFetcher;
    }

    public CarbonTable getTable() {
        return this.table;
    }

    public List<ExtendedBlocklet> prune(List<Segment> allsegments, IndexFilter filter, List<PartitionSpec> partitions) throws IOException {
        ArrayList<ExtendedBlocklet> blocklets = new ArrayList<ExtendedBlocklet>();
        List<Segment> segments = this.getCarbonSegments(allsegments);
        boolean isFilterPresent = filter != null && !filter.isEmpty();
        Set<Path> partitionLocations = this.getPartitionLocations(partitions);
        Map<Segment, List<Index>> indexes = this.table.isHivePartitionTable() && isFilterPresent && !partitionLocations.isEmpty() ? this.indexFactory.getIndexes(segments, partitionLocations, filter) : this.indexFactory.getIndexes(segments, filter);
        if (indexes.isEmpty()) {
            return blocklets;
        }
        int totalFiles = 0;
        int indexesCount = 0;
        if (isFilterPresent) {
            segments = new ArrayList<Segment>(indexes.keySet());
        }
        for (Segment segment : segments) {
            for (Index index : indexes.get(segment)) {
                totalFiles += index.getNumberOfEntries();
                ++indexesCount;
            }
        }
        int numOfThreadsForPruning = CarbonProperties.getNumOfThreadsForPruning();
        int carbonDriverPruningMultiThreadEnableFilesCount = CarbonProperties.getDriverPruningMultiThreadEnableFilesCount();
        if (numOfThreadsForPruning == 1 || indexesCount < numOfThreadsForPruning || totalFiles < carbonDriverPruningMultiThreadEnableFilesCount) {
            if (filter == null || filter.isEmpty()) {
                return this.pruneWithoutFilter(segments, partitionLocations, blocklets);
            }
            return this.pruneWithFilter(segments, filter, partitionLocations, blocklets, indexes);
        }
        List<ExtendedBlocklet> extendedBlocklets = this.pruneMultiThread(segments, filter, blocklets, indexes, totalFiles);
        return extendedBlocklets;
    }

    private List<Segment> getCarbonSegments(List<Segment> allsegments) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        for (Segment segment : allsegments) {
            if (!segment.isCarbonSegment()) continue;
            segments.add(segment);
        }
        return segments;
    }

    private List<ExtendedBlocklet> pruneWithoutFilter(List<Segment> segments, Set<Path> partitionLocations, List<ExtendedBlocklet> blocklets) throws IOException {
        for (Segment segment : segments) {
            List<Blocklet> allBlocklets = this.blockletDetailsFetcher.getAllBlocklets(segment, partitionLocations);
            blocklets.addAll(this.addSegmentId(this.blockletDetailsFetcher.getExtendedBlocklets(allBlocklets, segment), segment));
        }
        return blocklets;
    }

    private Set<Path> getPartitionLocations(List<PartitionSpec> partitionSpecs) {
        HashSet<Path> partitionsLocations = new HashSet<Path>();
        if (null != partitionSpecs) {
            for (PartitionSpec partitionSpec : partitionSpecs) {
                partitionsLocations.add(partitionSpec.getLocation());
            }
        }
        return partitionsLocations;
    }

    private List<ExtendedBlocklet> pruneWithFilter(List<Segment> segments, IndexFilter filter, Set<Path> partitionLocations, List<ExtendedBlocklet> blocklets, Map<Segment, List<Index>> indexes) throws IOException {
        for (Segment segment : segments) {
            FilterExecuter filterExecuter;
            if (indexes.get(segment).isEmpty() || indexes.get(segment) == null) continue;
            boolean isExternalSegment = segment.getSegmentPath() != null;
            ArrayList<Blocklet> pruneBlocklets = new ArrayList<Blocklet>();
            SegmentProperties segmentProperties = this.segmentPropertiesFetcher.getSegmentProperties(segment, partitionLocations);
            if (filter.isResolvedOnSegment(segmentProperties)) {
                filterExecuter = !isExternalSegment ? FilterUtil.getFilterExecuterTree(filter.getResolver(), segmentProperties, null, this.table.getMinMaxCacheColumns(segmentProperties), false) : FilterUtil.getFilterExecuterTree(filter.getExternalSegmentResolver(), segmentProperties, null, this.table.getMinMaxCacheColumns(segmentProperties), false);
                for (Index index : indexes.get(segment)) {
                    if (!isExternalSegment) {
                        pruneBlocklets.addAll(index.prune(filter.getResolver(), segmentProperties, filterExecuter, this.table));
                        continue;
                    }
                    pruneBlocklets.addAll(index.prune(filter.getExternalSegmentResolver(), segmentProperties, filterExecuter, this.table));
                }
            } else {
                Expression expression = filter.getExpression();
                filterExecuter = !isExternalSegment ? FilterUtil.getFilterExecuterTree(new IndexFilter(segmentProperties, this.table, expression).getResolver(), segmentProperties, null, this.table.getMinMaxCacheColumns(segmentProperties), false) : FilterUtil.getFilterExecuterTree(new IndexFilter(segmentProperties, this.table, expression).getExternalSegmentResolver(), segmentProperties, null, this.table.getMinMaxCacheColumns(segmentProperties), false);
                for (Index index : indexes.get(segment)) {
                    if (!isExternalSegment) {
                        pruneBlocklets.addAll(index.prune(filter.getExpression(), segmentProperties, this.table, filterExecuter));
                        continue;
                    }
                    pruneBlocklets.addAll(index.prune(filter.getExternalSegmentFilter(), segmentProperties, this.table, filterExecuter));
                }
            }
            blocklets.addAll(this.addSegmentId(this.blockletDetailsFetcher.getExtendedBlocklets(pruneBlocklets, segment), segment));
        }
        return blocklets;
    }

    private List<ExtendedBlocklet> pruneMultiThread(List<Segment> segments, final IndexFilter filter, List<ExtendedBlocklet> blocklets, final Map<Segment, List<Index>> indexes, int totalFiles) {
        int numOfThreadsForPruning = CarbonProperties.getNumOfThreadsForPruning();
        int filesPerEachThread = totalFiles / numOfThreadsForPruning;
        int filesCount = 0;
        int processedFileCount = 0;
        ArrayList indexListForEachThread = new ArrayList(numOfThreadsForPruning);
        ArrayList<SegmentIndexGroup> segmentIndexGroupList = new ArrayList<SegmentIndexGroup>();
        for (Segment segment : segments) {
            List<Index> eachSegmentIndexList = indexes.get(segment);
            int prev = 0;
            for (int i = 0; i < eachSegmentIndexList.size(); ++i) {
                Index index = eachSegmentIndexList.get(i);
                if ((filesCount += index.getNumberOfEntries()) < filesPerEachThread) continue;
                if (indexListForEachThread.size() != numOfThreadsForPruning - 1) {
                    segmentIndexGroupList.add(new SegmentIndexGroup(segment, prev, i));
                    prev = i + 1;
                    indexListForEachThread.add(segmentIndexGroupList);
                    segmentIndexGroupList = new ArrayList();
                    processedFileCount += filesCount;
                    filesCount = 0;
                    continue;
                }
                processedFileCount += filesCount;
                filesCount = 0;
            }
            if (prev != 0 && prev == eachSegmentIndexList.size()) continue;
            segmentIndexGroupList.add(new SegmentIndexGroup(segment, prev, eachSegmentIndexList.size() - 1));
        }
        indexListForEachThread.add(segmentIndexGroupList);
        if ((processedFileCount += filesCount) != totalFiles) {
            throw new RuntimeException(" not all the files processed ");
        }
        if (indexListForEachThread.size() < numOfThreadsForPruning) {
            LOG.info((Object)("indexess is distributed in " + indexListForEachThread.size() + " threads"));
            numOfThreadsForPruning = indexListForEachThread.size();
        }
        LOG.info((Object)("Number of threads selected for multi-thread block pruning is " + numOfThreadsForPruning + ". total files: " + totalFiles + ". total segments: " + segments.size()));
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>(numOfThreadsForPruning);
        final ConcurrentHashMap prunedBlockletMap = new ConcurrentHashMap(segments.size());
        ExecutorService executorService = Executors.newFixedThreadPool(numOfThreadsForPruning);
        final String threadName = Thread.currentThread().getName();
        for (int i = 0; i < numOfThreadsForPruning; ++i) {
            final List list = (List)indexListForEachThread.get(i);
            results.add(executorService.submit(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws IOException {
                    Thread.currentThread().setName(threadName);
                    for (SegmentIndexGroup segmentIndexGroup : list) {
                        boolean isExternalSegment;
                        ArrayList pruneBlocklets = new ArrayList();
                        List indexList = (List)indexes.get(segmentIndexGroup.getSegment());
                        SegmentProperties segmentProperties = TableIndex.this.segmentPropertiesFetcher.getSegmentPropertiesFromIndex((Index)indexList.get(0));
                        Segment segment = segmentIndexGroup.getSegment();
                        boolean bl = isExternalSegment = segment.getSegmentPath() != null;
                        if (filter.isResolvedOnSegment(segmentProperties)) {
                            FilterExecuter filterExecuter = !isExternalSegment ? FilterUtil.getFilterExecuterTree(filter.getResolver(), segmentProperties, null, TableIndex.this.table.getMinMaxCacheColumns(segmentProperties), false) : FilterUtil.getFilterExecuterTree(filter.getExternalSegmentResolver(), segmentProperties, null, TableIndex.this.table.getMinMaxCacheColumns(segmentProperties), false);
                            for (int i = segmentIndexGroup.getFromIndex(); i <= segmentIndexGroup.getToIndex(); ++i) {
                                List<Blocklet> dmPruneBlocklets = !isExternalSegment ? ((Index)indexList.get(i)).prune(filter.getResolver(), segmentProperties, filterExecuter, TableIndex.this.table) : ((Index)indexList.get(i)).prune(filter.getExternalSegmentResolver(), segmentProperties, filterExecuter, TableIndex.this.table);
                                pruneBlocklets.addAll(TableIndex.this.addSegmentId(TableIndex.this.blockletDetailsFetcher.getExtendedBlocklets(dmPruneBlocklets, segment), segment));
                            }
                        } else {
                            Expression filterExpression = filter.getNewCopyOfExpression();
                            FilterExecuter filterExecuter = !isExternalSegment ? FilterUtil.getFilterExecuterTree(new IndexFilter(segmentProperties, TableIndex.this.table, filterExpression).getResolver(), segmentProperties, null, TableIndex.this.table.getMinMaxCacheColumns(segmentProperties), false) : FilterUtil.getFilterExecuterTree(new IndexFilter(segmentProperties, TableIndex.this.table, filterExpression).getExternalSegmentResolver(), segmentProperties, null, TableIndex.this.table.getMinMaxCacheColumns(segmentProperties), false);
                            for (int i = segmentIndexGroup.getFromIndex(); i <= segmentIndexGroup.getToIndex(); ++i) {
                                List<Blocklet> dmPruneBlocklets = !isExternalSegment ? ((Index)indexList.get(i)).prune(filterExpression, segmentProperties, TableIndex.this.table, filterExecuter) : ((Index)indexList.get(i)).prune(filter.getExternalSegmentFilter(), segmentProperties, TableIndex.this.table, filterExecuter);
                                pruneBlocklets.addAll(TableIndex.this.addSegmentId(TableIndex.this.blockletDetailsFetcher.getExtendedBlocklets(dmPruneBlocklets, segment), segment));
                            }
                        }
                        Map map = prunedBlockletMap;
                        synchronized (map) {
                            List pruneBlockletsExisting = (List)prunedBlockletMap.get(segmentIndexGroup.getSegment());
                            if (pruneBlockletsExisting != null) {
                                pruneBlockletsExisting.addAll(pruneBlocklets);
                            } else {
                                prunedBlockletMap.put(segmentIndexGroup.getSegment(), pruneBlocklets);
                            }
                        }
                    }
                    return null;
                }
            }));
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(2L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Error in pruning index in multi-thread: " + e.getMessage()));
        }
        for (Future future : results) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        for (Map.Entry entry : prunedBlockletMap.entrySet()) {
            blocklets.addAll((Collection)entry.getValue());
        }
        return blocklets;
    }

    private List<ExtendedBlocklet> addSegmentId(List<ExtendedBlocklet> pruneBlocklets, Segment segment) {
        for (ExtendedBlocklet blocklet : pruneBlocklets) {
            blocklet.setSegment(segment);
        }
        return pruneBlocklets;
    }

    public List<IndexInputSplit> toDistributable(List<Segment> allsegments) {
        ArrayList<IndexInputSplit> distributables = new ArrayList<IndexInputSplit>();
        List<Segment> segments = this.getCarbonSegments(allsegments);
        for (Segment segment : segments) {
            distributables.addAll(this.indexFactory.toDistributable(segment));
        }
        return distributables;
    }

    public IndexInputSplitWrapper toDistributableSegment(Segment segment, String uniqueId) throws IOException {
        return this.indexFactory.toDistributableSegment(segment, this.indexSchema, this.identifier, uniqueId);
    }

    public List<Index> getTableIndexes(IndexInputSplit distributable) throws IOException {
        return this.indexFactory.getIndexes(distributable);
    }

    public List<ExtendedBlocklet> prune(List<Index> indices, IndexInputSplit distributable, FilterResolverIntf filterExp, List<PartitionSpec> partitions) throws IOException {
        ArrayList<ExtendedBlocklet> detailedBlocklets = new ArrayList<ExtendedBlocklet>();
        ArrayList blocklets = new ArrayList();
        Set<Path> partitionsToPrune = this.getPartitionLocations(partitions);
        SegmentProperties segmentProperties = this.segmentPropertiesFetcher.getSegmentProperties(distributable.getSegment(), partitionsToPrune);
        FilterExecuter filterExecuter = FilterUtil.getFilterExecuterTree(filterExp, segmentProperties, null, this.table.getMinMaxCacheColumns(segmentProperties), false);
        for (Index index : indices) {
            blocklets.addAll(index.prune(filterExp, segmentProperties, filterExecuter, this.table));
        }
        BlockletSerializer serializer = new BlockletSerializer();
        String writePath = this.identifier.getTablePath() + "/" + this.indexSchema.getIndexName();
        if (this.indexFactory.getIndexLevel() == IndexLevel.FG) {
            FileFactory.mkdirs(writePath);
        }
        for (Blocklet blocklet : blocklets) {
            ExtendedBlocklet detailedBlocklet = this.blockletDetailsFetcher.getExtendedBlocklet(blocklet, distributable.getSegment());
            if (this.indexFactory.getIndexLevel() == IndexLevel.FG) {
                String blockletwritePath = writePath + "/" + System.nanoTime();
                detailedBlocklet.setIndexWriterPath(blockletwritePath);
                serializer.serializeBlocklet((FineGrainBlocklet)blocklet, blockletwritePath);
            }
            detailedBlocklet.setSegment(distributable.getSegment());
            detailedBlocklets.add(detailedBlocklet);
        }
        return detailedBlocklets;
    }

    public void clear(List<String> segmentIds) {
        for (String segment : segmentIds) {
            this.indexFactory.clear(segment);
        }
    }

    public void clear() {
        if (null != this.indexFactory) {
            this.indexFactory.clear();
        }
    }

    public void deleteIndexData(List<Segment> allsegments) throws IOException {
        List<Segment> segments = this.getCarbonSegments(allsegments);
        for (Segment segment : segments) {
            this.indexFactory.deleteIndexData(segment);
        }
    }

    public void deleteIndexData() {
        this.indexFactory.deleteIndexData();
    }

    public void deleteSegmentIndexData(String segmentNo) throws IOException {
        this.indexFactory.deleteSegmentIndexData(segmentNo);
    }

    public IndexSchema getIndexSchema() {
        return this.indexSchema;
    }

    public IndexFactory getIndexFactory() {
        return this.indexFactory;
    }

    @Override
    public void onEvent(Event event, OperationContext opContext) {
        this.indexFactory.fireEvent(event);
    }

    public Map<String, Long> getBlockRowCount(List<Segment> allsegments, List<PartitionSpec> partitions, TableIndex defaultIndex) throws IOException {
        List<Segment> segments = this.getCarbonSegments(allsegments);
        HashMap<String, Long> blockletToRowCountMap = new HashMap<String, Long>();
        for (Segment segment : segments) {
            List indexes = defaultIndex.getIndexFactory().getIndexes(segment);
            for (CoarseGrainIndex index : indexes) {
                if (null != partitions && index.validatePartitionInfo(partitions)) {
                    return new HashMap<String, Long>();
                }
                index.getRowCountForEachBlock(segment, partitions, blockletToRowCountMap);
            }
        }
        return blockletToRowCountMap;
    }

    public Map<String, Long> getBlockRowCount(TableIndex defaultIndex, List<Segment> allsegments, List<PartitionSpec> partitions) throws IOException {
        List<Segment> segments = this.getCarbonSegments(allsegments);
        HashMap<String, Long> blockletToRowCountMap = new HashMap<String, Long>();
        for (Segment segment : segments) {
            List indexes = defaultIndex.getIndexFactory().getIndexes(segment);
            for (CoarseGrainIndex index : indexes) {
                index.getRowCountForEachBlock(segment, partitions, blockletToRowCountMap);
            }
        }
        return blockletToRowCountMap;
    }

    public long getRowCount(List<Segment> allsegments, List<PartitionSpec> partitions, TableIndex defaultIndex) throws IOException {
        List<Segment> segments = this.getCarbonSegments(allsegments);
        long totalRowCount = 0L;
        for (Segment segment : segments) {
            List indexes = defaultIndex.getIndexFactory().getIndexes(segment);
            for (CoarseGrainIndex index : indexes) {
                totalRowCount += index.getRowCount(segment, partitions);
            }
        }
        return totalRowCount;
    }

    public List<Segment> pruneSegments(List<Segment> segments, FilterResolverIntf filterExp) throws IOException {
        ArrayList<Segment> prunedSegments = new ArrayList<Segment>(16);
        block0: for (Segment segment : segments) {
            List indices = this.indexFactory.getIndexes(segment);
            for (Index index : indices) {
                if (!index.isScanRequired(filterExp)) continue;
                prunedSegments.add(segment);
                continue block0;
            }
        }
        return prunedSegments;
    }
}

