/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.index.dev;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.features.TableOperation;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.index.IndexInputSplit;
import org.apache.carbondata.core.index.IndexLevel;
import org.apache.carbondata.core.index.IndexMeta;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.dev.Index;
import org.apache.carbondata.core.index.dev.IndexBuilder;
import org.apache.carbondata.core.index.dev.IndexWriter;
import org.apache.carbondata.core.index.dev.cgindex.CoarseGrainIndex;
import org.apache.carbondata.core.index.dev.expr.IndexInputSplitWrapper;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.IndexSchema;
import org.apache.carbondata.events.Event;
import org.apache.hadoop.fs.Path;

public abstract class IndexFactory<T extends Index> {
    private CarbonTable carbonTable;
    private IndexSchema indexSchema;

    public IndexFactory(CarbonTable carbonTable, IndexSchema indexSchema) {
        this.carbonTable = carbonTable;
        this.indexSchema = indexSchema;
    }

    public CarbonTable getCarbonTable() {
        return this.carbonTable;
    }

    public void setCarbonTable(CarbonTable carbonTable) {
        this.carbonTable = carbonTable;
    }

    public IndexSchema getIndexSchema() {
        return this.indexSchema;
    }

    public IndexInputSplitWrapper toDistributableSegment(Segment segment, IndexSchema schema, AbsoluteTableIdentifier identifier, String uniqueId) {
        return null;
    }

    public abstract IndexWriter createWriter(Segment var1, String var2, SegmentProperties var3) throws IOException;

    public abstract IndexBuilder createBuilder(Segment var1, String var2, SegmentProperties var3) throws IOException;

    public Map<Segment, List<CoarseGrainIndex>> getIndexes(List<Segment> segments, IndexFilter filter) throws IOException {
        HashMap<Segment, List<CoarseGrainIndex>> indexes = new HashMap<Segment, List<CoarseGrainIndex>>();
        for (Segment segment : segments) {
            indexes.put(segment, this.getIndexes(segment));
        }
        return indexes;
    }

    public Map<Segment, List<CoarseGrainIndex>> getIndexes(List<Segment> segments, Set<Path> partitionLocations, IndexFilter indexFilter) throws IOException {
        HashMap<Segment, List<CoarseGrainIndex>> indexes = new HashMap<Segment, List<CoarseGrainIndex>>();
        for (Segment segment : segments) {
            indexes.put(segment, this.getIndexes(segment, partitionLocations));
        }
        return indexes;
    }

    public abstract List<T> getIndexes(Segment var1) throws IOException;

    public abstract List<T> getIndexes(Segment var1, Set<Path> var2) throws IOException;

    public abstract List<T> getIndexes(IndexInputSplit var1) throws IOException;

    public abstract List<IndexInputSplit> toDistributable(Segment var1);

    public abstract void fireEvent(Event var1);

    public void clear(String segmentNo) {
    }

    public abstract void clear();

    public abstract IndexMeta getMeta();

    public abstract IndexLevel getIndexLevel();

    public abstract void deleteIndexData(Segment var1) throws IOException;

    public abstract void deleteIndexData();

    public void deleteSegmentIndexData(String segmentNo) throws IOException {
    }

    public abstract boolean willBecomeStale(TableOperation var1);

    public boolean isOperationBlocked(TableOperation operation, Object ... targets) {
        return false;
    }

    public boolean supportRebuild() {
        return false;
    }

    public String getCacheSize() {
        return null;
    }
}

