/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.index.dev;

import java.io.IOException;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.datastore.page.ColumnPage;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;

@InterfaceAudience.Developer(value={"Index"})
@InterfaceStability.Evolving
public abstract class IndexWriter {
    protected String tablePath;
    protected String segmentId;
    protected String indexPath;
    protected List<CarbonColumn> indexColumns;
    private boolean isWritingFinished;

    public IndexWriter(String tablePath, String indexName, List<CarbonColumn> indexColumns, Segment segment, String shardName) {
        this.tablePath = tablePath;
        this.segmentId = segment.getSegmentNo();
        this.indexPath = CarbonTablePath.getIndexStorePathOnShardName(tablePath, this.segmentId, indexName, shardName);
        this.indexColumns = indexColumns;
    }

    protected final List<CarbonColumn> getIndexColumns() {
        return this.indexColumns;
    }

    public abstract void onBlockStart(String var1) throws IOException;

    public abstract void onBlockEnd(String var1) throws IOException;

    public abstract void onBlockletStart(int var1) throws IOException;

    public abstract void onBlockletEnd(int var1) throws IOException;

    public abstract void onPageAdded(int var1, int var2, int var3, ColumnPage[] var4) throws IOException;

    public abstract void finish() throws IOException;

    protected void commitFile(String indexFile) throws IOException {
        if (!indexFile.startsWith(this.indexPath)) {
            throw new UnsupportedOperationException("index file " + indexFile + " is not written in provided directory path " + this.indexPath);
        }
        String indexFileName = indexFile.substring(this.indexPath.length(), indexFile.length());
        String carbonFilePath = indexFileName.substring(0, indexFileName.lastIndexOf("/"));
        String segmentPath = CarbonTablePath.getSegmentPath(this.tablePath, this.segmentId);
        if (carbonFilePath.length() > 0) {
            carbonFilePath = segmentPath + carbonFilePath;
            FileFactory.mkdirs(carbonFilePath);
        } else {
            carbonFilePath = segmentPath;
        }
        CarbonUtil.copyCarbonDataFileToCarbonStorePath(indexFile, carbonFilePath, 0L);
    }

    public static String getDefaultIndexPath(String tablePath, String segmentId, String indexName) {
        return CarbonTablePath.getIndexesStorePath(tablePath, segmentId, indexName);
    }

    public boolean isWritingFinished() {
        return this.isWritingFinished;
    }

    public void setWritingFinished(boolean writingFinished) {
        this.isWritingFinished = writingFinished;
    }
}

