/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.index.dev.expr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.index.IndexInputSplit;
import org.apache.carbondata.core.index.IndexLevel;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.TableIndex;
import org.apache.carbondata.core.index.dev.Index;
import org.apache.carbondata.core.index.dev.expr.IndexExprWrapper;
import org.apache.carbondata.core.index.dev.expr.IndexInputSplitWrapper;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.schema.table.IndexSchema;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;

public class IndexExprWrapperImpl
extends IndexExprWrapper {
    private static final long serialVersionUID = -6240385328696074171L;
    private transient TableIndex index;
    private FilterResolverIntf expression;
    private String uniqueId;

    public IndexExprWrapperImpl(TableIndex index, FilterResolverIntf expression) {
        this.index = index;
        this.expression = expression;
        this.uniqueId = UUID.randomUUID().toString();
    }

    @Override
    public List<ExtendedBlocklet> prune(List<Segment> segments, List<PartitionSpec> partitionsToPrune) throws IOException {
        return this.index.prune(segments, new IndexFilter(this.expression), partitionsToPrune);
    }

    @Override
    public List<ExtendedBlocklet> prune(IndexInputSplit distributable, List<PartitionSpec> partitionsToPrune) throws IOException {
        List<Index> indices = this.index.getTableIndexes(distributable);
        return this.index.prune(indices, distributable, this.expression, partitionsToPrune);
    }

    @Override
    public List<ExtendedBlocklet> pruneBlocklets(List<ExtendedBlocklet> blocklets) {
        ArrayList<ExtendedBlocklet> blockletList = new ArrayList<ExtendedBlocklet>();
        for (ExtendedBlocklet blocklet : blocklets) {
            if (!blocklet.getIndexUniqueId().equals(this.uniqueId)) continue;
            blockletList.add(blocklet);
        }
        return blockletList;
    }

    @Override
    public FilterResolverIntf getFilterResolverIntf() {
        return this.expression;
    }

    @Override
    public FilterResolverIntf getFilterResolverIntf(String uniqueId) {
        if (this.uniqueId.equals(uniqueId)) {
            return this.expression;
        }
        return null;
    }

    @Override
    public List<IndexInputSplitWrapper> toDistributable(List<Segment> segments) {
        List<IndexInputSplit> indexInputSplits = this.index.toDistributable(segments);
        ArrayList<IndexInputSplitWrapper> wrappers = new ArrayList<IndexInputSplitWrapper>();
        for (IndexInputSplit distributable : indexInputSplits) {
            wrappers.add(new IndexInputSplitWrapper(this.uniqueId, distributable));
        }
        return wrappers;
    }

    @Override
    public IndexLevel getIndexLevel() {
        return this.index.getIndexFactory().getIndexLevel();
    }

    public IndexSchema getIndexSchema() {
        return this.index.getIndexSchema();
    }

    @Override
    public IndexExprWrapper getLeftIndexWrapper() {
        return null;
    }

    @Override
    public IndexExprWrapper getRightIndexWrapprt() {
        return null;
    }

    @Override
    public IndexInputSplitWrapper toDistributableSegment(Segment segment) throws IOException {
        return this.index.toDistributableSegment(segment, this.uniqueId);
    }
}

