/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.index.dev.expr;

import org.apache.carbondata.core.index.dev.expr.AndIndexExprWrapper;
import org.apache.carbondata.core.index.dev.expr.IndexExprWrapper;
import org.apache.carbondata.core.index.dev.expr.IndexExprWrapperImpl;
import org.apache.carbondata.core.metadata.schema.table.IndexSchema;

public class IndexWrapperSimpleInfo {
    private WrapperType wrapperType;
    private IndexWrapperSimpleInfo left;
    private IndexWrapperSimpleInfo right;
    private IndexSchema schema;

    private IndexWrapperSimpleInfo(WrapperType wrapperType, IndexWrapperSimpleInfo left, IndexWrapperSimpleInfo right) {
        this.wrapperType = wrapperType;
        this.left = left;
        this.right = right;
    }

    private IndexWrapperSimpleInfo(IndexSchema schema) {
        this.wrapperType = WrapperType.PRIMITIVE;
        this.schema = schema;
    }

    public static IndexWrapperSimpleInfo fromIndexWrapper(IndexExprWrapper indexExprWrapper) {
        if (indexExprWrapper instanceof IndexExprWrapperImpl) {
            return new IndexWrapperSimpleInfo(((IndexExprWrapperImpl)indexExprWrapper).getIndexSchema());
        }
        if (indexExprWrapper instanceof AndIndexExprWrapper) {
            return new IndexWrapperSimpleInfo(WrapperType.AND, IndexWrapperSimpleInfo.fromIndexWrapper(indexExprWrapper.getLeftIndexWrapper()), IndexWrapperSimpleInfo.fromIndexWrapper(indexExprWrapper.getRightIndexWrapprt()));
        }
        return new IndexWrapperSimpleInfo(WrapperType.OR, IndexWrapperSimpleInfo.fromIndexWrapper(indexExprWrapper.getLeftIndexWrapper()), IndexWrapperSimpleInfo.fromIndexWrapper(indexExprWrapper.getRightIndexWrapprt()));
    }

    public String getIndexWrapperName() {
        if (WrapperType.PRIMITIVE == this.wrapperType) {
            return this.schema.getIndexName();
        }
        return String.format("%s(%s, %s)", new Object[]{this.wrapperType, this.left.getIndexWrapperName(), this.right.getIndexWrapperName()});
    }

    public String getIndexWrapperProvider() {
        if (WrapperType.PRIMITIVE == this.wrapperType) {
            return this.schema.getProviderName();
        }
        return String.format("%s(%s, %s)", new Object[]{this.wrapperType, this.left.getIndexWrapperProvider(), this.right.getIndexWrapperProvider()});
    }

    public String toString() {
        return "IndexWrapperSchema: Name->" + this.getIndexWrapperName() + ", Provider->" + this.getIndexWrapperProvider();
    }

    static enum WrapperType {
        PRIMITIVE,
        AND,
        OR;

    }
}

