/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.index.dev.expr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.carbondata.core.index.IndexInputSplit;
import org.apache.carbondata.core.index.IndexLevel;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.index.dev.expr.IndexExprWrapper;
import org.apache.carbondata.core.index.dev.expr.IndexInputSplitWrapper;
import org.apache.carbondata.core.indexstore.ExtendedBlocklet;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.scan.filter.resolver.FilterResolverIntf;

public class OrIndexExprWrapper
extends IndexExprWrapper {
    private IndexExprWrapper left;
    private IndexExprWrapper right;
    private FilterResolverIntf resolverIntf;

    public OrIndexExprWrapper(IndexExprWrapper left, IndexExprWrapper right, FilterResolverIntf resolverIntf) {
        this.left = left;
        this.right = right;
        this.resolverIntf = resolverIntf;
    }

    @Override
    public List<ExtendedBlocklet> prune(List<Segment> segments, List<PartitionSpec> partitionsToPrune) throws IOException {
        List<ExtendedBlocklet> leftPrune = this.left.prune(segments, partitionsToPrune);
        List<ExtendedBlocklet> rightPrune = this.right.prune(segments, partitionsToPrune);
        HashSet<ExtendedBlocklet> andBlocklets = new HashSet<ExtendedBlocklet>();
        andBlocklets.addAll(leftPrune);
        andBlocklets.addAll(rightPrune);
        return new ArrayList<ExtendedBlocklet>(andBlocklets);
    }

    @Override
    public List<ExtendedBlocklet> prune(IndexInputSplit distributable, List<PartitionSpec> partitionsToPrune) throws IOException {
        List<ExtendedBlocklet> leftPrune = this.left.prune(distributable, partitionsToPrune);
        List<ExtendedBlocklet> rightPrune = this.right.prune(distributable, partitionsToPrune);
        HashSet<ExtendedBlocklet> andBlocklets = new HashSet<ExtendedBlocklet>();
        andBlocklets.addAll(leftPrune);
        andBlocklets.addAll(rightPrune);
        return new ArrayList<ExtendedBlocklet>(andBlocklets);
    }

    @Override
    public List<ExtendedBlocklet> pruneBlocklets(List<ExtendedBlocklet> blocklets) throws IOException {
        List<ExtendedBlocklet> leftPrune = this.left.pruneBlocklets(blocklets);
        List<ExtendedBlocklet> rightPrune = this.right.pruneBlocklets(blocklets);
        HashSet<ExtendedBlocklet> andBlocklets = new HashSet<ExtendedBlocklet>();
        andBlocklets.addAll(leftPrune);
        andBlocklets.addAll(rightPrune);
        return new ArrayList<ExtendedBlocklet>(andBlocklets);
    }

    @Override
    public List<IndexInputSplitWrapper> toDistributable(List<Segment> segments) throws IOException {
        ArrayList<IndexInputSplitWrapper> wrappers = new ArrayList<IndexInputSplitWrapper>();
        wrappers.addAll(this.left.toDistributable(segments));
        wrappers.addAll(this.right.toDistributable(segments));
        return wrappers;
    }

    @Override
    public FilterResolverIntf getFilterResolverIntf() {
        return this.resolverIntf;
    }

    @Override
    public FilterResolverIntf getFilterResolverIntf(String uniqueId) {
        FilterResolverIntf leftExp = this.left.getFilterResolverIntf(uniqueId);
        FilterResolverIntf rightExp = this.right.getFilterResolverIntf(uniqueId);
        if (leftExp != null) {
            return leftExp;
        }
        if (rightExp != null) {
            return rightExp;
        }
        return null;
    }

    @Override
    public IndexLevel getIndexLevel() {
        return this.left.getIndexLevel();
    }

    @Override
    public IndexExprWrapper getLeftIndexWrapper() {
        return this.left;
    }

    @Override
    public IndexExprWrapper getRightIndexWrapprt() {
        return this.right;
    }
}

