/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.index.dev.fgindex;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.indexstore.Blocklet;
import org.apache.carbondata.core.metadata.schema.table.Writable;
import org.apache.carbondata.core.util.BitSetGroup;

@InterfaceAudience.Developer(value={"Index"})
@InterfaceStability.Evolving
public class FineGrainBlocklet
extends Blocklet
implements Serializable {
    private List<Page> pages;

    public FineGrainBlocklet(String shardName, String blockletId, List<Page> pages) {
        super(shardName, blockletId);
        this.pages = pages;
    }

    public FineGrainBlocklet() {
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public BitSetGroup getBitSetGroup(int numberOfPages) {
        BitSetGroup bitSetGroup = new BitSetGroup(numberOfPages);
        for (int i = 0; i < this.pages.size(); ++i) {
            bitSetGroup.setBitSet(this.pages.get(i).getBitSet(), this.pages.get(i).pageId);
        }
        return bitSetGroup;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        int size = this.pages.size();
        out.writeInt(size);
        for (Page page : this.pages) {
            page.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int size = in.readInt();
        this.pages = new ArrayList<Page>(size);
        for (int i = 0; i < size; ++i) {
            Page page = new Page();
            page.readFields(in);
            this.pages.add(page);
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static class Page
    implements Writable,
    Serializable {
        private int pageId;
        private int[] rowId;

        public BitSet getBitSet() {
            BitSet bitSet = new BitSet(32000);
            for (int row : this.rowId) {
                bitSet.set(row);
            }
            return bitSet;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeInt(this.pageId);
            out.writeInt(this.rowId.length);
            for (int i = 0; i < this.rowId.length; ++i) {
                out.writeInt(this.rowId[i]);
            }
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.pageId = in.readInt();
            int length = in.readInt();
            this.rowId = new int[length];
            for (int i = 0; i < length; ++i) {
                this.rowId[i] = in.readInt();
            }
        }

        public void setPageId(int pageId) {
            this.pageId = pageId;
        }

        public void setRowId(int[] rowId) {
            this.rowId = rowId;
        }
    }
}

