/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.Writable;

public class Blocklet
implements Writable,
Serializable {
    private String filePath;
    private String blockletId;
    private boolean compareBlockletIdForObjectMatching = true;

    public Blocklet(String filePath, String blockletId) {
        this.filePath = filePath;
        this.blockletId = blockletId;
    }

    public Blocklet(String filePath, String blockletId, boolean compareBlockletIdForObjectMatching) {
        this(filePath, blockletId);
        this.compareBlockletIdForObjectMatching = compareBlockletIdForObjectMatching;
    }

    public Blocklet() {
    }

    public String getBlockletId() {
        return this.blockletId;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void write(DataOutput out) throws IOException {
        if (this.filePath == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.filePath);
        }
        if (this.blockletId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.blockletId);
        }
        out.writeBoolean(this.compareBlockletIdForObjectMatching);
    }

    public void readFields(DataInput in) throws IOException {
        if (in.readBoolean()) {
            this.filePath = in.readUTF();
        }
        if (in.readBoolean()) {
            this.blockletId = in.readUTF();
        }
        this.compareBlockletIdForObjectMatching = in.readBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Blocklet blocklet = (Blocklet)o;
        if (this.filePath != null ? !this.filePath.equals(blocklet.filePath) : blocklet.filePath != null) {
            return false;
        }
        if (!this.compareBlockletIdForObjectMatching) {
            return true;
        }
        return this.blockletId != null ? this.blockletId.equals(blocklet.blockletId) : blocklet.blockletId == null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Blocklet{");
        sb.append("filePath='").append(this.filePath).append('\'');
        sb.append(", blockletId='").append(this.blockletId).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        int result = this.filePath != null ? this.filePath.hashCode() : 0;
        result = 31 * result;
        if (this.compareBlockletIdForObjectMatching) {
            result += this.blockletId != null ? this.blockletId.hashCode() : 0;
        }
        return result;
    }
}

