/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.blocklet.BlockletInfo;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.util.BlockletIndexUtil;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class BlockletDetailInfo
implements Serializable,
Writable {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)BlockletDetailInfo.class.getName());
    private static final long serialVersionUID = 7957493757421513808L;
    private int rowCount;
    private short pagesCount;
    private short versionNumber;
    private short blockletId = (short)-1;
    private long schemaUpdatedTimeStamp;
    private BlockletInfo blockletInfo;
    private byte[] blockletInfoBinary;
    private long blockFooterOffset;
    private List<ColumnSchema> columnSchemas;
    private byte[] columnSchemaBinary;
    private long blockSize;
    private boolean useMinMaxForPruning = true;

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public int getPagesCount() {
        return this.pagesCount;
    }

    public void setPagesCount(short pagesCount) {
        this.pagesCount = pagesCount;
    }

    public short getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(short versionNumber) {
        this.versionNumber = versionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockletInfo getBlockletInfo() {
        if (null == this.blockletInfo) {
            try {
                BlockletDetailInfo blockletDetailInfo = this;
                synchronized (blockletDetailInfo) {
                    if (null == this.blockletInfo) {
                        this.setBlockletInfoFromBinary();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.blockletInfo;
    }

    public void setBlockletInfo(BlockletInfo blockletInfo) {
        this.blockletInfo = blockletInfo;
    }

    private void setBlockletInfoFromBinary() throws IOException {
        if (null == this.blockletInfo && null != this.blockletInfoBinary && this.blockletInfoBinary.length > 0) {
            this.blockletInfo = new BlockletInfo();
            ByteArrayInputStream stream = new ByteArrayInputStream(this.blockletInfoBinary);
            DataInputStream inputStream = new DataInputStream(stream);
            try {
                this.blockletInfo.readFields(inputStream);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Problem in reading blocklet info", (Throwable)e);
                throw new IOException("Problem in reading blocklet info." + e.getMessage(), e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Problem in closing input stream of reading blocklet info.", (Throwable)e);
                }
            }
        }
    }

    public long getSchemaUpdatedTimeStamp() {
        return this.schemaUpdatedTimeStamp;
    }

    public void setSchemaUpdatedTimeStamp(long schemaUpdatedTimeStamp) {
        this.schemaUpdatedTimeStamp = schemaUpdatedTimeStamp;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.rowCount);
        out.writeShort(this.pagesCount);
        out.writeShort(this.versionNumber);
        out.writeShort(this.blockletId);
        out.writeLong(this.schemaUpdatedTimeStamp);
        out.writeBoolean(this.blockletInfo != null);
        if (this.blockletInfo != null) {
            this.blockletInfo.write(out);
        }
        out.writeLong(this.blockFooterOffset);
        this.convertColumnSchemaToBinary();
        if (null != this.columnSchemaBinary) {
            out.writeInt(this.columnSchemaBinary.length);
            out.write(this.columnSchemaBinary);
        } else {
            out.writeInt(-1);
        }
        out.writeInt(this.blockletInfoBinary.length);
        out.write(this.blockletInfoBinary);
        out.writeLong(this.blockSize);
        out.writeBoolean(this.useMinMaxForPruning);
    }

    public void readFields(DataInput in) throws IOException {
        this.rowCount = in.readInt();
        this.pagesCount = in.readShort();
        this.versionNumber = in.readShort();
        this.blockletId = in.readShort();
        this.schemaUpdatedTimeStamp = in.readLong();
        if (in.readBoolean()) {
            this.blockletInfo = new BlockletInfo();
            this.blockletInfo.readFields(in);
        }
        this.blockFooterOffset = in.readLong();
        int bytesSize = in.readInt();
        if (bytesSize != -1) {
            byte[] schemaArray = new byte[bytesSize];
            in.readFully(schemaArray);
            this.readColumnSchema(schemaArray);
        }
        int byteSize = in.readInt();
        this.blockletInfoBinary = new byte[byteSize];
        in.readFully(this.blockletInfoBinary);
        this.setBlockletInfoFromBinary();
        this.blockSize = in.readLong();
        this.useMinMaxForPruning = in.readBoolean();
    }

    public void readColumnSchema(byte[] schemaArray) throws IOException {
        if (null != schemaArray) {
            this.columnSchemas = BlockletIndexUtil.readColumnSchema(schemaArray);
        }
    }

    private void convertColumnSchemaToBinary() throws IOException {
        if (null != this.columnSchemas) {
            this.columnSchemaBinary = BlockletIndexUtil.convertSchemaToBinary(this.columnSchemas);
        }
    }

    public BlockletDetailInfo copy() {
        BlockletDetailInfo detailInfo = new BlockletDetailInfo();
        detailInfo.rowCount = this.rowCount;
        detailInfo.pagesCount = this.pagesCount;
        detailInfo.versionNumber = this.versionNumber;
        detailInfo.blockletId = this.blockletId;
        detailInfo.schemaUpdatedTimeStamp = this.schemaUpdatedTimeStamp;
        detailInfo.blockletInfo = this.blockletInfo;
        detailInfo.blockletInfoBinary = this.blockletInfoBinary;
        detailInfo.blockFooterOffset = this.blockFooterOffset;
        detailInfo.columnSchemas = this.columnSchemas;
        detailInfo.columnSchemaBinary = this.columnSchemaBinary;
        detailInfo.blockSize = this.blockSize;
        detailInfo.useMinMaxForPruning = this.useMinMaxForPruning;
        return detailInfo;
    }

    public Short getBlockletId() {
        return this.blockletId;
    }

    public void setBlockletId(Short blockletId) {
        this.blockletId = blockletId;
    }

    public long getBlockFooterOffset() {
        return this.blockFooterOffset;
    }

    public void setBlockFooterOffset(long blockFooterOffset) {
        this.blockFooterOffset = blockFooterOffset;
    }

    public List<ColumnSchema> getColumnSchemas() throws IOException {
        if (this.columnSchemas == null && this.columnSchemaBinary != null) {
            this.readColumnSchema(this.columnSchemaBinary);
        }
        return this.columnSchemas;
    }

    public byte[] getColumnSchemaBinary() {
        return this.columnSchemaBinary;
    }

    public void setBlockletInfoBinary(byte[] blockletInfoBinary) {
        this.blockletInfoBinary = blockletInfoBinary;
    }

    public void setColumnSchemas(List<ColumnSchema> columnSchemas) {
        this.columnSchemas = columnSchemas;
    }

    public boolean isUseMinMaxForPruning() {
        return this.useMinMaxForPruning;
    }

    public void setUseMinMaxForPruning(boolean useMinMaxForPruning) {
        this.useMinMaxForPruning = useMinMaxForPruning;
    }
}

