/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.core.indexstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.cache.Cache;
import org.apache.carbondata.core.cache.CarbonLRUCache;
import org.apache.carbondata.core.datastore.block.SegmentPropertiesAndSchemaHolder;
import org.apache.carbondata.core.index.dev.Index;
import org.apache.carbondata.core.indexstore.BlockMetaInfo;
import org.apache.carbondata.core.indexstore.BlockletIndexWrapper;
import org.apache.carbondata.core.indexstore.TableBlockIndexUniqueIdentifier;
import org.apache.carbondata.core.indexstore.TableBlockIndexUniqueIdentifierWrapper;
import org.apache.carbondata.core.indexstore.blockletindex.BlockIndex;
import org.apache.carbondata.core.indexstore.blockletindex.BlockletIndexFactory;
import org.apache.carbondata.core.indexstore.blockletindex.BlockletIndexModel;
import org.apache.carbondata.core.indexstore.blockletindex.SegmentIndexFileStore;
import org.apache.carbondata.core.metadata.blocklet.DataFileFooter;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.util.BlockletIndexUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class BlockletIndexStore
implements Cache<TableBlockIndexUniqueIdentifierWrapper, BlockletIndexWrapper> {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)BlockletIndexStore.class.getName());
    protected CarbonLRUCache lruCache;
    private Map<String, Object> segmentLockMap;

    public BlockletIndexStore(CarbonLRUCache lruCache) {
        this.lruCache = lruCache;
        this.segmentLockMap = new ConcurrentHashMap<String, Object>();
    }

    @Override
    public BlockletIndexWrapper get(TableBlockIndexUniqueIdentifierWrapper identifierWrapper) {
        return this.get(identifierWrapper, null);
    }

    public BlockletIndexWrapper get(TableBlockIndexUniqueIdentifierWrapper identifierWrapper, Map<String, Map<String, BlockMetaInfo>> segInfoCache) {
        TableBlockIndexUniqueIdentifier identifier = identifierWrapper.getTableBlockIndexUniqueIdentifier();
        String lruCacheKey = identifier.getUniqueTableSegmentIdentifier();
        BlockletIndexWrapper blockletIndexWrapper = (BlockletIndexWrapper)this.lruCache.get(lruCacheKey);
        ArrayList<BlockIndex> indexes = new ArrayList<BlockIndex>();
        if (blockletIndexWrapper == null) {
            try {
                Map<String, BlockMetaInfo> carbonDataFileBlockMetaInfoMapping;
                SegmentIndexFileStore indexFileStore = new SegmentIndexFileStore(identifierWrapper.getConfiguration());
                HashSet<String> filesRead = new HashSet<String>();
                String string = identifier.getIndexFilePath();
                if (segInfoCache == null) {
                    segInfoCache = new HashMap<String, Map<String, BlockMetaInfo>>();
                }
                if ((carbonDataFileBlockMetaInfoMapping = segInfoCache.get(string)) == null) {
                    carbonDataFileBlockMetaInfoMapping = BlockletIndexUtil.createCarbonDataFileBlockMetaInfoMapping(string, identifierWrapper.getConfiguration());
                    segInfoCache.put(string, carbonDataFileBlockMetaInfoMapping);
                }
                if (identifier.getMergeIndexFileName() == null) {
                    ArrayList<DataFileFooter> indexInfos = new ArrayList<DataFileFooter>();
                    Map<String, BlockMetaInfo> blockMetaInfoMap = BlockletIndexUtil.getBlockMetaInfoMap(identifierWrapper, indexFileStore, filesRead, carbonDataFileBlockMetaInfoMapping, indexInfos);
                    BlockIndex blockIndex = this.loadAndGetIndex(identifier, indexFileStore, blockMetaInfoMap, identifierWrapper.getCarbonTable(), identifierWrapper.isAddToUnsafe(), identifierWrapper.getConfiguration(), identifierWrapper.isSerializeDmStore(), indexInfos);
                    indexes.add(blockIndex);
                    blockletIndexWrapper = new BlockletIndexWrapper(identifier.getSegmentId(), indexes);
                } else {
                    List<TableBlockIndexUniqueIdentifier> tableBlockIndexUniqueIdentifiers = BlockletIndexUtil.getIndexFileIdentifiersFromMergeFile(identifier, indexFileStore);
                    for (TableBlockIndexUniqueIdentifier blockIndexUniqueIdentifier : tableBlockIndexUniqueIdentifiers) {
                        ArrayList<DataFileFooter> indexInfos = new ArrayList<DataFileFooter>();
                        Map<String, BlockMetaInfo> blockMetaInfoMap = BlockletIndexUtil.getBlockMetaInfoMap(new TableBlockIndexUniqueIdentifierWrapper(blockIndexUniqueIdentifier, identifierWrapper.getCarbonTable()), indexFileStore, filesRead, carbonDataFileBlockMetaInfoMapping, indexInfos);
                        if (blockMetaInfoMap.isEmpty()) continue;
                        BlockIndex blockIndex = this.loadAndGetIndex(blockIndexUniqueIdentifier, indexFileStore, blockMetaInfoMap, identifierWrapper.getCarbonTable(), identifierWrapper.isAddToUnsafe(), identifierWrapper.getConfiguration(), identifierWrapper.isSerializeDmStore(), indexInfos);
                        indexes.add(blockIndex);
                    }
                    blockletIndexWrapper = new BlockletIndexWrapper(identifier.getSegmentId(), indexes);
                }
                if (identifierWrapper.isAddTableBlockToUnsafeAndLRUCache()) {
                    long expiration_time = CarbonUtil.getExpiration_time(identifierWrapper.getCarbonTable());
                    this.lruCache.put(identifier.getUniqueTableSegmentIdentifier(), blockletIndexWrapper, blockletIndexWrapper.getMemorySize(), expiration_time);
                }
            }
            catch (Throwable e) {
                for (Index index : indexes) {
                    index.clear();
                }
                LOGGER.error((Object)("memory exception when loading index: " + e.getMessage()), e);
                throw new RuntimeException(e);
            }
        }
        return blockletIndexWrapper;
    }

    @Override
    public List<BlockletIndexWrapper> getAll(List<TableBlockIndexUniqueIdentifierWrapper> tableSegmentUniqueIdentifiers) throws IOException {
        HashMap<String, Map<String, BlockMetaInfo>> segInfoCache = new HashMap<String, Map<String, BlockMetaInfo>>();
        ArrayList<BlockletIndexWrapper> blockletIndexWrappers = new ArrayList<BlockletIndexWrapper>(tableSegmentUniqueIdentifiers.size());
        ArrayList<TableBlockIndexUniqueIdentifierWrapper> missedIdentifiersWrapper = new ArrayList<TableBlockIndexUniqueIdentifierWrapper>();
        BlockletIndexWrapper blockletIndexWrapper = null;
        try {
            for (TableBlockIndexUniqueIdentifierWrapper identifierWrapper : tableSegmentUniqueIdentifiers) {
                BlockletIndexWrapper indexWrapper = this.getIfPresent(identifierWrapper);
                if (indexWrapper != null) {
                    blockletIndexWrappers.add(indexWrapper);
                    continue;
                }
                missedIdentifiersWrapper.add(identifierWrapper);
            }
            if (missedIdentifiersWrapper.size() > 0) {
                for (TableBlockIndexUniqueIdentifierWrapper identifierWrapper : missedIdentifiersWrapper) {
                    blockletIndexWrapper = this.get(identifierWrapper, segInfoCache);
                    blockletIndexWrappers.add(blockletIndexWrapper);
                }
            }
        }
        catch (Throwable e) {
            if (null != blockletIndexWrapper) {
                List<BlockIndex> indexes = blockletIndexWrapper.getIndexes();
                for (Index index : indexes) {
                    index.clear();
                }
            }
            throw new IOException("Problem in loading segment blocks: " + e.getMessage(), e);
        }
        return blockletIndexWrappers;
    }

    @Override
    public BlockletIndexWrapper getIfPresent(TableBlockIndexUniqueIdentifierWrapper tableSegmentUniqueIdentifierWrapper) {
        return (BlockletIndexWrapper)this.lruCache.get(tableSegmentUniqueIdentifierWrapper.getTableBlockIndexUniqueIdentifier().getUniqueTableSegmentIdentifier());
    }

    @Override
    public void invalidate(TableBlockIndexUniqueIdentifierWrapper tableSegmentUniqueIdentifierWrapper) {
        List<BlockIndex> indexes;
        BlockletIndexWrapper blockletIndexWrapper = this.getIfPresent(tableSegmentUniqueIdentifierWrapper);
        if (null != blockletIndexWrapper && null != (indexes = blockletIndexWrapper.getIndexes()) && !indexes.isEmpty()) {
            String segmentId = tableSegmentUniqueIdentifierWrapper.getTableBlockIndexUniqueIdentifier().getSegmentId();
            SegmentPropertiesAndSchemaHolder.getInstance().invalidate(segmentId, indexes.get(0).getSegmentPropertiesWrapper(), tableSegmentUniqueIdentifierWrapper.isAddTableBlockToUnsafeAndLRUCache());
        }
        this.lruCache.remove(tableSegmentUniqueIdentifierWrapper.getTableBlockIndexUniqueIdentifier().getUniqueTableSegmentIdentifier());
    }

    @Override
    public void put(TableBlockIndexUniqueIdentifierWrapper tableBlockIndexUniqueIdentifierWrapper, BlockletIndexWrapper wrapper) throws IOException {
        if (null == this.getIfPresent(tableBlockIndexUniqueIdentifierWrapper)) {
            List<BlockIndex> indexes = wrapper.getIndexes();
            try {
                for (BlockIndex blockIndex : indexes) {
                    blockIndex.convertToUnsafeDMStore();
                }
                long expirationTime = CarbonUtil.getExpiration_time(tableBlockIndexUniqueIdentifierWrapper.getCarbonTable());
                this.lruCache.put(tableBlockIndexUniqueIdentifierWrapper.getTableBlockIndexUniqueIdentifier().getUniqueTableSegmentIdentifier(), wrapper, wrapper.getMemorySize(), expirationTime);
            }
            catch (Throwable e) {
                for (Index index : indexes) {
                    index.clear();
                }
                throw new IOException("Problem in adding index to cache.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockIndex loadAndGetIndex(TableBlockIndexUniqueIdentifier identifier, SegmentIndexFileStore indexFileStore, Map<String, BlockMetaInfo> blockMetaInfoMap, CarbonTable carbonTable, boolean addTableBlockToUnsafe, Configuration configuration, boolean serializeDmStore, List<DataFileFooter> indexInfos) throws IOException {
        BlockIndex blockIndex;
        String uniqueTableSegmentIdentifier = identifier.getUniqueTableSegmentIdentifier();
        Object lock = this.segmentLockMap.get(uniqueTableSegmentIdentifier);
        if (lock == null) {
            lock = this.addAndGetSegmentLock(uniqueTableSegmentIdentifier);
        }
        Object object = lock;
        synchronized (object) {
            blockIndex = (BlockIndex)BlockletIndexFactory.createIndex(carbonTable);
            BlockletIndexModel blockletIndexModel = new BlockletIndexModel(carbonTable, identifier.getIndexFilePath() + "/" + identifier.getIndexFileName(), indexFileStore.getFileData(identifier.getIndexFileName()), blockMetaInfoMap, identifier.getSegmentId(), addTableBlockToUnsafe, configuration, serializeDmStore);
            blockletIndexModel.setIndexInfos(indexInfos);
            blockIndex.init(blockletIndexModel);
        }
        return blockIndex;
    }

    private synchronized Object addAndGetSegmentLock(String uniqueIdentifier) {
        Object segmentLoderLockObject = this.segmentLockMap.get(uniqueIdentifier);
        if (null == segmentLoderLockObject) {
            segmentLoderLockObject = new Object();
            this.segmentLockMap.put(uniqueIdentifier, segmentLoderLockObject);
        }
        return segmentLoderLockObject;
    }

    @Override
    public void clearAccessCount(List<TableBlockIndexUniqueIdentifierWrapper> tableSegmentUniqueIdentifiersWrapper) {
        for (TableBlockIndexUniqueIdentifierWrapper identifierWrapper : tableSegmentUniqueIdentifiersWrapper) {
            BlockIndex cacheable = (BlockIndex)((Object)this.lruCache.get(identifierWrapper.getTableBlockIndexUniqueIdentifier().getUniqueTableSegmentIdentifier()));
            cacheable.clear();
        }
    }
}

